/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.management.impl;

import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.DSContainer;
import com.adobe.idp.dsc.management.Archive;
import com.adobe.idp.dsc.management.ArchiveFileManager;
import com.adobe.idp.dsc.management.ArchiveNotFoundException;
import com.adobe.idp.dsc.management.ArchiveStoreException;
import com.adobe.idp.dsc.management.TransientArchive;
import com.adobe.idp.dsc.management.impl.ArchiveStoreImpl;
import com.adobe.idp.dsc.transaction.TransactionCallback;
import com.adobe.idp.dsc.transaction.TransactionTemplate;
import com.adobe.jmx.JmxPortability;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ArchiveFileManagerImpl
implements ArchiveFileManager {
    public static final String ADOBE_PREFIX = "com.adobe.idp.";
    public static final String ADOBE_TEMP_DIR_PROP = "AdobeTempDir";
    public static final String ARCHIVE_STORE_BASE_DIR = "ArchiveStore";
    public static final String LCA_FILE_SUFFIX = ".lca";
    public static final String NOT_SPECIFIED = "Not Specified";
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    public static final Logger log = Logger.getLogger(ArchiveFileManagerImpl.class.getName());
    protected static ArchiveFileManager singleton = null;
    protected String localCacheRootDir = null;

    public static synchronized ArchiveFileManager getInstance() {
        if (singleton != null) {
            return singleton;
        }
        singleton = new ArchiveFileManagerImpl();
        return singleton;
    }

    public synchronized File getArchiveDirectory(Archive archive) throws ArchiveNotFoundException, ArchiveStoreException {
        if (archive == null) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "ArchiveFileManagerImpl:getArchiveDirectory:archive parameter is null");
            }
            throw new ArchiveStoreException("archive parameter is null");
        }
        File rootDir = new File(this.getLocalCacheArchiveDir(archive));
        if (!rootDir.exists()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, Thread.currentThread().getName() + " ArchiveFileManagerImpl:getArchiveDirectory:inflating archive:" + archive.getId());
            }
            this.inflateArchiveIntoLocalCache(archive);
        }
        return rootDir;
    }

    public byte[] getArchiveFile(Archive archive, String relativePath) throws ArchiveNotFoundException, ArchiveStoreException {
        if (archive == null) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "ArchiveFileManagerImpl:getArchiveDirectory:archive parameter is null");
            }
            throw new ArchiveStoreException("archive parameter is null");
        }
        try {
            File directory = this.getArchiveDirectory(archive);
            String[] contents = directory.list();
            File file = new File(directory, relativePath);
            byte[] bytes = new byte[(int)file.length()];
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file), 2048);
            bis.read(bytes, 0, (int)file.length());
            bis.close();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, Thread.currentThread().getName() + " ArchiveFileManagerImpl:getArchiveFile:" + relativePath + ":read " + file.length() + " bytes" + archive.getId() + "_" + archive.getName());
            }
            return bytes;
        }
        catch (FileNotFoundException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, Thread.currentThread().getName() + "ArchiveFileManagerImpl:getArchiveFile:" + relativePath + " does not contain targeted class file, continue to search the classpath.");
            }
            throw new ArchiveNotFoundException(e);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "ArchiveFileManagerImpl:getArchiveFile(): " + relativePath + ":IOException: " + e.getMessage());
            throw new ArchiveStoreException(e);
        }
    }

    protected void inflateInnerFile(File directory, File file) throws IOException {
        byte[] buffer = new byte[2048];
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
        JarEntry _entry = null;
        while ((_entry = jarInputStream.getNextJarEntry()) != null) {
            int count;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Inner Jar file entry is  " + _entry.getName());
            }
            if (_entry.getName().startsWith("META-INF")) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "Skipping file  " + _entry.getName());
                continue;
            }
            File entryFile = new File(directory, _entry.getName());
            if (_entry.isDirectory()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Inner Jar file entry " + _entry.getName() + " is a directory.");
                }
                entryFile.mkdirs();
                continue;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(entryFile);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
            while ((count = jarInputStream.read(buffer, 0, 2048)) != -1) {
                bufferedOutputStream.write(buffer, 0, count);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
    }

    public void invalidateArchiveCache(long archiveId) throws ArchiveNotFoundException, ArchiveStoreException {
        this.removeArchiveFromLocalCache(archiveId);
    }

    protected String getLocalCacheRootDir() {
        if (this.localCacheRootDir != null) {
            return this.localCacheRootDir;
        }
        String tmpdir = ArchiveFileManagerImpl.getConfigParamString(ADOBE_TEMP_DIR_PROP);
        if (tmpdir != null && tmpdir.length() > 0) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "ArchiveFileManagerImpl:getLocalCacheRootDir():Adobe tmp directory is:" + tmpdir);
            }
        } else {
            tmpdir = System.getProperty("java.io.tmpdir");
            if (tmpdir != null && tmpdir.length() > 0) {
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "ArchiveFileManagerImpl:getLocalCacheRootDir():java.io.tmpdir is " + tmpdir);
                }
            } else if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "ArchiveFileManagerImpl:getLocalCacheRootDir():java.io.tmpdir is null");
            }
        }
        this.localCacheRootDir = tmpdir = tmpdir + (tmpdir.endsWith(File.separator) ? "" : File.separator) + ARCHIVE_STORE_BASE_DIR;
        return this.localCacheRootDir;
    }

    protected String getLocalCacheArchiveDir(Archive archive) {
        return this.getLocalCacheArchiveDir(archive.getId());
    }

    protected String getLocalCacheArchiveDir(long archiveId) {
        return this.getLocalCacheRootDir() + File.separator + archiveId;
    }

    protected void inflateArchiveIntoLocalCache(Archive archive) throws ArchiveStoreException {
        long startTime = ArchiveStoreImpl.getStartTime();
        try {
            TransactionTemplate _tx = DSContainer.getInstance().getTransactionTemplate();
            _tx.setPropagationType(3);
            _tx.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (DSCException ex) {
            throw new ArchiveStoreException(ex.getCause());
        }
        finally {
            ArchiveStoreImpl.reportPerformance((long)startTime);
        }
    }

    protected void removeArchiveFromLocalCache(long archiveId) {
        this.deleteDirectory(new File(this.getLocalCacheArchiveDir(archiveId)));
    }

    public void invalidateArchiveCache() {
        this.deleteDirectory(new File(this.getLocalCacheRootDir()));
    }

    protected void deleteDirectory(File path) {
        if (!path.exists()) {
            return;
        }
        File[] files = path.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.deleteDirectory(files[i]);
                continue;
            }
            files[i].delete();
        }
        path.delete();
    }

    protected String getTransientArchiveDirectoryPath(TransientArchive transientArchive) throws ArchiveStoreException {
        return this.getLocalCacheRootDir() + File.separator + transientArchive.getId();
    }

    public File getTransientArchiveDirectory(TransientArchive transientArchive) throws ArchiveStoreException {
        return new File(this.getTransientArchiveDirectoryPath(transientArchive));
    }

    public File getTransientArchiveFile(TransientArchive transientArchive, String relativePath) throws ArchiveStoreException {
        File archiveDir = this.getTransientArchiveDirectory(transientArchive);
        if (!archiveDir.exists()) {
            archiveDir.mkdir();
        }
        return new File(archiveDir, relativePath);
    }

    public File getTransientArchive(TransientArchive transientArchive) throws ArchiveStoreException {
        try {
            String transientArchivePath = this.getTransientArchiveDirectoryPath(transientArchive);
            File archiveFile = new File(transientArchivePath + LCA_FILE_SUFFIX);
            JarOutputStream jar = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(archiveFile), 2048));
            jar.setMethod(8);
            this.addDirectoryToArchive(jar, this.getTransientArchiveDirectory(transientArchive), transientArchivePath + File.separator);
            jar.close();
            return archiveFile;
        }
        catch (IOException e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "ArchiveFileManagerImpl:getTransientArchive:IOException:" + e.getMessage());
            }
            throw new ArchiveStoreException(e);
        }
    }

    protected void addDirectoryToArchive(JarOutputStream jar, File path, String basePath) throws IOException {
        if (!path.exists()) {
            this.addFileToArchive(jar, path, basePath);
        }
        File[] files = path.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addDirectoryToArchive(jar, files[i], basePath);
                continue;
            }
            this.addFileToArchive(jar, files[i], basePath);
        }
    }

    protected void addFileToArchive(JarOutputStream jar, File path, String basePath) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "ArchiveFileManagerImpl:addFileToArchive():adding " + path.getPath());
        }
        byte[] data = new byte[2048];
        BufferedInputStream source = new BufferedInputStream(new FileInputStream(path), 2048);
        JarEntry entry = new JarEntry(path.getPath().substring(basePath.length()));
        jar.putNextEntry(entry);
        if (!path.isDirectory()) {
            int count;
            while ((count = source.read(data, 0, 2048)) != -1) {
                jar.write(data, 0, count);
            }
            source.close();
        }
    }

    public void invalidateTransientArchive(TransientArchive transientArchive) throws ArchiveStoreException {
        this.deleteDirectory(this.getTransientArchiveDirectory(transientArchive));
    }

    public static String getConfigParamString(String paramName) {
        String val = System.getProperty(ADOBE_PREFIX + paramName);
        if (val != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "ArchiveFileManagerImpl:getConfigParamString():" + paramName + "was set in a system property." + " The value is \"" + val + "\"");
            }
            return val;
        }
        val = (String)ArchiveFileManagerImpl.getDataManagerJmxAttr(paramName);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "ArchiveFileManagerImpl:getConfigParamString():" + paramName + "was set as a DataManager JMX property." + " The value is \"" + (val != null ? val : "null") + "\"");
        }
        return val;
    }

    public static Object getDataManagerJmxAttr(String attrName) {
        MBeanServer mbs = JmxPortability.mBeanServer;
        ObjectName name = JmxPortability.makeName((String)JmxPortability.ADOBE_SERVICE_TYPE, (String)"DataManagerService");
        try {
            return AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (PrivilegedActionException e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "ArchiveFileManagerImpl:getDataManagerJmxAttr:failed to resolve JMX attribute:" + attrName);
            }
            return null;
        }
    }
}

