/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.impl;

import com.adobe.idp.dsc.DSCError;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.InvocationResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class InvocationResponseImpl
implements InvocationResponse,
Serializable {
    static final long serialVersionUID = -8874216354552654931L;
    protected Map m_parameters;
    protected Map m_clientParameters;
    protected String m_jobId;
    protected Properties m_properties = new Properties();
    protected Throwable m_cause;
    protected long m_invocationId;

    public InvocationResponseImpl() {
        this.m_parameters = new HashMap();
    }

    public void setOutputParameter(String outputParamName, Object value) {
        this.m_parameters.put(outputParamName, value);
    }

    public void setOutputParameters(Map aMap) {
        this.m_parameters.putAll(aMap);
    }

    public Object getOutputParameter(String outputParamName) {
        return this.m_parameters.get(outputParamName);
    }

    public Object getOutputParameter() {
        Set keyes = this.m_parameters.keySet();
        if (!keyes.isEmpty()) {
            Iterator iterator = keyes.iterator();
            return this.m_parameters.get(iterator.next());
        }
        return null;
    }

    public Map getOutputParameters() {
        return this.m_parameters;
    }

    public void setOutputParameter(Object value) {
        this.setOutputParameter("output", value);
    }

    public void setCause(Throwable cause) {
        this.m_cause = cause;
    }

    public void setJobId(String id) {
        this.m_jobId = id;
    }

    public void setResponseProperty(Properties aProperty) {
        this.m_properties = aProperty;
    }

    public String getJobId() {
        return this.m_jobId;
    }

    public String getInvocationId() {
        return this.m_jobId;
    }

    public Throwable getCause() {
        return this.m_cause;
    }

    public Object getProperty(String propertyName, Object defaultValue) {
        Object result = this.m_properties.get(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public int getIntProperty(String propertyName, int defaultValue) {
        Object result = this.m_properties.get(propertyName);
        if (result != null) {
            if (result instanceof Integer) {
                return (Integer)result;
            }
            try {
                return Integer.parseInt(result.toString());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public long getLongProperty(String propertyName, long defaultValue) {
        Object result = this.m_properties.get(propertyName);
        if (result != null) {
            if (result instanceof Long) {
                return (Long)result;
            }
            try {
                return Long.parseLong(result.toString());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public double getDoubleProperty(String propertyName, double defaultValue) {
        Object result = this.m_properties.get(propertyName);
        if (result != null) {
            if (result instanceof Double) {
                return (Double)result;
            }
            try {
                return Double.parseDouble(result.toString());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        Object result = this.m_properties.get(propertyName);
        if (result != null) {
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return Boolean.valueOf(result.toString());
        }
        return defaultValue;
    }

    public Object getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName == null) {
            throw new DSCRuntimeException(new DSCError(206));
        }
        if (propertyName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(207));
        }
        if (value == null) {
            throw new DSCRuntimeException(new DSCError(210));
        }
        this.m_properties.put(propertyName, value);
    }

    public void setBooleanProperty(String propertyName, boolean value) {
        if (propertyName == null) {
            throw new DSCRuntimeException(new DSCError(206));
        }
        if (propertyName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(207));
        }
        this.m_properties.put(propertyName, new Boolean(value));
    }

    public void setIntProperty(String propertyName, int value) {
        if (propertyName == null) {
            throw new DSCRuntimeException(new DSCError(206));
        }
        if (propertyName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(207));
        }
        this.m_properties.put(propertyName, new Integer(value));
    }

    public void setLongProperty(String propertyName, long value) {
        if (propertyName == null) {
            throw new DSCRuntimeException(new DSCError(206));
        }
        if (propertyName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(207));
        }
        this.m_properties.put(propertyName, new Long(value));
    }

    public void setDoubleProperty(String propertyName, double value) {
        if (propertyName == null) {
            throw new DSCRuntimeException(new DSCError(206));
        }
        if (propertyName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(207));
        }
        this.m_properties.put(propertyName, new Double(value));
    }

    public Object removeProperty(String propertyName) {
        Object prop = this.m_properties.get(propertyName);
        if (prop != null) {
            this.m_properties.remove(propertyName);
        }
        return prop;
    }

    public void setClientParameters(Map parameters) {
        this.m_clientParameters = parameters;
    }

    public Map getClientParameters() {
        return this.m_clientParameters;
    }
}

