/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.impl;

import com.adobe.idp.Context;
import com.adobe.idp.dsc.DSCError;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.FaultCallBackInfo;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.ResponseCallBackInfo;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class InvocationRequestImpl
implements InvocationRequest,
Serializable {
    static final long serialVersionUID = -4868081050338178936L;
    private boolean m_synchronous = true;
    private String m_serviceName;
    private String m_operationName;
    private String m_endPointURI;
    private String m_explicitVersion;
    private String m_originalVersion;
    private String m_invocationId;
    private Map m_input = new HashMap();
    private Map m_clientParameters = new HashMap();
    private Object[] m_inputArray;
    private Properties m_properties = new Properties();
    private boolean m_setInputParamsAsArray = false;
    private ServiceConfiguration m_targetConfig;
    private FaultCallBackInfo m_faultCallback = null;
    private ResponseCallBackInfo m_responseCallback = null;
    public static final String INVOCATION_REQUEST_CONTEXT_PROPERTY = "DSC_CONTEXT";
    public static final String INVOCATION_REQUEST_CREDENTIAL_PROPERTY = "DSC_CREDENTIAL";

    public void setServiceName(String serviceName) {
        if (serviceName == null) {
            throw new DSCRuntimeException(new DSCError(203));
        }
        if (serviceName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(204));
        }
        this.m_serviceName = serviceName;
    }

    public void setOperationName(String operationName) {
        if (operationName == null) {
            throw new DSCRuntimeException(new DSCError(201));
        }
        if (operationName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(202));
        }
        this.m_operationName = operationName;
    }

    public void setEndPointURI(String endpointURI) {
        this.m_endPointURI = endpointURI;
    }

    public void setServiceExplicitVersion(String explicitVersion) {
        this.m_explicitVersion = explicitVersion;
    }

    public void setServiceOriginalVersion(String originalVersion) {
        this.m_originalVersion = originalVersion;
    }

    public void setInputParameters(Map map) {
        this.m_input.clear();
        if (map != null) {
            this.m_input.putAll(map);
        }
    }

    public void setInputParametersAsArray(Object[] input) {
        this.m_inputArray = input;
        this.m_setInputParamsAsArray = true;
    }

    public boolean isInputParametersAsArray() {
        return this.m_setInputParamsAsArray;
    }

    public void setInputParameter(String parameterName, Object value) {
        this.m_input.put(parameterName, value);
    }

    public void setSynchronous(boolean synchronous) {
        this.m_synchronous = synchronous;
    }

    public Context getInvocationContext() {
        return (Context)this.getProperty(INVOCATION_REQUEST_CONTEXT_PROPERTY);
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public String getOperationName() {
        return this.m_operationName;
    }

    public String getEndPointURI() {
        return this.m_endPointURI;
    }

    public String getServiceExplicitVersion() {
        return this.m_explicitVersion;
    }

    public String getServiceOriginalVersion() {
        return this.m_originalVersion;
    }

    public Map getInputParameters() {
        return Collections.unmodifiableMap(this.m_input);
    }

    public Object getInputParameter(String name) {
        return this.m_input.get(name);
    }

    public Object[] getInputParametersAsArray() {
        if (this.m_setInputParamsAsArray) {
            return this.m_inputArray;
        }
        throw new DSCRuntimeException(new DSCError(118));
    }

    public Object getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    public Object getProperty(String propertyName, Object defaultValue) {
        Object result = this.m_properties.get(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public int getIntProperty(String propertyName, int defaultValue) {
        Object result = this.m_properties.get(propertyName);
        if (result != null) {
            if (result instanceof Integer) {
                return (Integer)result;
            }
            try {
                return Integer.parseInt(result.toString());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public long getLongProperty(String propertyName, long defaultValue) {
        Object result = this.m_properties.get(propertyName);
        if (result != null) {
            if (result instanceof Long) {
                return (Long)result;
            }
            try {
                return Long.parseLong(result.toString());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public double getDoubleProperty(String propertyName, double defaultValue) {
        Object result = this.m_properties.get(propertyName);
        if (result != null) {
            if (result instanceof Double) {
                return (Double)result;
            }
            try {
                return Double.parseDouble(result.toString());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        Object result = this.m_properties.get(propertyName);
        if (result != null) {
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return Boolean.valueOf(result.toString());
        }
        return defaultValue;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName == null) {
            throw new DSCRuntimeException(new DSCError(206));
        }
        if (propertyName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(207));
        }
        if (value != null) {
            this.m_properties.put(propertyName, value);
        }
    }

    public void setBooleanProperty(String propertyName, boolean value) {
        if (propertyName == null) {
            throw new DSCRuntimeException(new DSCError(206));
        }
        if (propertyName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(207));
        }
        this.m_properties.put(propertyName, new Boolean(value));
    }

    public void setIntProperty(String propertyName, int value) {
        if (propertyName == null) {
            throw new DSCRuntimeException(new DSCError(206));
        }
        if (propertyName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(207));
        }
        this.m_properties.put(propertyName, new Integer(value));
    }

    public void setLongProperty(String propertyName, long value) {
        if (propertyName == null) {
            throw new DSCRuntimeException(new DSCError(206));
        }
        if (propertyName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(207));
        }
        this.m_properties.put(propertyName, new Long(value));
    }

    public void setDoubleProperty(String propertyName, double value) {
        if (propertyName == null) {
            throw new DSCRuntimeException(new DSCError(206));
        }
        if (propertyName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(207));
        }
        this.m_properties.put(propertyName, new Double(value));
    }

    public Object removeProperty(String propertyName) {
        if (propertyName == null) {
            throw new DSCRuntimeException(new DSCError(206));
        }
        if (propertyName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(207));
        }
        Object prop = this.m_properties.get(propertyName);
        if (prop != null) {
            this.m_properties.remove(propertyName);
        }
        return prop;
    }

    public boolean isSynchronous() {
        return this.m_synchronous;
    }

    public void setFaultCallback(FaultCallBackInfo info) {
        this.m_faultCallback = info;
    }

    public void setClientParameters(Map parameters) {
        this.m_clientParameters = parameters;
    }

    public Map getClientParameters() {
        return this.m_clientParameters;
    }

    public void setResponseCallback(ResponseCallBackInfo info) {
        this.m_responseCallback = info;
    }

    public FaultCallBackInfo getFaultCallback() {
        return this.m_faultCallback;
    }

    public ResponseCallBackInfo getResponseCallback() {
        return this.m_responseCallback;
    }

    public void setInvocationId(String invocationId) {
        this.m_invocationId = invocationId;
    }

    public String getInvocationId() {
        return this.m_invocationId;
    }

    public void setTargetServiceConfiguration(ServiceConfiguration aConfig) {
        this.m_targetConfig = aConfig;
    }

    public ServiceConfiguration getTargetServiceConfiguration() {
        return this.m_targetConfig;
    }
}

