/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.filter.impl.pof;

import com.adobe.idp.dsc.filter.Condition;
import com.adobe.idp.dsc.filter.FilterResult;
import com.adobe.idp.dsc.filter.InvalidOperatorException;
import com.adobe.idp.dsc.filter.Operator;
import com.adobe.idp.dsc.filter.PagingFilter;
import com.adobe.idp.dsc.filter.PropertyFilter;
import com.adobe.idp.dsc.filter.Sort;
import com.adobe.idp.dsc.filter.impl.FilterResultImpl;
import com.adobe.idp.dsc.filter.impl.pof.POFCallbackTemplate;
import com.adobe.idp.dsc.filter.impl.pof.POFMappedAttribute;
import com.adobe.idp.dsc.filter.impl.pof.POFMappedJoin;
import com.adobe.idp.dsc.filter.impl.pof.POFMapping;
import com.adobe.pof.POFException;
import com.adobe.pof.omapi.POFJoin;
import com.adobe.pof.omapi.POFObjectManager;
import com.adobe.pof.omapi.POFObjectSet;
import com.adobe.pof.omapi.POFQuery;
import java.util.ArrayList;
import java.util.List;

public class POFFilterUtil {
    public static int convertOperator(Operator aOperator) {
        int ret;
        if (aOperator.equals(Operator.EQUALS)) {
            ret = 0;
        } else if (aOperator.equals(Operator.NOT_EQUALS)) {
            ret = 3;
        } else if (aOperator.equals(Operator.BEGINS_WITH)) {
            ret = 7;
        } else if (aOperator.equals(Operator.CONTAINS)) {
            ret = 9;
        } else if (aOperator.equals(Operator.NOT_CONTAINS)) {
            ret = 3;
        } else if (aOperator.equals(Operator.ENDS_WITH)) {
            ret = 8;
        } else if (aOperator.equals(Operator.GREATER_THAN_EQUALS)) {
            ret = 5;
        } else if (aOperator.equals(Operator.GREATER_THAN)) {
            ret = 1;
        } else if (aOperator.equals(Operator.IN)) {
            ret = 10;
        } else if (aOperator.equals(Operator.GREATER_THAN)) {
            ret = 1;
        } else if (aOperator.equals(Operator.LESS_THAN_EQUALS)) {
            ret = 6;
        } else if (aOperator.equals(Operator.LESS_THAN)) {
            ret = 2;
        } else if (aOperator.equals(Operator.LIKE)) {
            ret = 4;
        } else {
            throw new InvalidOperatorException(aOperator.value());
        }
        return ret;
    }

    public static int convertOperator(String aOperator) {
        return POFFilterUtil.convertOperator(new Operator(aOperator));
    }

    public static FilterResult executeQuery(POFQuery aQuery, PagingFilter aFilter, POFMapping aMapping, POFObjectManager aObjectManager, POFCallbackTemplate aCallback) throws POFException {
        POFFilterUtil.applyFilter(aQuery, aFilter, aMapping);
        POFObjectSet _os = null;
        if (aFilter != null) {
            if (aFilter.getMaxObjects() > -1) {
                _os = aObjectManager.retrieveObjectSet(aQuery, aFilter.getOffset(), aFilter.getMaxObjects());
            }
        } else {
            _os = aObjectManager.retrieveObjectSet(aQuery);
        }
        FilterResultImpl _results = null;
        if (_os != null) {
            List _list = aCallback.doProcessResults(_os);
            _results = new FilterResultImpl(_list);
        } else {
            _results = new FilterResultImpl();
        }
        if (aFilter != null && aFilter.getReturnSizeOfValue()) {
            _results.setSizeOfValue(aObjectManager.sizeOf(aQuery));
        }
        return _results;
    }

    public static FilterResult executeQueryWithTrailer(POFQuery aQuery, PagingFilter aFilter, POFMapping aMapping, POFObjectManager aObjectManager, List trailingObjects, POFCallbackTemplate aCallback) throws POFException {
        POFFilterUtil.applyFilter(aQuery, aFilter, aMapping);
        if (aFilter == null || aFilter.getMaxObjects() < 1) {
            POFObjectSet _os = aObjectManager.retrieveObjectSet(aQuery);
            ArrayList _list = null;
            _list = _os != null ? aCallback.doProcessResults(_os) : new ArrayList();
            if (trailingObjects != null) {
                _list = _list instanceof ArrayList ? _list : new ArrayList(_list);
                for (int i = 0; i < trailingObjects.size(); ++i) {
                    _list.add(trailingObjects.get(i));
                }
            }
            return new FilterResultImpl(_list);
        }
        POFObjectSet _os = aObjectManager.retrieveObjectSet(aQuery, aFilter.getOffset(), aFilter.getMaxObjects());
        int querySize = aObjectManager.sizeOf(aQuery);
        ArrayList _list = null;
        _list = _os != null ? aCallback.doProcessResults(_os) : new ArrayList();
        if (trailingObjects != null && _list.size() < aFilter.getMaxObjects()) {
            _list = _list instanceof ArrayList ? _list : new ArrayList(_list);
            int listSize = _list.size();
            if (aFilter.getOffset() > querySize) {
                for (int i = aFilter.getOffset() - querySize; i < aFilter.getOffset() - querySize + aFilter.getMaxObjects() - listSize && i < trailingObjects.size(); ++i) {
                    _list.add(trailingObjects.get(i));
                }
            } else {
                for (int i = 0; i < aFilter.getMaxObjects() - listSize && i < trailingObjects.size(); ++i) {
                    _list.add(trailingObjects.get(i));
                }
            }
        }
        FilterResultImpl results = new FilterResultImpl(_list);
        if (aFilter.getReturnSizeOfValue()) {
            results.setSizeOfValue(querySize + (trailingObjects != null ? trailingObjects.size() : 0));
        }
        return results;
    }

    public static void applyFilter(POFQuery aQuery, PagingFilter aFilter, POFMapping aMapping) throws POFException {
        if (aFilter != null && aFilter instanceof PropertyFilter) {
            PropertyFilter _propFilter = (PropertyFilter)aFilter;
            for (Condition _cond : _propFilter.getConditionList()) {
                Operator _op;
                POFMappedAttribute _pofProp = aMapping.getMappedAttributeForProperty(_cond.getProperty());
                POFMappedJoin _join = _pofProp.getJoin();
                if (_join != null) {
                    POFFilterUtil.applyJoin(aQuery, _join);
                }
                if ((_op = _cond.getOperator()) == null) {
                    _op = Operator.EQUALS;
                }
                int _pofOperator = POFFilterUtil.convertOperator(_op);
                int _pofConnective = -1;
                if (_cond.getConnective() != null) {
                    String connect = _cond.getConnective().connective;
                    _pofConnective = connect.compareToIgnoreCase("and") == 0 ? 0 : 1;
                }
                if (_pofConnective == -1) {
                    if (_join != null) {
                        aQuery.addFilter(_join.getName(), _pofProp.getName(), _pofOperator, _cond.getValue());
                        continue;
                    }
                    aQuery.addFilter(_pofProp.getName(), _pofOperator, _cond.getValue());
                    continue;
                }
                if (_join != null) {
                    aQuery.addFilter(_join.getName(), _pofProp.getName(), _pofOperator, _cond.getValue(), _pofConnective);
                    continue;
                }
                aQuery.addFilter(_pofProp.getName(), _pofOperator, _cond.getValue(), _pofConnective);
            }
        }
        if (aFilter != null) {
            for (Sort _sort : aFilter.getSortList()) {
                POFMappedAttribute _pofProp = aMapping.getMappedAttributeForProperty(_sort.getProperty());
                POFMappedJoin _join = _pofProp.getJoin();
                if (_join != null) {
                    POFFilterUtil.applyJoin(aQuery, _join);
                }
                if (_sort.getDirection().equals("ASC")) {
                    if (_join == null) {
                        aQuery.addSortAsc(_pofProp.getName());
                        continue;
                    }
                    aQuery.addSortAsc(_join.getName(), _pofProp.getName());
                    continue;
                }
                if (_join == null) {
                    aQuery.addSortDesc(_pofProp.getName());
                    continue;
                }
                aQuery.addSortDesc(_join.getName(), _pofProp.getName());
            }
        }
    }

    private static POFJoin applyJoin(POFQuery aQuery, POFMappedJoin aJoin) throws POFException {
        if (aJoin == null) {
            return null;
        }
        POFJoin _pofJoin = aQuery.getJoin(aJoin.getName());
        if (_pofJoin != null) {
            return null;
        }
        if (aJoin.getSourceJoin() != null) {
            POFJoin _sourceJoin = aQuery.getJoin(aJoin.getSourceJoin().getName());
            if (_sourceJoin == null) {
                _sourceJoin = POFFilterUtil.applyJoin(aQuery, aJoin.getSourceJoin());
            }
            return aJoin.isOuterJoin() ? aQuery.addOuterJoinAsFilter(_sourceJoin.getName(), aJoin.getName(), aJoin.getRelation()) : aQuery.addInnerJoinAsFilter(_sourceJoin.getName(), aJoin.getName(), aJoin.getRelation());
        }
        return aJoin.isOuterJoin() ? aQuery.addOuterJoinAsFilter(aJoin.getName(), aJoin.getRelation()) : aQuery.addInnerJoinAsFilter(aJoin.getName(), aJoin.getRelation());
    }
}

