/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.datatype.impl;

import com.adobe.idp.dsc.datatype.Converter;
import com.adobe.idp.dsc.datatype.impl.NonManagedTypeCallback;
import com.adobe.idp.dsc.datatype.impl.NonManagedTypeProxy;
import com.adobe.idp.dsc.util.ClassHelper;
import com.adobe.idp.dsc.util.InvalidCoercionException;
import java.lang.reflect.Constructor;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;

public class NonManagedTypeConverter
implements Converter {
    protected static final NonManagedTypeConverter INSTANCE = new NonManagedTypeConverter();
    protected static final Class[] ENHANCED_INTERFACES = new Class[]{NonManagedTypeProxy.class};

    private NonManagedTypeConverter() {
    }

    public static NonManagedTypeConverter getInstance() {
        return INSTANCE;
    }

    public Object convert(Class aTargetType, Object aValue, ClassLoader aTargetLoader) {
        Object _val = aValue;
        if (_val == null) {
            return null;
        }
        if (_val instanceof NonManagedTypeProxy) {
            NonManagedTypeProxy _proxy = (NonManagedTypeProxy)_val;
            _val = _proxy.getTargetObject();
        }
        if (!aTargetType.getName().equals(_val.getClass().getName())) {
            try {
                Class _expectedTypeFromSourceClassLoader = ClassHelper.forName(aTargetType.getName(), _val.getClass().getClassLoader());
                if (!_expectedTypeFromSourceClassLoader.isAssignableFrom(_val.getClass())) {
                    throw new InvalidCoercionException(aTargetType, _val);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidCoercionException(aTargetType, _val);
            }
        }
        return NonManagedTypeConverter.enhance(aTargetType, _val, aTargetLoader);
    }

    protected static boolean isStandard(Class aType) {
        if (ClassHelper.isPrimitive(aType)) {
            return true;
        }
        return aType.getName().startsWith("java");
    }

    protected static Object enhance(Class aTargetType, Object aSourceVal, ClassLoader aTargetLoader) {
        Class<Object> _superClass = aTargetType;
        Class[] _interfaces = ENHANCED_INTERFACES;
        try {
            _superClass = aTargetLoader.loadClass(aSourceVal.getClass().getName());
            Constructor<?> _constructor = null;
            try {
                _constructor = _superClass.getDeclaredConstructor(ClassHelper.EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            if (_constructor == null) {
                _superClass = aTargetType;
            }
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        if (_superClass.isInterface()) {
            _interfaces = new Class[ENHANCED_INTERFACES.length + 1];
            System.arraycopy(ENHANCED_INTERFACES, 0, _interfaces, 1, ENHANCED_INTERFACES.length);
            _interfaces[0] = _superClass;
            _superClass = Object.class;
        }
        Enhancer _enhancer = new Enhancer();
        _enhancer.setSuperclass(_superClass);
        _enhancer.setInterfaces(_interfaces);
        _enhancer.setCallback((Callback)new NonManagedTypeCallback(aSourceVal, aTargetLoader));
        _enhancer.setClassLoader(aTargetLoader);
        Object _ehancedObject = _enhancer.create();
        return _ehancedObject;
    }
}

