/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.component.impl;

import com.adobe.idp.dsc.component.ComponentContext;
import com.adobe.idp.dsc.pool.service.impl.ServiceInstanceWrapper;
import com.adobe.idp.dsc.registry.impl.CacheUtils;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.livecycle.cache.Cache;
import com.adobe.livecycle.cache.CacheException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class POJOCache {
    private static final Logger logger = Logger.getLogger(POJOCache.class.getName());

    private POJOCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getClassFromCache(ComponentContext m_ctx, String className) {
        Class _classFromCache;
        block10: {
            Cache _cache = null;
            _classFromCache = null;
            try {
                CacheUtils _cacheUtil;
                CacheUtils cacheUtils = _cacheUtil = CacheUtils.getInstance();
                synchronized (cacheUtils) {
                    _cache = _cacheUtil.getPOJOCache();
                    _classFromCache = (Class)_cache.get((Object)className);
                    if (_classFromCache != null) {
                        if (_classFromCache.getClassLoader() != m_ctx.getClassLoader() && _classFromCache.getClassLoader() != POJOCache.class.getClassLoader()) {
                            _cache.remove((Object)className);
                            _classFromCache = null;
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "ClassLoader changed for CLASS in cache, loading new instance ===== > " + className);
                            }
                        } else if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Found CLASS in cache ===== > " + className);
                        }
                    }
                }
            }
            catch (CacheException e) {
                if (!logger.isLoggable(Level.WARNING)) break block10;
                logger.log(Level.WARNING, "POJO factory cache lookup failed for service class." + e.getMessage());
            }
        }
        return _classFromCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putClassInCache(String className, Class clazz) {
        block5: {
            Cache _cache = null;
            try {
                CacheUtils _cacheUtils;
                CacheUtils cacheUtils = _cacheUtils = CacheUtils.getInstance();
                synchronized (cacheUtils) {
                    _cache = _cacheUtils.getPOJOCache();
                    _cache.put((Object)className, (Object)clazz);
                }
            }
            catch (CacheException e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.log(Level.WARNING, "POJO Invoker cache creation failed." + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getPOJOFromCache(ComponentContext m_ctx, ServiceConfiguration aConfig) {
        Object _cachedPOJO;
        block11: {
            _cachedPOJO = null;
            Cache _cache = null;
            try {
                CacheUtils _cacheUtil;
                CacheUtils cacheUtils = _cacheUtil = CacheUtils.getInstance();
                synchronized (cacheUtils) {
                    _cache = _cacheUtil.getPOJOCache();
                    Object _pojoFromCache = _cache.get((Object)POJOCache.createServiceKeyForCache(aConfig));
                    Object _classToCheckClassloader = null;
                    if (_pojoFromCache == null) {
                        _cachedPOJO = null;
                    } else {
                        _classToCheckClassloader = _pojoFromCache instanceof ServiceInstanceWrapper ? ((ServiceInstanceWrapper)_pojoFromCache).getServiceInstance() : _pojoFromCache;
                        if (_classToCheckClassloader.getClass().getClassLoader() != m_ctx.getClassLoader()) {
                            _cache.remove((Object)POJOCache.createServiceKeyForCache(aConfig));
                            _cachedPOJO = null;
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "ClassLoader changed for object in cache, creating new instance ===== > " + _pojoFromCache.getClass().getName());
                            }
                        } else {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Found OBJECT in cache ===== > " + _pojoFromCache.getClass().getName());
                            }
                            _cachedPOJO = _pojoFromCache;
                        }
                    }
                }
            }
            catch (CacheException e) {
                if (!logger.isLoggable(Level.WARNING)) break block11;
                logger.log(Level.WARNING, "POJO Invoker cache creation failed." + e.getMessage());
            }
        }
        return _cachedPOJO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPOJOToCache(ServiceConfiguration aConfig, Object pojo) {
        block5: {
            Cache _cache = null;
            try {
                CacheUtils _cacheUtils;
                CacheUtils cacheUtils = _cacheUtils = CacheUtils.getInstance();
                synchronized (cacheUtils) {
                    _cache = _cacheUtils.getPOJOCache();
                    _cache.put((Object)POJOCache.createServiceKeyForCache(aConfig), pojo);
                }
            }
            catch (CacheException e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.log(Level.WARNING, "POJO Invoker cache creation failed." + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePOJOFromCache(ServiceConfiguration aConfig) {
        block5: {
            Cache _cache = null;
            try {
                CacheUtils _cacheUtils;
                CacheUtils cacheUtils = _cacheUtils = CacheUtils.getInstance();
                synchronized (cacheUtils) {
                    _cache = _cacheUtils.getPOJOCache();
                    _cache.remove((Object)POJOCache.createServiceKeyForCache(aConfig));
                }
            }
            catch (CacheException e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.log(Level.WARNING, "POJO Invoker cache creation failed." + e.getMessage());
            }
        }
    }

    private static String createServiceKeyForCache(ServiceConfiguration aConfig) {
        StringBuffer _buffer = new StringBuffer();
        _buffer.append(aConfig.getServiceId());
        _buffer.append("_");
        _buffer.append(aConfig.getMajorVersion());
        _buffer.append("_");
        _buffer.append(aConfig.getMinorVersion());
        return _buffer.toString();
    }
}

