/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.component.impl;

import com.adobe.idp.Document;
import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.DSCInvocationException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.DSContainer;
import com.adobe.idp.dsc.component.ComponentContext;
import com.adobe.idp.dsc.component.impl.POJOCache;
import com.adobe.idp.dsc.component.support.AbstractServiceInstanceFactory;
import com.adobe.idp.dsc.datatype.Convertable;
import com.adobe.idp.dsc.datatype.Converter;
import com.adobe.idp.dsc.datatype.TextSerializer;
import com.adobe.idp.dsc.datatype.impl.DefaultTextSerializer;
import com.adobe.idp.dsc.propertyeditor.impl.PropertyEditorComponentImpl;
import com.adobe.idp.dsc.propertyeditor.system.SystemPropertyEditorRegistry;
import com.adobe.idp.dsc.registry.infomodel.ConfigParameter;
import com.adobe.idp.dsc.registry.infomodel.PropertyEditorComponent;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.idp.dsc.util.CoercionUtil;
import com.adobe.idp.dsc.util.TextUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.PropertyUtils;

public class DefaultPOJOServiceInstanceFactory
extends AbstractServiceInstanceFactory {
    private static Class[] STANDARD_CLASSES = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigDecimal.class, Document.class};
    private static Class[] EMPTY_CLASS_ARRAY = new Class[0];
    protected static final String TRANSACTION_TEMPLATE_PROPERTY_NAME = "transactionTemplate";
    protected static final String COMPONENT_CONTEXT_PROPERTY_NAME = "componentContext";
    private static Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Logger logger = Logger.getLogger(DefaultPOJOServiceInstanceFactory.class.getName());
    private static DefaultPOJOServiceInstanceFactory _instanceFactory = null;

    private DefaultPOJOServiceInstanceFactory() {
    }

    public DefaultPOJOServiceInstanceFactory(ComponentContext context) {
        super.setComponentContext(context);
    }

    public void activateInstance(ServiceConfiguration config, Object instance) {
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer _message = new StringBuffer();
            _message.append("Activate instance called for service configuration ");
            _message.append(" service name: ");
            _message.append(config.getServiceId());
            _message.append(" service major version: ");
            _message.append(config.getMajorVersion());
            _message.append(" service minor version: ");
            _message.append(config.getMinorVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getServiceClass(ServiceConfiguration aConfig) throws ClassNotFoundException {
        Class<?> _serviceImplClass = null;
        String _serviceImplClassName = (String)aConfig.getAttributes().get("implementation-class");
        _serviceImplClass = POJOCache.getClassFromCache(this.getComponentContext(), _serviceImplClassName);
        if (_serviceImplClass == null) {
            ClassLoader classLoader = this.getComponentContext().getClassLoader();
            synchronized (classLoader) {
                _serviceImplClass = this.getComponentContext().getClassLoader().loadClass(_serviceImplClassName);
            }
            POJOCache.putClassInCache(_serviceImplClassName, _serviceImplClass);
        }
        return _serviceImplClass;
    }

    public Object createInstance(ServiceConfiguration config) throws DSCException {
        Object _serviceImplObject = null;
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer _message = new StringBuffer();
            _message.append("Create instance called for service configuration ");
            _message.append(" service name: ");
            _message.append(config.getServiceId());
            _message.append(" service major version: ");
            _message.append(config.getMajorVersion());
            _message.append(" service minor version: ");
            _message.append(config.getMinorVersion());
        }
        try {
            String _factoryMethodName = (String)config.getAttributes().get("factory-method");
            Class _serviceImplClass = this.getServiceClass(config);
            if (TextUtil.isEmpty(_factoryMethodName)) {
                _serviceImplObject = _serviceImplClass.newInstance();
            } else {
                Method _factoryMethod = _serviceImplClass.getMethod(_factoryMethodName, EMPTY_CLASS_ARRAY);
                _serviceImplObject = _factoryMethod.invoke((Object)_serviceImplClass, EMPTY_OBJECT_ARRAY);
            }
            if (PropertyUtils.isWriteable(_serviceImplObject, (String)COMPONENT_CONTEXT_PROPERTY_NAME)) {
                PropertyUtils.setSimpleProperty((Object)_serviceImplObject, (String)COMPONENT_CONTEXT_PROPERTY_NAME, (Object)this.getComponentContext());
            }
            ConfigParameter[] _configParameters = config.getConfigParameters();
            for (int i = 0; i < _configParameters.length; ++i) {
                PropertyEditorComponentImpl _depPeComp;
                ConfigParameter _configParameter = _configParameters[i];
                String _propertyName = (String)_configParameter.getAttributes().get("property");
                if (TextUtil.isEmpty(_propertyName)) {
                    _propertyName = _configParameter.getName();
                }
                if (!PropertyUtils.isWriteable((Object)_serviceImplObject, (String)_propertyName)) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    StringBuffer _errorBuffer = new StringBuffer("Property: ").append(_propertyName).append(" is not writeable on service: ").append(config.getServiceId());
                    logger.log(Level.FINE, _errorBuffer.toString());
                    continue;
                }
                PropertyEditorComponent _peComp = null;
                if (TextUtil.isEmpty(_configParameter.getPropertyEditor().getEditorId())) {
                    _depPeComp = (PropertyEditorComponentImpl)SystemPropertyEditorRegistry.getInstance().getPropertyEditorByType(_configParameter.getType());
                    if (_depPeComp != null) {
                        _peComp = _depPeComp.getPropertyEditorComponent();
                    }
                } else {
                    _depPeComp = (PropertyEditorComponentImpl)SystemPropertyEditorRegistry.getInstance().getPropertyEditorById(_configParameter.getPropertyEditor().getEditorId());
                    if (_depPeComp != null) {
                        _peComp = _depPeComp.getPropertyEditorComponent();
                    }
                    if (_peComp == null) {
                        _peComp = DSContainer.getInstance().getInternalPropertyEditorRegistry().getHeadPropertyEditor(_configParameter.getPropertyEditor().getEditorId());
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    StringBuffer _errorBuffer = new StringBuffer();
                    _errorBuffer.append("Setting Config Parameter: ");
                    _errorBuffer.append(_configParameter.getName());
                    _errorBuffer.append(" on property: ");
                    _errorBuffer.append(_propertyName);
                    _errorBuffer.append(" with value: ");
                    _errorBuffer.append(_configParameter.getTextValue());
                    logger.log(Level.FINE, _errorBuffer.toString());
                }
                Object _val = null;
                ClassLoader _propEditorClassLoader = DSContainer.getInstance().getClassLoaderForPropertyEditor(_peComp);
                Class<?> _configTypeClass = _propEditorClassLoader.loadClass(_peComp.getConfigurationType());
                if (TextUtil.isEmpty(_peComp.getSerializerClass())) {
                    _val = DefaultTextSerializer.getDefaultInstance().deserializeValue(_configTypeClass, _configParameter.getTextValue(), _propEditorClassLoader);
                } else {
                    Class<?> _serializerClass = _propEditorClassLoader.loadClass(_peComp.getSerializerClass());
                    TextSerializer _Text_serializer = (TextSerializer)_serializerClass.newInstance();
                    _val = _Text_serializer.deserializeValue(_configTypeClass, _configParameter.getTextValue(), _propEditorClassLoader);
                }
                PropertyDescriptor _descriptor = PropertyUtils.getPropertyDescriptor((Object)_serviceImplObject, (String)_propertyName);
                if (_val instanceof Convertable) {
                    _val = ((Convertable)_val).convert(_descriptor.getPropertyType());
                } else if (!TextUtil.isEmpty(_peComp.getConverterClass())) {
                    Class<?> _converterClass = _propEditorClassLoader.loadClass(_peComp.getConverterClass());
                    Converter _converter = (Converter)_converterClass.newInstance();
                    _val = _converter.convert(_descriptor.getPropertyType(), _val, this.getComponentContext().getClassLoader());
                } else {
                    _val = CoercionUtil.toType(_descriptor.getPropertyType(), _val, this.getComponentContext().getClassLoader());
                }
                PropertyUtils.setSimpleProperty((Object)_serviceImplObject, (String)_propertyName, (Object)_val);
            }
        }
        catch (InvocationTargetException ex) {
            Throwable _cause = ex.getCause();
            if (_cause == null) {
                _cause = ex;
            }
            if (_cause instanceof RuntimeException) {
                throw (RuntimeException)_cause;
            }
            throw new DSCInvocationException(_cause);
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
        return _serviceImplObject;
    }

    public void destroyInstance(ServiceConfiguration config, Object instance) throws DSCException {
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer _message = new StringBuffer();
            _message.append("Destroy instance called for service configuration ");
            _message.append(" service name: ");
            _message.append(config.getServiceId());
            _message.append(" service major version: ");
            _message.append(config.getMajorVersion());
            _message.append(" service minor version: ");
            _message.append(config.getMinorVersion());
        }
    }

    public void passivateInstance(ServiceConfiguration config, Object instance) {
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer _message = new StringBuffer();
            _message.append("Passivate instance called for service configuration ");
            _message.append(" service name: ");
            _message.append(config.getServiceId());
            _message.append(" service major version: ");
            _message.append(config.getMajorVersion());
            _message.append(" service minor version: ");
            _message.append(config.getMinorVersion());
        }
    }

    public boolean validateInstance(ServiceConfiguration config, Object instance) {
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer _message = new StringBuffer();
            _message.append("Validate instance called for service configuration ");
            _message.append(" service name: ");
            _message.append(config.getServiceId());
            _message.append(" service major version: ");
            _message.append(config.getMajorVersion());
            _message.append(" service minor version: ");
            _message.append(config.getMinorVersion());
        }
        return true;
    }
}

