/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.component.impl;

import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.component.ComponentContext;
import com.adobe.idp.dsc.component.Descriptor;
import com.adobe.idp.dsc.component.impl.InvalidBeanPropertyException;
import com.adobe.idp.dsc.registry.infomodel.ConfigParameter;
import com.adobe.idp.dsc.registry.infomodel.Fault;
import com.adobe.idp.dsc.registry.infomodel.InputParameter;
import com.adobe.idp.dsc.registry.infomodel.OutputParameter;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.idp.dsc.registry.infomodel.ServicePoolConfiguration;
import com.adobe.idp.dsc.registry.infomodel.impl.ConfigParameterImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.FaultImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.InputParameterImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.OperationImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.OutputParameterImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.PropertyEditorImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.ServiceConfigurationImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.ServicePoolConfigurationImpl;
import com.adobe.idp.dsc.registry.infomodel.layout.impl.LayoutImpl;
import com.adobe.idp.dsc.registry.infomodel.layout.impl.PropertyImpl;
import com.adobe.idp.dsc.registry.infomodel.layout.impl.SectionImpl;
import com.adobe.idp.dsc.registry.service.impl.ServiceRegistryImpl;
import com.adobe.idp.dsc.util.ClassHelper;
import com.adobe.idp.dsc.util.DOMUtil;
import com.adobe.idp.dsc.util.IOUtil;
import com.adobe.idp.dsc.util.TextUtil;
import com.adobe.logging.AdobeLogger;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultPOJODescriptorImpl
implements Descriptor {
    protected static final Logger logger = AdobeLogger.getLogger(DefaultPOJODescriptorImpl.class.getName());
    protected ComponentContext m_ctx;
    protected static final String NAME_ATTR = "name";
    protected static final String SPECIFICATION_ID_ELM = "specification-id";
    protected static final String SPECIFICATION_VERSION_ELM = "specification-version";
    protected static final String IMPLEMENTATION_CLASS_ELM = "implementation-class";
    protected static final String FACTORY_METHOD_ELM = "factory-method";
    protected static final String METHOD_ATTR = "method";
    protected static final String PROPERTY_ATTR = "property";
    protected static final String BINDING_TYPE_ATTR = "binding-type";
    protected static final String INPUT_OUTPUT_BINDING = "input";
    protected static final String RETURN_OUTPUT_BINDING = "return";
    protected static final String BEAN_PROPERTY_OUTPUT_BINDING = "bean";
    protected static final String DEFAULT_REQUEST_PROCESSING = "INSTANCE_PER_INVOCATION";
    protected static final String SINGLE_INSTANCE_FOR_ALL_REQUESTS = "SINGLE_INSTANCE";
    protected static final String POOLED_INSTANCE = "POOLED_INSTANCE";

    public void setComponentContext(ComponentContext aCtx) {
        this.m_ctx = aCtx;
    }

    public ServiceConfiguration createServiceConfigurationFromString(String aServiceDescriptor) {
        Document _serviceDescriptorDOM = null;
        try {
            if (!TextUtil.isEmpty(aServiceDescriptor)) {
                _serviceDescriptorDOM = DOMUtil.parseDocumentFromString(aServiceDescriptor);
            }
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
        if (_serviceDescriptorDOM == null) {
            return this.createServiceConfigurationFromElement(null);
        }
        return this.createServiceConfigurationFromElement(_serviceDescriptorDOM.getDocumentElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceConfiguration createServiceConfigurationFromElement(Element aServiceDescriptor) {
        try {
            ServicePoolConfiguration _servicePoolConfig;
            if (aServiceDescriptor == null) {
                return new ServiceConfigurationImpl();
            }
            Element _descriptorRoot = aServiceDescriptor;
            ServiceConfigurationImpl _serviceDesc = new ServiceConfigurationImpl();
            _serviceDesc.setIsPojo(true);
            _serviceDesc.setServiceId(TextUtil.trim(_descriptorRoot.getAttribute(NAME_ATTR)));
            _serviceDesc.setTitle(TextUtil.trim(_descriptorRoot.getAttribute("title")));
            _serviceDesc.setHint(TextUtil.trim(DOMUtil.getTextForChild(_descriptorRoot, "hint")));
            _serviceDesc.setComponentId(this.m_ctx.getComponent().getComponentId());
            _serviceDesc.setComponentVersion(this.m_ctx.getComponent().getVersion());
            _serviceDesc.setDescriptor(DOMUtil.toString(aServiceDescriptor));
            boolean _private = !TextUtil.isEmpty(_descriptorRoot.getAttribute("private")) && TextUtil.trim(_descriptorRoot.getAttribute("private")).equalsIgnoreCase("true");
            _serviceDesc.setAccessLevel(_private ? (short)1 : 0);
            boolean _orchestrateable = TextUtil.isEmpty(_descriptorRoot.getAttribute("orchestrateable")) || TextUtil.trim(_descriptorRoot.getAttribute("orchestrateable")).equalsIgnoreCase("true");
            _serviceDesc.setOrchestrateable(_orchestrateable);
            Element _requestProcessingStrategyElem = DOMUtil.getChildElement(_descriptorRoot, "request-processing-strategy");
            int _requestProcessingStrategy = 1;
            if (_requestProcessingStrategyElem != null) {
                String _val = DOMUtil.getTextForChild(_descriptorRoot, "request-processing-strategy");
                if ((_val = TextUtil.trim(_val)) != null && _val.length() > 0) {
                    if (_val.compareToIgnoreCase(SINGLE_INSTANCE_FOR_ALL_REQUESTS) == 0) {
                        _requestProcessingStrategy = 0;
                    } else if (_val.compareToIgnoreCase(POOLED_INSTANCE) == 0) {
                        _requestProcessingStrategy = 2;
                    }
                }
            }
            _serviceDesc.setRequestProcessingStrategy(_requestProcessingStrategy);
            Element _descriptionElement = DOMUtil.getChildElement(_descriptorRoot, "description");
            if (_descriptionElement != null) {
                _serviceDesc.setDescription(TextUtil.trim(DOMUtil.getTextForNode(_descriptionElement)));
            }
            Element _supportedConnectorsElm = DOMUtil.getChildElement(_descriptorRoot, "supported-connectors");
            String[] _supportedConnectors = null;
            if (_supportedConnectorsElm != null) {
                String _supportedConnectorsValues = TextUtil.trim(DOMUtil.getTextForChild(_descriptorRoot, "supported-connectors"));
                if (!TextUtil.isEmpty(_supportedConnectorsValues)) {
                    if (_supportedConnectorsValues.equals("default")) {
                        _supportedConnectors = ServiceRegistryImpl.getDefaultProviderIds();
                    } else {
                        _supportedConnectorsValues = TextUtil.replace(_supportedConnectorsValues, "default", TextUtil.trim(ServiceRegistryImpl.getDefaultProvidersString()));
                        _supportedConnectors = TextUtil.split(_supportedConnectorsValues, ',');
                    }
                } else {
                    _supportedConnectors = new String[]{};
                }
            }
            _serviceDesc.setSupportedConnectorIds(_supportedConnectors);
            byte[] _smallIcon = null;
            String _iconResource = null;
            try {
                _iconResource = TextUtil.trim(DOMUtil.getTextForChild(_descriptorRoot, "small-icon"));
                if (!TextUtil.isEmpty(_iconResource)) {
                    _smallIcon = IOUtil.readByteArrayFromResource(this.m_ctx.getClassLoader(), _iconResource);
                }
            }
            catch (Throwable ex) {
                logger.log(Level.WARNING, "Unable to load small-icon: " + _iconResource + " in component: " + this.m_ctx.getComponent().getComponentId() + ":" + this.m_ctx.getComponent().getVersion() + " cause: " + ex.getMessage());
            }
            byte[] _largeIcon = null;
            try {
                _iconResource = TextUtil.trim(DOMUtil.getTextForChild(_descriptorRoot, "large-icon"));
                if (!TextUtil.isEmpty(_iconResource)) {
                    _largeIcon = IOUtil.readByteArrayFromResource(this.m_ctx.getClassLoader(), _iconResource);
                }
            }
            catch (Throwable ex) {
                logger.log(Level.WARNING, "Unable to load large-icon: " + _iconResource + " in component: " + this.m_ctx.getComponent().getComponentId() + ":" + this.m_ctx.getComponent().getVersion() + " cause: " + ex.getMessage());
            }
            _serviceDesc.setSmallIcon(_smallIcon);
            _serviceDesc.setLargeIcon(_largeIcon);
            String _implementationClassName = TextUtil.trim(DOMUtil.getRequiredTextForChild(_descriptorRoot, IMPLEMENTATION_CLASS_ELM));
            String _factoryMethodName = TextUtil.trim(DOMUtil.getTextForChild(_descriptorRoot, FACTORY_METHOD_ELM));
            _serviceDesc.getAttributes().put(IMPLEMENTATION_CLASS_ELM, _implementationClassName);
            if (!TextUtil.isEmpty(_factoryMethodName)) {
                _serviceDesc.getAttributes().put(FACTORY_METHOD_ELM, _factoryMethodName);
            }
            Class<?> _implementationClass = null;
            try {
                ClassLoader classLoader = this.m_ctx.getClassLoader();
                synchronized (classLoader) {
                    _implementationClass = this.m_ctx.getClassLoader().loadClass(_implementationClassName);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new DSCRuntimeException(ex);
            }
            Element[] _configParameterElms = DOMUtil.getChildElements(_descriptorRoot, "config-parameter");
            ConfigParameter[] _configParams = new ConfigParameter[_configParameterElms.length];
            for (int i = 0; i < _configParameterElms.length; ++i) {
                Element _configParameterElm = _configParameterElms[i];
                String _cpName = TextUtil.trim(DOMUtil.getRequiredTextForAttr(_configParameterElm, NAME_ATTR));
                String _cpDescription = DOMUtil.getTextForChild(_configParameterElm, "description");
                String _cpTitle = TextUtil.trim(_configParameterElm.getAttribute("title"));
                String _cpHint = TextUtil.trim(DOMUtil.getTextForChild(_configParameterElm, "hint"));
                String _cpValue = DOMUtil.getTextForChild(_configParameterElm, "default-value");
                String _cpRequiredStr = TextUtil.trim(_configParameterElm.getAttribute("required"));
                String _cpProperty = TextUtil.trim(_configParameterElm.getAttribute(PROPERTY_ATTR));
                boolean _cpRequired = !TextUtil.isEmpty(_cpRequiredStr) && _cpRequiredStr.equalsIgnoreCase("true");
                String _cpType = TextUtil.trim(_configParameterElm.getAttribute("type"));
                ConfigParameterImpl _configParam = new ConfigParameterImpl();
                _configParam.setName(_cpName);
                _configParam.setTitle(_cpTitle);
                _configParam.setHint(_cpHint);
                _configParam.setTextValue(_cpValue);
                _configParam.setDescription(_cpDescription);
                HashMap<String, String> _attrs = new HashMap<String, String>();
                if (!TextUtil.isEmpty(_cpProperty)) {
                    _attrs.put(PROPERTY_ATTR, _cpProperty);
                } else {
                    _attrs.put(PROPERTY_ATTR, _cpName);
                }
                _configParam.setAttributes(_attrs);
                _configParam.setType(ClassHelper.getLoadableClassName(_cpType));
                _configParam.setRequired(_cpRequired);
                PropertyEditorImpl _cpPropEditor = new PropertyEditorImpl();
                Element _propertyEditorElm = DOMUtil.getChildElement(_configParameterElm, "property-editor");
                if (_propertyEditorElm != null) {
                    _cpPropEditor.setEditorId(_propertyEditorElm.getAttribute("editor-id"));
                    Element[] _propertyEditorParamElms = DOMUtil.getChildElements(_propertyEditorElm, "parameter");
                    if (_propertyEditorParamElms != null && _propertyEditorParamElms.length > 0) {
                        HashMap<String, String> _propertyEditorParams = new HashMap<String, String>();
                        for (int k = 0; k < _propertyEditorParamElms.length; ++k) {
                            Element _propertyEditorParamElm = _propertyEditorParamElms[k];
                            String _name = TextUtil.trim(_propertyEditorParamElm.getAttribute(NAME_ATTR));
                            String _value = _propertyEditorParamElm.getAttribute("value");
                            if (TextUtil.isEmpty(_name)) continue;
                            _propertyEditorParams.put(_name, _value);
                        }
                        _cpPropEditor.setParameters(_propertyEditorParams);
                    }
                }
                _configParam.setPropertyEditor(_cpPropEditor);
                _configParams[i] = _configParam;
            }
            _serviceDesc.setConfigParameters(_configParams);
            Element[] _operationConfigElms = DOMUtil.getChildElements(_descriptorRoot, "operation-config");
            HashMap<String, OperationConfig> _operationConfigMap = new HashMap<String, OperationConfig>();
            for (int i = 0; i < _operationConfigElms.length; ++i) {
                Element _operationConfigElm = _operationConfigElms[i];
                String _operationNamesTxt = TextUtil.trim(DOMUtil.getTextForChild(_operationConfigElm, "operation-name"));
                String _txType = TextUtil.trim(DOMUtil.getTextForChild(_operationConfigElm, "transaction-type"));
                String _txPropagation = TextUtil.trim(DOMUtil.getTextForChild(_operationConfigElm, "transaction-propagation"));
                String _txTimeout = TextUtil.trim(DOMUtil.getTextForChild(_operationConfigElm, "transaction-timeout"));
                String[] _operationNames = _operationNamesTxt.split(" ");
                for (int x = 0; x < _operationNames.length; ++x) {
                    OperationConfig _config = new OperationConfig(_txType, _txPropagation, _txTimeout);
                    _operationConfigMap.put(_operationNames[x], _config);
                }
            }
            Element _specificationsElm = DOMUtil.getChildElement(_descriptorRoot, "specifications");
            if (_specificationsElm != null) {
                Element[] _specificationElms = DOMUtil.getChildElements(_specificationsElm, "specification");
                String[] _specificationIds = new String[_specificationElms.length];
                for (int i = 0; i < _specificationElms.length; ++i) {
                    String _specId;
                    Element _specificationElm = _specificationElms[i];
                    _specificationIds[i] = _specId = TextUtil.trim(_specificationElm.getAttribute("spec-id"));
                }
                _serviceDesc.setSpecificationIds(_specificationIds);
            }
            Element _operationsElm = DOMUtil.getChildElement(_descriptorRoot, "operations");
            List<Object> _includes = null;
            ArrayList<String> _explicitlyMappedMethodsLst = new ArrayList<String>();
            if (_operationsElm != null) {
                _includes = Arrays.asList(TextUtil.split(_operationsElm.getAttribute("includes"), ','));
                Element[] _operationElms = DOMUtil.getChildElements(_operationsElm, "operation");
                for (int i = 0; i < _operationElms.length; ++i) {
                    OperationConfig _config;
                    Element _operationElm = _operationElms[i];
                    String _opName = TextUtil.trim(DOMUtil.getRequiredTextForAttr(_operationElm, NAME_ATTR));
                    String _opMethod = TextUtil.trim(_operationElm.getAttribute(METHOD_ATTR));
                    if (TextUtil.isEmpty(_opMethod)) {
                        _opMethod = _opName;
                    }
                    String _opTitle = TextUtil.trim(_operationElm.getAttribute("title"));
                    String _opHint = TextUtil.trim(DOMUtil.getTextForChild(_operationElm, "hint"));
                    boolean _opLongLived = !TextUtil.isEmpty(DOMUtil.getTextForChild(_operationElm, "long-lived")) && TextUtil.trim(DOMUtil.getTextForChild(_operationElm, "long-lived")).equalsIgnoreCase("true");
                    boolean _opPrivate = !TextUtil.isEmpty(_operationElm.getAttribute("private")) && TextUtil.trim(_operationElm.getAttribute("private")).equalsIgnoreCase("true");
                    boolean _opOrchestrateable = TextUtil.isEmpty(_operationElm.getAttribute("orchestrateable")) || TextUtil.trim(_operationElm.getAttribute("orchestrateable")).equalsIgnoreCase("true");
                    boolean _opAnonymousAccess = !TextUtil.isEmpty(_operationElm.getAttribute("anonymous-access")) && TextUtil.trim(_operationElm.getAttribute("anonymous-access")).equalsIgnoreCase("true");
                    Element _opSupportedConnectorsElm = DOMUtil.getChildElement(_operationElm, "supported-connectors");
                    String[] _opSupportedConnectors = null;
                    if (_opSupportedConnectorsElm != null) {
                        String _opSupportedConnectorsValue = TextUtil.trim(DOMUtil.getTextForChild(_operationElm, "supported-connectors"));
                        if (!TextUtil.isEmpty(_opSupportedConnectorsValue)) {
                            if (_opSupportedConnectorsValue.equals("default")) {
                                _opSupportedConnectors = ServiceRegistryImpl.getDefaultProviderIds();
                            } else {
                                _opSupportedConnectorsValue = TextUtil.replace(_opSupportedConnectorsValue, "default", TextUtil.trim(ServiceRegistryImpl.getDefaultProvidersString()));
                                _opSupportedConnectors = TextUtil.split(_opSupportedConnectorsValue, ',');
                            }
                        } else {
                            _opSupportedConnectors = new String[]{};
                        }
                    }
                    byte[] _opSmallIcon = null;
                    try {
                        _iconResource = TextUtil.trim(DOMUtil.getTextForChild(_operationElm, "small-icon"));
                        if (!TextUtil.isEmpty(_iconResource)) {
                            _opSmallIcon = IOUtil.readByteArrayFromResource(this.m_ctx.getClassLoader(), _iconResource);
                        }
                    }
                    catch (Throwable ex) {
                        logger.log(Level.WARNING, "Unable to load small-icon: " + _iconResource + " in component: " + this.m_ctx.getComponent().getComponentId() + ":" + this.m_ctx.getComponent().getVersion() + " cause: " + ex.getMessage());
                    }
                    byte[] _opLargeIcon = null;
                    try {
                        _iconResource = TextUtil.trim(DOMUtil.getTextForChild(_operationElm, "large-icon"));
                        if (!TextUtil.isEmpty(_iconResource)) {
                            _opLargeIcon = IOUtil.readByteArrayFromResource(this.m_ctx.getClassLoader(), _iconResource);
                        }
                    }
                    catch (Throwable ex) {
                        logger.log(Level.WARNING, "Unable to load small-icon: " + _iconResource + " in component: " + this.m_ctx.getComponent().getComponentId() + ":" + this.m_ctx.getComponent().getVersion() + " cause: " + ex.getMessage());
                    }
                    String _txType = TextUtil.trim(DOMUtil.getTextForChild(_operationElm, "transaction-type"));
                    String _txPropagation = TextUtil.trim(DOMUtil.getTextForChild(_operationElm, "transaction-propagation"));
                    String _txTimeoutTxt = TextUtil.trim(DOMUtil.getTextForChild(_operationElm, "transaction-timeout"));
                    int _txTimeout = -1;
                    _explicitlyMappedMethodsLst.add(_opMethod);
                    LayoutImpl _layout = new LayoutImpl();
                    Element _layoutElm = DOMUtil.getChildElement(_operationElm, "layout");
                    if (_layoutElm != null) {
                        Element[] _sectionElms = DOMUtil.getChildElements(_layoutElm, "section");
                        ArrayList<SectionImpl> _sections = new ArrayList<SectionImpl>(_sectionElms.length);
                        for (int y = 0; y < _sectionElms.length; ++y) {
                            Element _sectionElm = _sectionElms[y];
                            SectionImpl _section = new SectionImpl();
                            _section.setName(_sectionElm.getAttribute(NAME_ATTR));
                            Element[] _propertyElms = DOMUtil.getChildElements(_sectionElm, PROPERTY_ATTR);
                            ArrayList<PropertyImpl> _properties = new ArrayList<PropertyImpl>(_propertyElms.length);
                            for (int x = 0; x < _propertyElms.length; ++x) {
                                Element _propertyElm = _propertyElms[x];
                                PropertyImpl _property = new PropertyImpl();
                                _property.setRef(_propertyElm.getAttribute("ref"));
                                _properties.add(_property);
                            }
                            _section.setProperties(_properties);
                            _sections.add(_section);
                        }
                        _layout.setSections(_sections);
                    }
                    if ((_config = (OperationConfig)_operationConfigMap.get(_opName)) == null) {
                        _config = (OperationConfig)_operationConfigMap.get("*");
                    }
                    if (_config != null) {
                        if (TextUtil.isEmpty(_txType)) {
                            _txType = _config.getTransactionType();
                        }
                        if (TextUtil.isEmpty(_txPropagation)) {
                            _txPropagation = _config.getTransactionPropagation();
                        }
                        if (TextUtil.isEmpty(_txTimeoutTxt)) {
                            _txTimeoutTxt = _config.getTransactionTimeout();
                        }
                    }
                    try {
                        _txTimeout = Integer.parseInt(_txTimeoutTxt);
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    Method _methodByName = null;
                    Class<?>[] _methodByNameParams = null;
                    Method[] _methods = _implementationClass.getMethods();
                    ArrayList<Method> _methodsWithName = new ArrayList<Method>();
                    for (int z = 0; z < _methods.length; ++z) {
                        Method _method = _methods[z];
                        if (!_method.getName().equals(_opMethod)) continue;
                        _methodsWithName.add(_method);
                    }
                    if (_methodsWithName.size() == 1) {
                        _methodByName = (Method)_methodsWithName.get(0);
                        _methodByNameParams = _methodByName.getParameterTypes();
                    }
                    OperationImpl _operationDesc = new OperationImpl();
                    _operationDesc.setName(_opName);
                    _operationDesc.setTitle(_opTitle);
                    _operationDesc.setHint(_opHint);
                    _operationDesc.setLongLived(_opLongLived);
                    _operationDesc.setAccessLevel(_opPrivate ? (short)1 : 0);
                    _operationDesc.setOrchestrateable(_opOrchestrateable);
                    _operationDesc.setAnonymousAccess(_opAnonymousAccess);
                    _operationDesc.setSupportedConnectorIds(_opSupportedConnectors);
                    _operationDesc.setSmallIcon(_opSmallIcon);
                    _operationDesc.setLargeIcon(_opLargeIcon);
                    _operationDesc.setTransactionTimeout(_txTimeout);
                    _operationDesc.setTransactionType(_txType);
                    _operationDesc.setTransactionPropagation(_txPropagation);
                    _operationDesc.setLayout(_layout);
                    Element[] _inputParamElms = DOMUtil.getChildElements(_operationElm, "input-parameter");
                    InputParameter[] _inputDescriptors = new InputParameter[_inputParamElms.length];
                    HashMap<String, InputParameterImpl> _inParams = new HashMap<String, InputParameterImpl>(_inputDescriptors.length);
                    for (int x = 0; x < _inputParamElms.length; ++x) {
                        Element _inputParam = _inputParamElms[x];
                        String _ipName = TextUtil.trim(DOMUtil.getRequiredTextForAttr(_inputParam, NAME_ATTR));
                        String _ipTitle = TextUtil.trim(_inputParam.getAttribute("title"));
                        String _ipHint = TextUtil.trim(DOMUtil.getTextForChild(_inputParam, "hint"));
                        String[] _ipSupportedExpressionTypes = TextUtil.split(TextUtil.trim(DOMUtil.getTextForChild(_inputParam, "supported-expr-types")), ',');
                        boolean _ipHidden = !TextUtil.isEmpty(_inputParam.getAttribute("hidden")) && TextUtil.trim(_inputParam.getAttribute("hidden")).equalsIgnoreCase("true");
                        String _ipRequiredStr = TextUtil.trim(_inputParam.getAttribute("required"));
                        boolean _ipRequired = !TextUtil.isEmpty(_ipRequiredStr) && _ipRequiredStr.equalsIgnoreCase("true");
                        String _ipType = TextUtil.trim(_inputParam.getAttribute("type"));
                        if (TextUtil.isEmpty(_ipType)) {
                            _ipType = _methodByNameParams != null && _methodByNameParams.length > x ? _methodByNameParams[x].getName() : String.class.getName();
                        }
                        String _defaultValue = DOMUtil.getTextForChild(_inputParam, "default-value");
                        InputParameterImpl _inputDesc = new InputParameterImpl();
                        _inputDesc.setName(_ipName);
                        _inputDesc.setTitle(_ipTitle);
                        _inputDesc.setHint(_ipHint);
                        _inputDesc.setHidden(_ipHidden);
                        _inputDesc.setSupportedExpressionTypes(_ipSupportedExpressionTypes);
                        _inputDesc.setType(ClassHelper.getLoadableClassName(_ipType));
                        _inputDesc.setRequired(_ipRequired);
                        _inputDesc.setDefaultValue(_defaultValue);
                        PropertyEditorImpl _cpPropEditor = new PropertyEditorImpl();
                        Element _propertyEditorElm = DOMUtil.getChildElement(_inputParam, "property-editor");
                        if (_propertyEditorElm != null) {
                            _cpPropEditor.setEditorId(_propertyEditorElm.getAttribute("editor-id"));
                            Element[] _propertyEditorParamElms = DOMUtil.getChildElements(_propertyEditorElm, "parameter");
                            if (_propertyEditorParamElms != null && _propertyEditorParamElms.length > 0) {
                                HashMap<String, String> _propertyEditorParams = new HashMap<String, String>();
                                for (int k = 0; k < _propertyEditorParamElms.length; ++k) {
                                    Element _propertyEditorParamElm = _propertyEditorParamElms[k];
                                    String _name = _propertyEditorParamElm.getAttribute(NAME_ATTR);
                                    String _value = _propertyEditorParamElm.getAttribute("value");
                                    if (TextUtil.isEmpty(_name)) continue;
                                    _propertyEditorParams.put(_name, _value);
                                }
                                _cpPropEditor.setParameters(_propertyEditorParams);
                            }
                        }
                        _inputDesc.setPropertyEditor(_cpPropEditor);
                        _inputDescriptors[x] = _inputDesc;
                        _inParams.put(_inputDesc.getName(), _inputDesc);
                    }
                    _operationDesc.setInputParameters(_inputDescriptors);
                    Method _method = this.getMethod(_implementationClass, _opMethod, _inputDescriptors, _serviceDesc.getServiceId(), _operationDesc.getName());
                    if (_method == null) {
                        logger.log(Level.WARNING, "Method not found for service descriptor: " + _serviceDesc.getServiceId() + " and operation: " + _operationDesc.getName());
                        _operationDesc.getAttributes().put(METHOD_ATTR, _opMethod);
                    } else {
                        _operationDesc.getAttributes().put(METHOD_ATTR, _method.getName());
                    }
                    Element[] _outputParamElms = DOMUtil.getChildElements(_operationElm, "output-parameter");
                    OutputParameter[] _outputDescriptors = new OutputParameter[_outputParamElms.length];
                    for (int x = 0; x < _outputParamElms.length; ++x) {
                        Class<?> _returnType;
                        OutputParameterImpl _outputDesc = new OutputParameterImpl();
                        Element _outputParam = _outputParamElms[x];
                        String _outName = TextUtil.trim(DOMUtil.getRequiredTextForAttr(_outputParam, NAME_ATTR));
                        String _outBeanProperty = TextUtil.trim(_outputParam.getAttribute(PROPERTY_ATTR));
                        String _outType = TextUtil.trim(_outputParam.getAttribute("type"));
                        String _outTitle = TextUtil.trim(_outputParam.getAttribute("title"));
                        String _outHint = TextUtil.trim(DOMUtil.getTextForChild(_outputParam, "hint"));
                        boolean _outHidden = !TextUtil.isEmpty(_outputParam.getAttribute("hidden")) && TextUtil.trim(_outputParam.getAttribute("hidden")).equalsIgnoreCase("true");
                        InputParameterImpl _inputDesc = (InputParameterImpl)_inParams.get(_outName);
                        if (!TextUtil.isEmpty(_outBeanProperty)) {
                            _outputDesc.getAttributes().put(BINDING_TYPE_ATTR, BEAN_PROPERTY_OUTPUT_BINDING);
                            _outputDesc.getAttributes().put(PROPERTY_ATTR, _outBeanProperty);
                            if (_method != null) {
                                _returnType = _method.getReturnType();
                                if (_returnType == null) {
                                    throw new InvalidBeanPropertyException(_serviceDesc.getServiceId(), _opName, _outBeanProperty, _outName, Void.TYPE.getName());
                                }
                                if (ClassHelper.isPrimitive(_returnType)) {
                                    throw new InvalidBeanPropertyException(_serviceDesc.getServiceId(), _opName, _outBeanProperty, _outName, _returnType.getName());
                                }
                                PropertyDescriptor _desc = ClassHelper.getPropertyDescriptor(_returnType, _outBeanProperty);
                                if (_desc == null) {
                                    throw new InvalidBeanPropertyException(_serviceDesc.getServiceId(), _opName, _outBeanProperty, _outName, _returnType.getName());
                                }
                                _outType = _desc.getPropertyType().getName();
                            }
                        } else if (_inputDesc != null) {
                            if (TextUtil.isEmpty(_outType)) {
                                _outType = _inputDesc.getType();
                            }
                            if (!_outType.equals(_inputDesc.getType())) {
                                logger.log(Level.FINE, "In/Out parameter: " + _outName + " on service: " + _serviceDesc.getServiceId() + " operation: " + _operationDesc.getName() + " has mismatched types on input vs. output (OUTPUT BINDING TYPE WILL BE RETURN)");
                                _outputDesc.getAttributes().put(BINDING_TYPE_ATTR, RETURN_OUTPUT_BINDING);
                            } else if (_method != null && _method.getReturnType() != null && _method.getReturnType().getName().equals(ClassHelper.getLoadableClassName(_outType))) {
                                logger.log(Level.FINE, "In/Out parameter: " + _outName + " on service: " + _serviceDesc.getServiceId() + " operation: " + _operationDesc.getName() + " has return parameter of the same type (OUTPUT BINDING TYPE WILL BE RETURN)");
                                _outputDesc.getAttributes().put(BINDING_TYPE_ATTR, RETURN_OUTPUT_BINDING);
                            } else {
                                _outputDesc.getAttributes().put(BINDING_TYPE_ATTR, INPUT_OUTPUT_BINDING);
                                _inputDesc.setInOutParameter(true);
                                _outputDesc.setInOutParameter(true);
                            }
                        } else {
                            if (TextUtil.isEmpty(_outType)) {
                                if (_method != null && (_returnType = _method.getReturnType()) != null && _returnType != Void.TYPE) {
                                    _outType = _returnType.getName();
                                }
                                if (TextUtil.isEmpty(_outType)) {
                                    _outType = String.class.getName();
                                }
                            }
                            _outputDesc.getAttributes().put(BINDING_TYPE_ATTR, RETURN_OUTPUT_BINDING);
                        }
                        _outputDesc.setName(_outName);
                        _outputDesc.setTitle(_outTitle);
                        _outputDesc.setHint(_outHint);
                        _outputDesc.setHidden(_outHidden);
                        _outputDesc.setType(ClassHelper.getLoadableClassName(_outType));
                        _outputDescriptors[x] = _outputDesc;
                    }
                    _operationDesc.setOutputParameters(_outputDescriptors);
                    Element _faultsElm = DOMUtil.getChildElement(_operationElm, "faults");
                    Fault[] _faults = null;
                    if (_faultsElm != null) {
                        Element[] _faultElms = DOMUtil.getChildElements(_faultsElm, "fault");
                        _faults = new Fault[_faultElms.length];
                        for (int x = 0; x < _faultElms.length; ++x) {
                            Element _faultElm = _faultElms[x];
                            String _fName = TextUtil.trim(DOMUtil.getRequiredTextForAttr(_faultElm, NAME_ATTR));
                            String _fTitle = TextUtil.trim(_faultElm.getAttribute("title"));
                            String _fType = TextUtil.trim(DOMUtil.getRequiredTextForAttr(_faultElm, "type"));
                            String _fDescription = TextUtil.trim(DOMUtil.getTextForChild(_faultElm, "description"));
                            String _fHint = TextUtil.trim(DOMUtil.getTextForChild(_faultElm, "hint"));
                            FaultImpl _fault = new FaultImpl();
                            _fault.setName(_fName);
                            _fault.setTitle(_fTitle);
                            _fault.setType(_fType);
                            _fault.setDescription(_fDescription);
                            _fault.setHint(_fHint);
                            _faults[x] = _fault;
                        }
                    } else if (_method != null) {
                        Class<?>[] _exceptionTypes = _method.getExceptionTypes();
                        _faults = new Fault[_exceptionTypes.length];
                        for (int x = 0; x < _exceptionTypes.length; ++x) {
                            Class<?> _exceptionType = _exceptionTypes[x];
                            FaultImpl _faultImpl = new FaultImpl();
                            _faultImpl.setName(_exceptionType.getName());
                            _faultImpl.setType(_exceptionType.getName());
                            _faults[x] = _faultImpl;
                        }
                    }
                    _operationDesc.setFaults(_faults);
                    _serviceDesc.addOperation(_operationDesc);
                }
            } else {
                _includes = new ArrayList<String>(1);
                _includes.add("*");
            }
            if (_includes.size() > 0) {
                Method[] _methods = _implementationClass.getDeclaredMethods();
                for (int i = 0; i < _methods.length; ++i) {
                    Method _method = _methods[i];
                    if (_method.getName().equals("class$") || _explicitlyMappedMethodsLst.contains(_method.getName()) || !_includes.contains("*") && !_includes.contains(_method.getName())) continue;
                    OperationConfig _config = (OperationConfig)_operationConfigMap.get(_method.getName());
                    if (_config == null) {
                        _config = (OperationConfig)_operationConfigMap.get("*");
                    }
                    OperationImpl _operationDesc = new OperationImpl();
                    _operationDesc.setName(_method.getName());
                    if (_config != null) {
                        if (!TextUtil.isEmpty(_config.getTransactionType())) {
                            _operationDesc.setTransactionType(_config.getTransactionType());
                        }
                        if (!TextUtil.isEmpty(_config.getTransactionPropagation())) {
                            _operationDesc.setTransactionPropagation(_config.getTransactionPropagation());
                        }
                        if (!TextUtil.isEmpty(_config.getTransactionTimeout())) {
                            try {
                                _operationDesc.setTransactionTimeout(Integer.parseInt(_config.getTransactionTimeout()));
                            }
                            catch (NumberFormatException ex) {
                                // empty catch block
                            }
                        }
                    }
                    _operationDesc.getAttributes().put(METHOD_ATTR, _method.getName());
                    Class<?>[] _parameterTypes = _method.getParameterTypes();
                    InputParameter[] _inputDescriptors = new InputParameter[_parameterTypes.length];
                    for (int x = 0; x < _parameterTypes.length; ++x) {
                        Class<?> _parameterType = _parameterTypes[x];
                        InputParameterImpl _inputDesc = new InputParameterImpl();
                        _inputDesc.setName("param" + x);
                        _inputDesc.setType(_parameterType.getName());
                        _inputDescriptors[x] = _inputDesc;
                    }
                    OutputParameter[] _outputDescriptors = null;
                    if (_method.getReturnType() != Void.TYPE) {
                        _outputDescriptors = new OutputParameter[1];
                        OutputParameterImpl _outputDesc = new OutputParameterImpl();
                        _outputDesc.setName("return0");
                        _outputDesc.setType(_method.getReturnType().getName());
                        _outputDescriptors[0] = _outputDesc;
                    } else {
                        _outputDescriptors = new OutputParameter[]{};
                    }
                    Class<?>[] _exceptionTypes = _method.getExceptionTypes();
                    Fault[] _faults = new Fault[_exceptionTypes.length];
                    for (int x = 0; x < _exceptionTypes.length; ++x) {
                        Class<?> _exceptionType = _exceptionTypes[x];
                        FaultImpl _faultImpl = new FaultImpl();
                        _faultImpl.setName(_exceptionType.getName());
                        _faultImpl.setType(_exceptionType.getName());
                        _faults[x] = _faultImpl;
                    }
                    _operationDesc.setInputParameters(_inputDescriptors);
                    _operationDesc.setOutputParameters(_outputDescriptors);
                    _operationDesc.setFaults(_faults);
                    _serviceDesc.addOperation(_operationDesc);
                }
            }
            if ((_servicePoolConfig = this.createServicePoolConfigurationFromElement(_serviceDesc, _descriptorRoot)) != null) {
                _serviceDesc.setPoolConfiguration(_servicePoolConfig);
            }
            return _serviceDesc;
        }
        catch (NoSuchMethodException ex) {
            throw new DSCRuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    protected ServicePoolConfiguration createServicePoolConfigurationFromElement(ServiceConfiguration serviceDesc, Element descriptorRoot) {
        Element _poolingElm = DOMUtil.getChildElement(descriptorRoot, "pool");
        ServicePoolConfigurationImpl _servicePoolConfig = null;
        if (_poolingElm != null) {
            Element _maxAsynchInstancesElem;
            Element _maxWaitElem;
            Element _maxInstancesElem;
            _servicePoolConfig = new ServicePoolConfigurationImpl();
            int initialInstances = 0;
            int maxInstances = 0;
            long maxWait = 0L;
            int maxAsynchInstances = 0;
            Element _initialInstancesElem = DOMUtil.getChildElement(_poolingElm, "initial-instances");
            if (_initialInstancesElem != null) {
                String _initialInstancesVal = DOMUtil.getTextForNode(_initialInstancesElem);
                initialInstances = Integer.parseInt(_initialInstancesVal);
                _servicePoolConfig.setInitialInstances(initialInstances);
            }
            if ((_maxInstancesElem = DOMUtil.getChildElement(_poolingElm, "max-instances")) != null) {
                String _maxInstancesVal = DOMUtil.getTextForNode(_maxInstancesElem);
                maxInstances = Integer.parseInt(_maxInstancesVal);
                _servicePoolConfig.setMaxInstances(maxInstances);
            }
            if ((_maxWaitElem = DOMUtil.getChildElement(_poolingElm, "max-wait")) != null) {
                String _maxWaitVal = DOMUtil.getTextForNode(_maxWaitElem);
                maxWait = Long.parseLong(_maxWaitVal);
                _servicePoolConfig.setMaxWait(maxWait);
            }
            if ((_maxAsynchInstancesElem = DOMUtil.getChildElement(_poolingElm, "max-asynch-instances")) != null) {
                String _maxAsynchInstancesVal = DOMUtil.getTextForNode(_maxAsynchInstancesElem);
                maxAsynchInstances = Integer.parseInt(_maxAsynchInstancesVal);
                _servicePoolConfig.setMaxAsynchronousInstances(maxAsynchInstances);
            }
        }
        return _servicePoolConfig;
    }

    protected Method getMethod(Class aClass, String aMethodName, InputParameter[] aInputs, String aDescriptorName, String aOperationName) throws ClassNotFoundException, NoSuchMethodException {
        String _methodName = aMethodName;
        Class[] _paramTypes = null;
        int x = _methodName.indexOf(";");
        if (x > -1) {
            String[] _classNames = TextUtil.split(_methodName.substring(x + 1), ',');
            _methodName = _methodName.substring(0, x);
            _paramTypes = new Class[_classNames.length];
            for (int i = 0; i < _classNames.length; ++i) {
                Class _paramClass = null;
                try {
                    _paramClass = ClassHelper.forName(_classNames[i], this.m_ctx.getClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    logger.log(Level.WARNING, "Class: " + _classNames[i] + " not found for method specification on service description: " + aDescriptorName + " and operation: " + aOperationName);
                    return null;
                }
                _paramTypes[i] = _paramClass;
            }
        } else if (aInputs != null) {
            _paramTypes = new Class[aInputs.length];
            for (int i = 0; i < aInputs.length; ++i) {
                Class _paramClass = null;
                try {
                    _paramClass = ClassHelper.forName(aInputs[i].getType(), this.m_ctx.getClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    logger.log(Level.WARNING, "Class: " + aInputs[i].getType() + " not found for input parameter: " + aInputs[i].getName() + " on service description: " + aDescriptorName + " and operation: " + aOperationName);
                    return null;
                }
                _paramTypes[i] = _paramClass;
            }
        } else {
            _paramTypes = new Class[]{};
        }
        Method _method = null;
        try {
            _method = aClass.getMethod(_methodName, _paramTypes);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (NoSuchMethodError error) {
            // empty catch block
        }
        return _method;
    }

    protected class OperationConfig {
        protected String m_txType;
        protected String m_txPropagation;
        protected String m_txTimeout;

        public OperationConfig(String aTxType, String aTxProp, String aTxTimeout) {
            this.m_txType = aTxType;
            this.m_txPropagation = aTxProp;
            this.m_txTimeout = aTxTimeout;
        }

        public String getTransactionType() {
            return this.m_txType;
        }

        public String getTransactionPropagation() {
            return this.m_txPropagation;
        }

        public String getTransactionTimeout() {
            return this.m_txTimeout;
        }
    }
}

