/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.clientsdk;

import com.adobe.idp.Context;
import com.adobe.idp.DocumentManagerClient;
import com.adobe.idp.dsc.DSCError;
import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.FaultCallBackInfo;
import com.adobe.idp.dsc.InvocationContext;
import com.adobe.idp.dsc.InvocationContextStack;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.ResponseCallBackInfo;
import com.adobe.idp.dsc.authentication.PasswordCredential;
import com.adobe.idp.dsc.clientsdk.ServiceClient;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactoryProperties;
import com.adobe.idp.dsc.impl.FaultCallBackInfoImpl;
import com.adobe.idp.dsc.impl.InvocationRequestImpl;
import com.adobe.idp.dsc.impl.ResponseCallBackInfoImpl;
import com.adobe.idp.dsc.provider.MessageDispatcher;
import com.adobe.idp.dsc.provider.impl.ejb.EjbMessageDispatcher;
import com.adobe.idp.dsc.util.ClassHelper;
import com.adobe.idp.dsc.util.TextUtil;
import com.adobe.logging.AdobeLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.naming.NamingException;

public final class ServiceClientFactory {
    private Properties m_properties;
    Context m_context;
    private static AdobeLogger m_logger = AdobeLogger.getAdobeLogger(ServiceClientFactory.class);
    private static ThrowHandler DEFAULT_THROW_HANDLER;
    private static ThrowHandler m_throwHandler;
    private static Properties m_providerProperties;
    private static String m_hostAddress;
    private PasswordCredential m_credential = null;
    private ServiceClient m_serviceClient;
    private MessageDispatcher m_dispatcher;
    private static Properties defaultProperties;
    private Properties m_providerIdProperties;
    private static Class[] EMPTY_CLASS_ARRAY;
    private static Object[] EMPTY_OBJECT_ARRAY;

    public static synchronized void setDefaultProperties(Properties aProps) {
        defaultProperties = aProps;
    }

    public static synchronized Properties getDefaultProperties() {
        return defaultProperties;
    }

    static ThrowHandler getThrowHandler() {
        return m_throwHandler;
    }

    public static void installThrowHandler(ThrowHandler th) {
        if (m_throwHandler == DEFAULT_THROW_HANDLER) {
            m_throwHandler = th;
        } else {
            new DSCError(6);
        }
    }

    public static ServiceClientFactory createInstance() {
        if (ServiceClientFactory.inContainer()) {
            return ServiceClientFactory.createInstance((Properties)null);
        }
        return ServiceClientFactory.createInstance(ServiceClientFactory.getDefaultProperties());
    }

    public static ServiceClientFactory createInstance(Context aContext) {
        if (aContext == null) {
            return ServiceClientFactory.createInstance((Properties)null);
        }
        Properties _p = new Properties();
        _p.put(ServiceClientFactoryProperties.DSC_CONTEXT, aContext);
        return ServiceClientFactory.createInstance(_p);
    }

    public static ServiceClientFactory createInstance(Properties aProperties) throws DSCRuntimeException {
        ServiceClientFactory factory = null;
        m_logger.entering("createInstance", aProperties == null ? "" : "Properties" + aProperties);
        String serviceFactoryClassName = null;
        if (aProperties != null) {
            serviceFactoryClassName = aProperties.getProperty(ServiceClientFactoryProperties.DSC_CLIENTSERVICE_FACTORY_CLASS, null);
        }
        if (serviceFactoryClassName != null) {
            try {
                factory = (ServiceClientFactory)ClassHelper.loadClass(serviceFactoryClassName, ServiceClientFactory.class).newInstance();
            }
            catch (Exception e) {
                m_logger.debug(e, "Error loading Service Client Factory");
            }
        } else {
            factory = new ServiceClientFactory();
        }
        if (factory != null) {
            if (aProperties != null && !aProperties.isEmpty()) {
                factory.setProperties(aProperties);
                String _user = aProperties.getProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL_USERNAME);
                String _pass = aProperties.getProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL_PASSWORD);
                Context _ctx = (Context)aProperties.get(ServiceClientFactoryProperties.DSC_CONTEXT);
                if (_user != null && _pass != null) {
                    if (_ctx != null) {
                        throw new DSCRuntimeException(new DSCError(205));
                    }
                    PasswordCredential _credential = new PasswordCredential();
                    _credential.setUserName(_user);
                    _credential.setPassword(_pass);
                    factory.setCredential(_credential);
                } else if (_ctx != null) {
                    factory.setContext(_ctx);
                }
                String docHttpRoot = aProperties.getProperty(ServiceClientFactoryProperties.DSC_DOCUMENT_HTTP_ENDPOINT);
                if (docHttpRoot != null) {
                    DocumentManagerClient.setHttpRoot(docHttpRoot);
                }
            }
            if (m_providerProperties == null) {
                try {
                    InputStream _stream = null;
                    String providerResource = (String)factory.getProperty(ServiceClientFactoryProperties.DSC_PROVIDER_PROPERTIES_RESOURCE);
                    if (providerResource == null) {
                        providerResource = "com/adobe/idp/dsc/clientsdk/Provider.properties";
                    }
                    if ((_stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(providerResource)) == null) {
                        _stream = ServiceClientFactory.class.getClassLoader().getResourceAsStream(providerResource);
                    }
                    if (_stream == null) {
                        throw new FileNotFoundException(providerResource);
                    }
                    if (_stream != null) {
                        m_providerProperties = new Properties();
                        m_providerProperties.load(_stream);
                    }
                }
                catch (Exception e) {
                    m_providerProperties = null;
                    throw new DSCRuntimeException(new DSCError(218), (Throwable)e);
                }
            }
        }
        m_logger.exiting("createInstance", "factory", factory);
        return factory;
    }

    public static ServiceClientFactory createInstance(String aResourceName) {
        Properties _properties = null;
        m_logger.entering("createInstance", "resourceName" + aResourceName);
        InputStream stream = ClassHelper.getResourceAsStream(aResourceName, ServiceClientFactory.class);
        _properties = ServiceClientFactory.getPropertiesFromStream(stream);
        ServiceClientFactory serviceClientFactory = _properties == null ? null : ServiceClientFactory.createInstance(_properties);
        m_logger.exiting("createInstance", "serviceClientFactory", serviceClientFactory);
        return serviceClientFactory;
    }

    public static ServiceClientFactory createInstance(URL aPropertyURL) {
        Properties _properties = null;
        m_logger.entering("createInstance", "propertyURL", aPropertyURL);
        if (aPropertyURL != null) {
            InputStream inputStream = null;
            try {
                inputStream = aPropertyURL.openStream();
                _properties = ServiceClientFactory.getPropertiesFromStream(inputStream);
            }
            catch (IOException e) {
                m_logger.debug(e, "Failed to open propertyURL " + aPropertyURL);
            }
        }
        ServiceClientFactory serviceClientFactory = _properties == null ? null : ServiceClientFactory.createInstance(_properties);
        m_logger.exiting("createInstance", "serviceClientFactory", serviceClientFactory);
        return serviceClientFactory;
    }

    public ServiceClient getServiceClient() {
        if (this.m_serviceClient == null) {
            this.m_serviceClient = new ServiceClient(this);
        }
        return this.m_serviceClient;
    }

    public InvocationRequest createInvocationRequest(String aServiceName, String aOperationName, Map aParameterInput, boolean synchronous) throws DSCRuntimeException {
        if (aOperationName == null) {
            throw new DSCRuntimeException(new DSCError(201));
        }
        if (aOperationName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(202));
        }
        if (aServiceName == null) {
            throw new DSCRuntimeException(new DSCError(203));
        }
        if (aServiceName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(204));
        }
        InvocationRequestImpl request = new InvocationRequestImpl();
        request.setServiceName(aServiceName);
        request.setOperationName(aOperationName);
        request.setInputParameters(aParameterInput);
        request.setSynchronous(synchronous);
        if (this.m_properties != null && !this.m_properties.isEmpty()) {
            String _passthroughStrategy;
            String _user = this.m_properties.getProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL_USERNAME);
            String _pass = this.m_properties.getProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL_PASSWORD);
            if (_user != null && _pass != null && this.getContext() == null) {
                PasswordCredential _credential = new PasswordCredential();
                _credential.setUserName(_user);
                _credential.setPassword(_pass);
                this.setCredential(_credential);
            }
            if (!TextUtil.isEmpty(_passthroughStrategy = this.m_properties.getProperty(ServiceClientFactoryProperties.DSC_IN_VM_PASSTHROUGH_STRATEGY))) {
                request.setProperty(ServiceClientFactoryProperties.DSC_IN_VM_PASSTHROUGH_STRATEGY, _passthroughStrategy);
            }
        } else if (this.m_context != null) {
            request.setProperty("DSC_CONTEXT", this.m_context);
        } else {
            InvocationContext _ic = InvocationContextStack.getInstance().peek();
            if (_ic != null && _ic.getContext() != null) {
                request.setProperty("DSC_CONTEXT", _ic.getContext());
            }
        }
        String _protocol = (String)this.getProperty("DSC_TRANSPORT_PROTOCOL");
        if (TextUtil.isEmpty(_protocol)) {
            _protocol = this.getDefaultProtocol();
        }
        if (this.m_providerIdProperties != null && this.m_providerIdProperties.size() > 0) {
            request.setProperty("CONNECTOR_ID", this.m_providerIdProperties.get("CONNECTOR_ID"));
            request.setProperty("ENDPOINT_PUBLIC_ID", this.m_providerIdProperties.get("ENDPOINT_PUBLIC_ID"));
        } else if (!TextUtil.isEmpty(_protocol)) {
            request.setProperty("CONNECTOR_ID", _protocol);
            request.setProperty("ENDPOINT_PUBLIC_ID", m_hostAddress);
        }
        return request;
    }

    public synchronized Context getContext() {
        return this.m_context;
    }

    public synchronized void setContext(Context aContext) {
        if (this.m_credential != null) {
            throw new DSCRuntimeException(new DSCError(205));
        }
        this.m_context = aContext;
    }

    public Object getProperty(String aPropertyName) {
        if (aPropertyName == null) {
            throw new DSCRuntimeException(new DSCError(206));
        }
        if (aPropertyName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(207));
        }
        Object _val = null;
        if (this.m_properties != null) {
            _val = this.m_properties.get(aPropertyName);
        }
        return _val;
    }

    protected void setupEjbDispatcherInitialContextEnvironment(EjbMessageDispatcher _ejbDispatcher, String aServerType) {
        String _initialFactory = null;
        String _providerURL = null;
        String _jndiFactoryURLPkg = null;
        _initialFactory = (String)this.getProperty("java.naming.factory.initial");
        _providerURL = (String)this.getProperty("java.naming.provider.url");
        _jndiFactoryURLPkg = (String)this.getProperty("java.naming.factory.url.pkgs");
        if (aServerType != null) {
            if (aServerType.equalsIgnoreCase("WebSphere")) {
                if (_initialFactory == null) {
                    _initialFactory = "com.ibm.ws.naming.util.WsnInitCtxFactory";
                }
            } else if (aServerType.equalsIgnoreCase("JBoss")) {
                if (_initialFactory == null) {
                    _initialFactory = "org.jnp.interfaces.NamingContextFactory";
                }
                if (_jndiFactoryURLPkg == null) {
                    _jndiFactoryURLPkg = "org.jboss.naming:org.jnp.interfaces";
                }
            } else if (aServerType.equalsIgnoreCase("WebLogic") && _initialFactory == null) {
                _initialFactory = "weblogic.jndi.WLInitialContextFactory";
            }
        }
        if (_initialFactory != null) {
            _ejbDispatcher.setJndiInitialFactory(_initialFactory);
        }
        if (_providerURL != null) {
            _ejbDispatcher.setJndiProviderUrl(_providerURL);
        }
        if (_jndiFactoryURLPkg != null) {
            _ejbDispatcher.setJndiUrlPkgPrefixes(_jndiFactoryURLPkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageDispatcher getMessageDispatcher(String aEndpointURI) throws DSCRuntimeException {
        ServiceClientFactory serviceClientFactory = this;
        synchronized (serviceClientFactory) {
            if (this.m_dispatcher == null) {
                this.m_dispatcher = this.createMessageDispatcher(aEndpointURI);
            }
        }
        return this.m_dispatcher;
    }

    synchronized void evaluateMessageDispatcher(Throwable aException) {
        String _protocol;
        if (this.m_dispatcher != null && (_protocol = (String)this.getProperty("DSC_TRANSPORT_PROTOCOL")) != null && _protocol.equals("EJB") && (aException instanceof EJBException || aException instanceof RemoteException || aException instanceof NamingException)) {
            this.m_dispatcher = null;
        }
    }

    protected MessageDispatcher createMessageDispatcher(String aEndpointURI) throws DSCRuntimeException {
        String dipatcherKey;
        String _protocol = (String)this.getProperty("DSC_TRANSPORT_PROTOCOL");
        String _dispatcherClass = null;
        if (TextUtil.isEmpty(_protocol)) {
            _protocol = this.getDefaultProtocol();
            if (this.m_properties != null) {
                this.m_properties.setProperty("DSC_TRANSPORT_PROTOCOL", _protocol);
            }
        }
        if ((_dispatcherClass = m_providerProperties.getProperty(dipatcherKey = _protocol + "_DISPATCHER")) == null || _dispatcherClass.length() == 0) {
            throw new DSCRuntimeException(new DSCError(209, _protocol));
        }
        MessageDispatcher _md = null;
        try {
            _md = (MessageDispatcher)Class.forName(_dispatcherClass).getConstructor(String.class).newInstance(aEndpointURI);
            if (_protocol.equals("EJB")) {
                EjbMessageDispatcher _ejbDispatcher = (EjbMessageDispatcher)_md;
                String serverType = (String)this.getProperty("DSC_SERVER_TYPE");
                this.setupEjbDispatcherInitialContextEnvironment(_ejbDispatcher, serverType);
                _ejbDispatcher.setJndiProviderUrl(aEndpointURI);
            }
        }
        catch (Exception e) {
            throw new DSCRuntimeException(new DSCError(217, _dispatcherClass, (Object)_protocol, (Object)e));
        }
        return _md;
    }

    protected String getDefaultProtocol() {
        if (ServiceClientFactory.inContainer()) {
            return "VM";
        }
        return "EJB";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropertiesFromStream(InputStream aStream) {
        Properties _properties = null;
        if (aStream != null) {
            try {
                _properties = new Properties();
                _properties.load(aStream);
            }
            catch (Exception e) {
                m_logger.debug(e, "Failed to load resource.");
            }
            finally {
                if (aStream != null) {
                    try {
                        aStream.close();
                    }
                    catch (Throwable ignore) {
                        m_logger.debug(ignore, "Failed to close stream.");
                    }
                }
            }
        }
        return _properties;
    }

    private ServiceClientFactory() {
    }

    PasswordCredential getCredential() {
        return this.m_credential;
    }

    void setCredential(PasswordCredential aCredential) {
        this.m_credential = aCredential;
    }

    private void setProperties(Properties aProperties) {
        this.m_properties = aProperties;
    }

    public ResponseCallBackInfo createResponseCallBackInfo(String serviceName, String operationName, String version) {
        ResponseCallBackInfoImpl responseCallBackInfo = new ResponseCallBackInfoImpl();
        responseCallBackInfo.setServiceName(serviceName);
        responseCallBackInfo.setOperationName(operationName);
        responseCallBackInfo.setServiceVersion(version);
        return responseCallBackInfo;
    }

    public FaultCallBackInfo createFaultCallBackInfo(String serviceName, String operationName, String version) {
        FaultCallBackInfoImpl faultCallBackInfo = new FaultCallBackInfoImpl();
        faultCallBackInfo.setServiceName(serviceName);
        faultCallBackInfo.setOperationName(operationName);
        faultCallBackInfo.setServiceVersion(version);
        return faultCallBackInfo;
    }

    private static boolean inContainer() {
        Class _cls = null;
        try {
            _cls = ClassHelper.loadClass("com.adobe.idp.dsc.DSContainer", ServiceClientFactory.class);
            Method _method = _cls.getMethod("isAvailable", EMPTY_CLASS_ARRAY);
            Boolean _available = (Boolean)_method.invoke((Object)_cls, EMPTY_OBJECT_ARRAY);
            return _available;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public void setProviderId(String aConnectorId, String aEndpointPublicId) {
        this.m_providerIdProperties = new Properties();
        if (aConnectorId == null) {
            throw new DSCRuntimeException(new DSCError(1, "aConnectorId"));
        }
        if (aEndpointPublicId == null) {
            throw new DSCRuntimeException(new DSCError(1, "aEndpointPublicId"));
        }
        this.m_providerIdProperties.put("CONNECTOR_ID", aConnectorId);
        this.m_providerIdProperties.put("ENDPOINT_PUBLIC_ID", aEndpointPublicId);
    }

    static {
        m_throwHandler = DEFAULT_THROW_HANDLER = new ThrowHandler(){

            public boolean handleThrowable(Throwable t, ServiceClient sc, ServiceClientFactory scf, MessageDispatcher md, InvocationRequest ir, int numTries) throws DSCException {
                if (t instanceof DSCException) {
                    throw (DSCException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                IllegalStateException ise = new IllegalStateException();
                ise.initCause(t);
                throw ise;
            }
        };
        try {
            InetAddress _inetAddress = InetAddress.getLocalHost();
            m_hostAddress = _inetAddress.getHostAddress();
        }
        catch (Exception e) {
            throw new DSCRuntimeException(new DSCError(216, " static initializer"));
        }
        EMPTY_CLASS_ARRAY = new Class[0];
        EMPTY_OBJECT_ARRAY = new Object[0];
    }

    public static interface ThrowHandler {
        public boolean handleThrowable(Throwable var1, ServiceClient var2, ServiceClientFactory var3, MessageDispatcher var4, InvocationRequest var5, int var6) throws DSCException;
    }
}

