/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.clientsdk;

import com.adobe.idp.Context;
import com.adobe.idp.dsc.DSCError;
import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.FaultResponse;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactoryProperties;
import com.adobe.idp.dsc.impl.FaultResponseImpl;
import com.adobe.idp.dsc.impl.InvocationResponseImpl;
import com.adobe.idp.dsc.provider.MessageDispatcher;
import com.adobe.idp.jobmanager.common.JobId;
import com.adobe.idp.jobmanager.common.JobStatus;
import com.adobe.logging.AdobeLogger;
import java.util.HashMap;
import java.util.logging.Level;

public final class ServiceClient {
    private ServiceClientFactory m_serviceFactory;
    private static AdobeLogger m_logger = AdobeLogger.getAdobeLogger(ServiceClient.class);

    private ServiceClient() {
    }

    ServiceClient(ServiceClientFactory aClientServiceFactory) {
        this.m_serviceFactory = aClientServiceFactory;
    }

    public InvocationResponse createInvocationReponse(String invocationId) throws DSCException {
        InvocationResponseImpl invocationResponse = new InvocationResponseImpl();
        HashMap<String, JobId> params = new HashMap<String, JobId>();
        params.put("jobId", new JobId(invocationId));
        InvocationRequest request = this.m_serviceFactory.createInvocationRequest("JobManager", "getStatus", params, true);
        InvocationResponse response = this.m_serviceFactory.getServiceClient().invoke(request);
        JobStatus jobStatus = (JobStatus)response.getOutputParameters().get("jobStatus");
        if (3 == jobStatus.getStatusCode()) {
            throw new DSCRuntimeException(new DSCError(320, invocationId));
        }
        invocationResponse.setJobId(invocationId);
        return invocationResponse;
    }

    public FaultResponse createFaultReponse(String invocationId) throws DSCException {
        FaultResponseImpl fault = new FaultResponseImpl();
        fault.setinvocationId(invocationId);
        return fault;
    }

    public void sendFaultReponse(FaultResponse faultResponse) throws DSCException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("jobId", new JobId(faultResponse.getInvocationId()));
        params.put("faultResponse", faultResponse);
        InvocationRequest request = this.m_serviceFactory.createInvocationRequest("JobManager", "faultJob", params, true);
        this.m_serviceFactory.getServiceClient().invoke(request);
    }

    public void sendInvocationResponse(InvocationResponse response) throws DSCException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("jobId", new JobId(response.getInvocationId()));
        params.put("invocationResponse", response);
        InvocationRequest request = this.m_serviceFactory.createInvocationRequest("JobManager", "completeJob", params, true);
        this.m_serviceFactory.getServiceClient().invoke(request);
    }

    public InvocationResponse invoke(InvocationRequest aInvocationRequest) throws DSCException {
        m_logger.entering("ServiceClient", "invoke");
        String _operationName = aInvocationRequest.getOperationName();
        String _serviceName = aInvocationRequest.getServiceName();
        if (_operationName == null) {
            throw new DSCRuntimeException(new DSCError(201));
        }
        if (_operationName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(202));
        }
        if (_serviceName == null) {
            throw new DSCRuntimeException(new DSCError(203));
        }
        if (_serviceName.length() == 0) {
            throw new DSCRuntimeException(new DSCError(204));
        }
        InvocationResponse _response = null;
        MessageDispatcher dispatcher = null;
        boolean tryAgain = false;
        int numTries = 0;
        do {
            try {
                String endpoint = aInvocationRequest.getEndPointURI();
                if (endpoint == null) {
                    aInvocationRequest.setEndPointURI(this.getRequestEndpointURI(aInvocationRequest));
                }
                if (aInvocationRequest.getInvocationContext() == null) {
                    aInvocationRequest.setProperty("DSC_CONTEXT", this.m_serviceFactory.getContext());
                }
                if (this.m_serviceFactory.getCredential() != null) {
                    aInvocationRequest.setProperty("DSC_CREDENTIAL", this.m_serviceFactory.getCredential());
                }
                if (aInvocationRequest.getInvocationContext() != null) {
                    aInvocationRequest.removeProperty("DSC_CREDENTIAL");
                }
                if (m_logger.isLoggable(Level.FINE)) {
                    m_logger.fine("invoking:" + _serviceName + "." + _operationName);
                }
                dispatcher = this.getMessageDispatcher(aInvocationRequest.getEndPointURI());
                tryAgain = false;
                try {
                    _response = dispatcher.send(aInvocationRequest);
                }
                catch (DSCException _ex) {
                    this.m_serviceFactory.evaluateMessageDispatcher(_ex);
                    throw _ex;
                }
                catch (RuntimeException _ex) {
                    this.m_serviceFactory.evaluateMessageDispatcher(_ex);
                    throw _ex;
                }
            }
            catch (Throwable t) {
                ServiceClientFactory.ThrowHandler th = ServiceClientFactory.getThrowHandler();
                tryAgain = th.handleThrowable(t, this, this.m_serviceFactory, dispatcher, aInvocationRequest, ++numTries);
                if (!tryAgain) continue;
                aInvocationRequest = this.m_serviceFactory.createInvocationRequest(_serviceName, _operationName, aInvocationRequest.getInputParameters(), true);
            }
        } while (tryAgain);
        Context _ctx = (Context)_response.getProperty(ServiceClientFactoryProperties.DSC_CONTEXT);
        if (this.m_serviceFactory.getCredential() != null && _ctx != null) {
            this.m_serviceFactory.setCredential(null);
            this.m_serviceFactory.m_context = _ctx;
        }
        m_logger.exiting("ServiceClient", "invoke", _response);
        return _response;
    }

    private MessageDispatcher getMessageDispatcher(String aProviderURL) {
        return this.m_serviceFactory.getMessageDispatcher(aProviderURL);
    }

    private String getRequestEndpointURI(InvocationRequest aRequest) {
        String _protocol = (String)this.m_serviceFactory.getProperty("DSC_TRANSPORT_PROTOCOL");
        if (_protocol == null) {
            return null;
        }
        if (_protocol.equals("SOAP")) {
            return (String)this.m_serviceFactory.getProperty(ServiceClientFactoryProperties.DSC_DEFAULT_SOAP_ENDPOINT);
        }
        if (_protocol.equals("EJB")) {
            return (String)this.m_serviceFactory.getProperty(ServiceClientFactoryProperties.DSC_DEFAULT_EJB_ENDPOINT);
        }
        return null;
    }
}

