/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc;

import com.adobe.idp.dsc.DSCError;
import com.adobe.idp.dsc.ExceptionStackTrace;
import com.adobe.idp.dsc.util.TextUtil;

public class DSCRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -1457671403780291821L;
    private String m_componentUID = "UNDEFINED";
    private DSCError m_error;
    private ExceptionStackTrace m_causeStackTrace;
    static final String nl = System.getProperty("line.separator");

    public DSCRuntimeException(DSCError error) {
        this.m_error = error;
    }

    public DSCRuntimeException(DSCError error, Throwable cause) {
        this.initCause(cause);
        this.m_error = error;
    }

    public DSCRuntimeException(DSCError error, ExceptionStackTrace stackTrace) {
        this.m_causeStackTrace = stackTrace;
        this.m_error = error;
    }

    public DSCRuntimeException(String aMessage) {
        super(aMessage);
    }

    public DSCRuntimeException(Throwable aException, String aMessage) {
        super(aMessage, aException);
    }

    public DSCRuntimeException(Throwable aException) {
        this.initCause(aException);
        this.m_error = new DSCError(0);
    }

    public Throwable getNestedThrowable() {
        return this.getCause();
    }

    public DSCError getError() {
        return this.m_error;
    }

    public String getMessage() {
        String _message = super.getMessage();
        if (_message == null && this.m_error != null) {
            _message = this.m_error.getMessage();
        }
        return _message;
    }

    public String toString() {
        if (this.m_error == null) {
            return super.toString();
        }
        if (this.m_error != null) {
            StringBuffer buf = new StringBuffer("ALC-").append(this.m_error.getComponentUID()).append("-").append(TextUtil.paddingString(Integer.toString(this.m_error.getErrorCode()), 3, '0', true));
            int minorCode = this.m_error.getMinorCode();
            buf.append("-").append(TextUtil.paddingString(Integer.toString(minorCode), 3, '0', true));
            buf.append(": ").append(this.getClass().getName());
            String msg = this.getLocalizedMessage();
            if (msg != null) {
                buf.append(": ").append(msg);
            }
            if (this.m_causeStackTrace != null) {
                buf.append(nl).append("Caused by: ");
                buf.append(this.m_causeStackTrace.getStackTrace());
            }
            return buf.toString();
        }
        Throwable cause = this.getCause();
        return cause == null ? super.toString() : cause.toString();
    }
}

