/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc;

import com.adobe.idp.dsc.DSCError;
import com.adobe.idp.dsc.ExceptionStackTrace;
import com.adobe.idp.dsc.util.TextUtil;
import java.io.Serializable;

public class DSCException
extends Exception
implements Serializable {
    static final long serialVersionUID = -6508295507859068642L;
    private DSCError m_error;
    private String m_causeStackTrace;
    static final String nl = System.getProperty("line.separator");

    public DSCException(DSCError error) {
        this.m_error = error;
    }

    public DSCException(DSCError error, Throwable cause) {
        this.initCause(cause);
        this.m_error = error;
    }

    public DSCException(DSCError error, ExceptionStackTrace stackTrace) {
        this.m_causeStackTrace = stackTrace.getStackTrace();
        this.m_error = error;
    }

    public DSCException(String aMessage) {
        super(aMessage);
    }

    public DSCException(Throwable aException, String aMessage) {
        super(aMessage, aException);
    }

    public DSCException(Throwable aException) {
        super(aException.getMessage(), aException);
    }

    public Throwable getNestedThrowable() {
        return this.getCause();
    }

    public DSCError getError() {
        return this.m_error;
    }

    public String getMessage() {
        String _message = super.getMessage();
        if (_message == null && this.m_error != null) {
            _message = this.m_error.getMessage();
        }
        return _message;
    }

    public String toString() {
        if (this.m_error != null) {
            StringBuffer buf = new StringBuffer("ALC-").append(this.m_error.getComponentUID()).append("-").append(TextUtil.paddingString(Integer.toString(this.m_error.getErrorCode()), 3, '0', true));
            int minorCode = this.m_error.getMinorCode();
            buf.append("-").append(TextUtil.paddingString(Integer.toString(minorCode), 3, '0', true));
            buf.append(": ").append(this.getClass().getName());
            String msg = this.getLocalizedMessage();
            if (msg != null) {
                buf.append(": ").append(msg);
            }
            if (this.m_causeStackTrace != null) {
                buf.append(nl).append("Caused by: ");
                buf.append(this.m_causeStackTrace);
            }
            return buf.toString();
        }
        Throwable cause = this.getCause();
        return cause == null ? super.toString() : cause.toString();
    }

    protected void setCauseStackTrace(String causeStackTrace) {
        this.m_causeStackTrace = causeStackTrace;
    }
}

