/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc;

import com.adobe.idp.dsc.util.MessageUtil;
import com.adobe.idp.dsc.util.TextUtil;
import java.io.Serializable;

public class DSCError
implements Serializable {
    private static final long serialVersionUID = -1392970164283750730L;
    public static final int UNDEFINED_ERROR_CODE = 0;
    public static final String DSC_MSG_BUNDLE = "com.adobe.idp.dsc.i18n.DSCMessage";
    public static final String DSCF_COMPONENT = "DSC";
    private static final transient Object[] EMPTY_ARGS = new Object[0];
    static final int ERRORCODE_PADDING_LENGTH = 3;
    private int m_errorCode;
    private transient ClassLoader m_classLoader;
    private int m_minorCode = 0;
    private transient String m_message;
    private Object[] m_messageParameters;

    public DSCError(int errorCode) {
        this.m_errorCode = errorCode;
        this.m_messageParameters = EMPTY_ARGS;
    }

    public DSCError(int errorCode, int minorCode) {
        this.m_errorCode = errorCode;
        this.m_minorCode = minorCode;
        this.m_messageParameters = EMPTY_ARGS;
    }

    public DSCError(int errorCode, Object[] parameters) {
        this.m_errorCode = errorCode;
        this.m_messageParameters = parameters;
    }

    public DSCError(int errorCode, int minorCode, Object[] parameters) {
        this.m_errorCode = errorCode;
        this.m_minorCode = minorCode;
        this.m_messageParameters = parameters;
    }

    public DSCError(int errorCode, Object arg1) {
        this.m_errorCode = errorCode;
        if (arg1 == null) {
            arg1 = "null";
        }
        Object[] parameters = new Object[]{arg1};
        this.m_messageParameters = parameters;
    }

    public DSCError(int errorCode, int minorCode, Object arg1) {
        this.m_errorCode = errorCode;
        this.m_minorCode = minorCode;
        if (arg1 == null) {
            arg1 = "null";
        }
        Object[] parameters = new Object[]{arg1};
        this.m_messageParameters = parameters;
    }

    public DSCError(int errorCode, Object arg1, Object arg2) {
        this.m_errorCode = errorCode;
        if (arg1 == null) {
            arg1 = "null";
        }
        if (arg2 == null) {
            arg2 = "null";
        }
        Object[] parameters = new Object[]{arg1, arg2};
        this.m_messageParameters = parameters;
    }

    public DSCError(int errorCode, int minorCode, Object arg1, Object arg2) {
        this.m_errorCode = errorCode;
        this.m_minorCode = minorCode;
        if (arg1 == null) {
            arg1 = "null";
        }
        if (arg2 == null) {
            arg2 = "null";
        }
        Object[] parameters = new Object[]{arg1, arg2};
        this.m_messageParameters = parameters;
    }

    public DSCError(int errorCode, Object arg1, Object arg2, Object arg3) {
        this.m_errorCode = errorCode;
        if (arg1 == null) {
            arg1 = "null";
        }
        if (arg2 == null) {
            arg2 = "null";
        }
        if (arg3 == null) {
            arg3 = "null";
        }
        Object[] parameters = new Object[]{arg1, arg2, arg3};
        this.m_messageParameters = parameters;
    }

    public DSCError(int errorCode, int minorCode, Object arg1, Object arg2, Object arg3) {
        this.m_errorCode = errorCode;
        this.m_minorCode = minorCode;
        if (arg1 == null) {
            arg1 = "null";
        }
        if (arg2 == null) {
            arg2 = "null";
        }
        if (arg3 == null) {
            arg3 = "null";
        }
        Object[] parameters = new Object[]{arg1, arg2, arg3};
        this.m_messageParameters = parameters;
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    public int getMinorCode() {
        return this.m_minorCode;
    }

    public String getMessage() {
        if (this.m_message == null) {
            this.m_message = this.getLocalizedMessage();
        }
        return this.m_message;
    }

    public String getLocalizedMessage() {
        ClassLoader _classLoader = this.m_classLoader;
        if (_classLoader == null) {
            _classLoader = this.getClass().getClassLoader();
        }
        return MessageUtil.get(_classLoader, this.getBundle(), this.m_errorCode, this.m_messageParameters);
    }

    public String getComponentUID() {
        return DSCF_COMPONENT;
    }

    protected String getBundle() {
        return DSC_MSG_BUNDLE;
    }

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    public void setClassLoader(ClassLoader aClassLoader) {
        this.m_classLoader = aClassLoader;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ALC-").append(this.getComponentUID()).append("-").append(TextUtil.paddingString(Integer.toString(this.getErrorCode()), 3, '0', true));
        int minorCode = this.getMinorCode();
        buf.append("-").append(TextUtil.paddingString(Integer.toString(minorCode), 3, '0', true));
        String msg = this.getMessage();
        if (msg != null) {
            buf.append(": ").append(msg);
        }
        return buf.toString();
    }
}

