/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp;

import com.adobe.idp.CachedDocumentSync;
import com.adobe.idp.Document;
import com.adobe.idp.DocumentError;
import com.adobe.idp.TransactionBoundDocumentSync;
import com.adobe.util.Platform;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

class TransactionHelper {
    TransactionHelper() {
    }

    public static Transaction getCurrentTransaction() throws SystemException {
        TransactionManager tm = Platform.UTIL.getTransactionManager();
        return tm != null ? tm.getTransaction() : null;
    }

    public static Transaction assertCurrentTransaction() {
        String noTransactionMsg = "The calling thread must be associated with a transaction context.";
        Transaction t = null;
        try {
            t = TransactionHelper.getCurrentTransaction();
        }
        catch (Throwable e) {
            throw new DocumentError(noTransactionMsg, e);
        }
        if (t == null) {
            throw new DocumentError(noTransactionMsg);
        }
        return t;
    }

    public static void registerTransactionBoundDocumentSync(Document doc) {
        try {
            Transaction tx = TransactionHelper.assertCurrentTransaction();
            tx.registerSynchronization((Synchronization)new TransactionBoundDocumentSync(doc));
        }
        catch (Exception e) {
            throw new DocumentError(e);
        }
    }

    public static void registerCachedDocumentSync(Document doc) {
        try {
            Transaction tx = TransactionHelper.getCurrentTransaction();
            if (tx != null) {
                tx.registerSynchronization((Synchronization)new CachedDocumentSync(doc));
            }
        }
        catch (Exception e) {
            throw new DocumentError(e);
        }
    }
}

