/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestCase;

public class RenameTest
extends TestCase {
    public static File dir = new File(System.getProperty("testDir", "testDir"));
    public static AtomicLong fileSuccessCount = new AtomicLong(0L);
    public static AtomicLong renameSuccessCount = new AtomicLong(0L);
    public static AtomicLong dirSuccessCount = new AtomicLong(0L);
    public static AtomicLong attemptCount = new AtomicLong(0L);
    public static AtomicLong dirAttemptCount = new AtomicLong(0L);
    public static Random random = new Random();
    UUID uuid = UUID.randomUUID();
    String uuidString = this.uuid.toString();
    Filter myFileFilter = new Filter();
    public static long n = 2L;

    public RenameTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void xXaaAtestERenameYY() throws IOException {
        int i;
        dir.mkdir();
        File orig = new File(dir, this.uuid.toString());
        orig.mkdir();
        System.out.println("orig: " + orig.getAbsolutePath());
        PlayPingPong[] p = new PlayPingPong[20];
        for (int i2 = 0; i2 < p.length; ++i2) {
            p[i2] = new PlayPingPong();
            p[i2].thread = new Thread(p[i2]);
            p[i2].thread.start();
        }
        try {
            Thread.sleep(120000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (i = 0; i < p.length; ++i) {
            p[i].stop = true;
        }
        for (i = 0; i < p.length; ++i) {
            try {
                p[i].thread.join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("done: " + attemptCount.get() + " " + renameSuccessCount.get() + " " + fileSuccessCount.get());
    }

    public void testDirectoryRename() throws IOException {
        int i;
        dir.mkdir();
        File orig = new File(dir, this.uuid.toString());
        orig.mkdir();
        System.out.println("orig: " + orig.getAbsolutePath());
        PlayDirectoryPingPong[] p = new PlayDirectoryPingPong[2];
        for (int i2 = 0; i2 < p.length; ++i2) {
            p[i2] = i2 == 0 ? new PlayDirectoryPingPong2() : new PlayDirectoryPingPong();
            p[i2].thread = new Thread(p[i2]);
            p[i2].thread.start();
        }
        try {
            Thread.sleep(120000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (i = 0; i < p.length; ++i) {
            p[i].stop = true;
        }
        for (i = 0; i < p.length; ++i) {
            try {
                p[i].thread.join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("done: " + dirAttemptCount.get() + " " + dirSuccessCount.get() + " " + attemptCount.get() + " " + fileSuccessCount.get() + " " + renameSuccessCount.get());
    }

    public class PlayPingPong
    implements Runnable {
        public boolean stop = false;
        public Thread thread = null;

        public void run() {
            while (!this.stop) {
                try {
                    long t = n + n / 2L + random.nextLong() % n;
                    Thread.sleep(t);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                File[] list = dir.listFiles(RenameTest.this.myFileFilter);
                if (list != null && list.length > 0 && list.length < 2) {
                    File f = list[0];
                    String name = f.getName();
                    int i = name.lastIndexOf(46);
                    if (i > 0) {
                        name = name.substring(0, i);
                    }
                    File t = new File(dir, name + "." + UUID.randomUUID().toString() + "-" + Thread.currentThread().getId());
                    attemptCount.getAndAdd(1L);
                    if (!f.renameTo(t)) continue;
                    renameSuccessCount.getAndAdd(1L);
                    try {
                        File out = new File(t, Long.toString(renameSuccessCount.get()));
                        if (out.createNewFile()) {
                            fileSuccessCount.getAndAdd(1L);
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    System.out.println(Thread.currentThread().getId() + " " + f.getName() + " " + t.getName() + " " + t.exists());
                    continue;
                }
                if (list == null || list.length <= 0) continue;
                throw new RuntimeException("list is wrong: " + (list != null ? Integer.valueOf(list.length) : "null"));
            }
        }
    }

    public class PlayDirectoryPingPong2
    extends PlayDirectoryPingPong {
        public boolean flip;

        public PlayDirectoryPingPong2() {
            this.flip = false;
        }

        public void run() {
            File yd = new File(dir, "yd");
            yd.mkdir();
            File target = new File(dir, "yd." + RenameTest.this.uuidString);
            while (!this.stop) {
                try {
                    long n = this.flip ? 2L : 30L;
                    long t = n + n / 2L + random.nextLong() % n;
                    Thread.sleep(t);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                File attemptMark = null;
                long dirAttempt = dirAttemptCount.getAndAdd(1L);
                if (!this.flip) {
                    if (target.exists()) {
                        System.out.println("!!!target pre-exists!");
                    }
                    if (!yd.renameTo(target)) continue;
                    attemptMark = new File(target, "dirAttempt" + Long.toString(dirAttempt));
                } else {
                    if (yd.exists()) {
                        System.out.println("!!!yd pre-exists!");
                    }
                    if (!target.renameTo(yd)) continue;
                    attemptMark = new File(yd, "dirAttempt" + Long.toString(dirAttempt));
                }
                this.flip = !this.flip;
                try {
                    boolean so = attemptMark.createNewFile();
                    if (!so) continue;
                    dirSuccessCount.getAndAdd(1L);
                    attemptMark.delete();
                }
                catch (IOException e) {
                    this.stop = true;
                    e.printStackTrace();
                }
            }
        }
    }

    public class PlayDirectoryPingPong
    implements Runnable {
        public boolean stop = false;
        public Thread thread = null;

        public void run() {
            File xd = new File(dir, "xd");
            xd.mkdir();
            while (!this.stop) {
                long attempt = attemptCount.getAndAdd(1L);
                File f = new File(xd, "attempt" + attempt);
                boolean s = false;
                try {
                    s = f.createNewFile();
                    if (!s) {
                        throw new RuntimeException("No new file!");
                    }
                    fileSuccessCount.getAndIncrement();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                File yd = new File(dir, "yd");
                File target = new File(yd, "attempt" + attempt);
                s = f.renameTo(target);
                if (!s) {
                    System.out.print("!!!renameTo returned False!");
                }
                if (f.exists()) {
                    s = false;
                    System.out.print("!!!original still exists!");
                }
                if (!target.exists()) {
                    s = false;
                    System.out.print("!!!target doesn't exist!");
                }
                if (s) {
                    renameSuccessCount.getAndIncrement();
                    target.delete();
                    continue;
                }
                System.out.println("");
            }
        }
    }

    public class Filter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.startsWith(RenameTest.this.uuidString);
        }
    }
}

