/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp;

import com.adobe.idp.Document;
import com.adobe.idp.DocumentError;
import com.adobe.idp.DocumentFileBackend;
import com.adobe.idp.DocumentFileInitMode;
import java.io.File;
import java.io.IOException;

public class NewTempFileManager {
    DocumentFileBackend backend = null;
    public static NewTempFileManager localTempFileManager = null;
    public static NewTempFileManager globalTempFileManager = null;

    public NewTempFileManager(DocumentFileBackend backend) {
        this.backend = backend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NewTempFileManager global() {
        if (globalTempFileManager != null) return globalTempFileManager;
        Class<NewTempFileManager> clazz = NewTempFileManager.class;
        synchronized (NewTempFileManager.class) {
            globalTempFileManager = new NewTempFileManager(Document.getGlobalBackend());
            // ** MonitorExit[var0] (shouldn't be in output)
            return globalTempFileManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NewTempFileManager local() {
        if (localTempFileManager != null) return localTempFileManager;
        Class<NewTempFileManager> clazz = NewTempFileManager.class;
        synchronized (NewTempFileManager.class) {
            localTempFileManager = new NewTempFileManager(Document.getLocalBackend());
            // ** MonitorExit[var0] (shouldn't be in output)
            return localTempFileManager;
        }
    }

    static NewTempFileManager forBackend(DocumentFileBackend backend) {
        if (NewTempFileManager.local().backend == backend) {
            return NewTempFileManager.local();
        }
        if (NewTempFileManager.global().backend == backend) {
            return NewTempFileManager.global();
        }
        return NewTempFileManager.local();
    }

    public File getTempFile() {
        return this.getTempFile("", "", Document.getDefaultDisposalTimeout());
    }

    public File getTempFile(int expirationTimeout) {
        return this.getTempFile("", "", expirationTimeout);
    }

    public File getTempFile(String prefix, String suffix) {
        return this.getTempFile(prefix, suffix, Document.getDefaultDisposalTimeout());
    }

    public File getTempFile(String prefix, String suffix, int expirationTimeout) {
        File result = null;
        try {
            result = this.backend.createLifetimeMarker(expirationTimeout, prefix, suffix);
        }
        catch (IOException ioe) {
            throw new DocumentError(ioe);
        }
        return result;
    }

    public Document documentFromTempFile(File tempFile) {
        Document doc = new Document(tempFile, DocumentFileInitMode.ADOPT_FILE);
        return doc;
    }
}

