/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp;

import com.adobe.idp.Document;
import com.adobe.idp.DocumentMsgSet;
import com.adobe.idp.DocumentQueue;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeMap;

class DocumentScavenger
extends Thread {
    DocumentScavenger() {
        super("com.adobe.service.DocumentScavenger thread");
        this.setDaemon(true);
        this.start();
    }

    private String thisThread() {
        return "DocumentScavenger thread (" + System.identityHashCode(this) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Document.logger().fine(this.thisThread() + " started");
        DocumentQueue documentQueue = DocumentQueue.instance();
        synchronized (documentQueue) {
            TreeMap queue = DocumentQueue.instance()._queue;
            while (true) {
                try {
                    while (true) {
                        if (queue.size() > 0) {
                            Long first = (Long)queue.firstKey();
                            if (DocumentQueue.currentTimeInSeconds() >= first) {
                                Document.logger().finer(this.thisThread() + " removes Documet(s) from the DocumentQueue expired on: " + new Date(first * 1000L));
                                ArrayList list = (ArrayList)queue.get(first);
                                list = (ArrayList)list.clone();
                                for (int i = 0; i < list.size(); ++i) {
                                    Document doc = (Document)list.get(i);
                                    doc._localBackendId = null;
                                    doc._globalBackendId = null;
                                    doc.dispose();
                                }
                            }
                        }
                        if (queue.size() <= 0) break;
                        Long next = (Long)queue.firstKey();
                        long sec = next - DocumentQueue.currentTimeInSeconds();
                        if (sec <= 0L) continue;
                        Document.logger().finer(this.thisThread() + " sleeps for seconds: " + sec);
                        DocumentQueue.instance().wait(sec * 1000L);
                    }
                    Document.logger().finer(this.thisThread() + " ends since there is no more Documents in the DocumentQueue");
                }
                catch (Throwable e) {
                    Document.logger().log(e, DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (Object)"An exception inside of the DocumentScavenger thread");
                    continue;
                }
                break;
            }
            DocumentQueue._scavengerThread = null;
        }
    }
}

