/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp;

import com.adobe.idp.Document;
import com.adobe.idp.DocumentBackendID;
import com.adobe.idp.DocumentError;
import com.adobe.idp.DocumentManagerClient;
import com.adobe.idp.IDocumentPullServant;
import java.io.IOException;
import java.io.InputStream;

public class DocumentRemoteInputStream
extends InputStream {
    protected DocumentBackendID[] _ids;
    protected IDocumentPullServant _remoteServant;
    protected int _chunkSize;
    protected long _position = 0L;
    protected int _offset = 0;
    protected byte[] _buffer = null;
    protected boolean _lastChunk = false;
    protected boolean _eof = false;
    protected boolean _closed = false;

    public DocumentRemoteInputStream(Document doc, int chunkSize) {
        this._ids = new DocumentBackendID[]{doc._localBackendId, doc._globalBackendId};
        this._remoteServant = doc.getPullServant();
        this._chunkSize = chunkSize;
    }

    public int available() throws IOException {
        if (this._closed) {
            throw new IllegalStateException();
        }
        if (this._buffer == null) {
            return 0;
        }
        return this._buffer.length - this._offset;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this._closed) {
            throw new IllegalStateException();
        }
        if (this._eof) {
            return -1;
        }
        if (this.available() == 0) {
            if (!this._lastChunk) {
                this._buffer = DocumentRemoteInputStream.pullContent(this._remoteServant, this._ids, this._position, this._chunkSize);
            }
            if (this._lastChunk || this._buffer == null || this._buffer.length == 0) {
                this._eof = true;
                this._buffer = null;
                this._remoteServant = null;
                return -1;
            }
            if (this._buffer.length < this._chunkSize) {
                this._lastChunk = true;
            }
            this._position += (long)this._buffer.length;
            this._offset = 0;
        }
        if (len > this.available()) {
            len = this.available();
        }
        System.arraycopy(this._buffer, this._offset, b, off, len);
        this._offset += len;
        return len;
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int len = this.read(buf);
        if (len == -1) {
            return -1;
        }
        return buf[0];
    }

    public void close() throws IOException {
        this._buffer = null;
        this._remoteServant = null;
        this._closed = true;
    }

    static byte[] pullContent(IDocumentPullServant remoteServant, DocumentBackendID[] ids, long position, int size) {
        try {
            byte[] binIds = DocumentManagerClient.objectToByteArray(ids);
            return remoteServant.pullContent(binIds, position, size);
        }
        catch (Exception e) {
            throw new DocumentError(e);
        }
    }
}

