/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp;

import com.adobe.idp.Document;
import com.adobe.idp.DocumentScavenger;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeMap;

class DocumentQueue {
    private static DocumentQueue _instance = new DocumentQueue();
    static DocumentScavenger _scavengerThread;
    TreeMap _queue = new TreeMap();

    public static DocumentQueue instance() {
        return _instance;
    }

    private DocumentQueue() {
    }

    public static long currentTimeInSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public synchronized void add(Document doc) {
        Long expirationTime = new Long(DocumentQueue.currentTimeInSeconds() + (long)doc.getDisposalTimeout());
        Document.logger().finer("Adding a Document (" + System.identityHashCode(doc) + ") into the DocumentQueue with" + " expiration time: " + new Date(expirationTime * 1000L));
        ArrayList<Document> list = (ArrayList<Document>)this._queue.get(expirationTime);
        if (list == null) {
            list = new ArrayList<Document>();
            this._queue.put(expirationTime, list);
        }
        list.add(doc);
        doc._expirationTime = expirationTime;
        this.notify();
        if (_scavengerThread == null) {
            _scavengerThread = new DocumentScavenger();
        }
    }

    public synchronized void remove(Document doc) {
        Document.logger().finer("Removing a Document (" + System.identityHashCode(doc) + ") from the DocumentQueue");
        if (doc._expirationTime != null) {
            ArrayList list = (ArrayList)this._queue.get(doc._expirationTime);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                if (list.get(i) != doc) continue;
                list.remove(i);
                if (size != 1) break;
                this._queue.remove(doc._expirationTime);
                Document.logger().finest("The Document (" + System.identityHashCode(doc) + ") was last one in a DocumentQueue's batch.");
                break;
            }
        }
        this.notify();
    }

    public synchronized void update(Document doc) {
        Document.logger().finer("Updating an expiration time of a Document:" + System.identityHashCode(doc) + " (see the following add/remove traces for details).");
        this.remove(doc);
        doc._expirationTime = new Long(DocumentQueue.currentTimeInSeconds() + (long)doc.getDisposalTimeout());
        this.add(doc);
    }
}

