/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp;

import com.adobe.idp.Document;
import com.adobe.idp.DocumentBackendAttributes;
import com.adobe.idp.DocumentBackendID;
import com.adobe.idp.DocumentFileBackend;
import com.adobe.idp.DocumentFileID;
import com.adobe.idp.DocumentMsgSet;
import com.adobe.idp.DocumentP2PAttributes;
import com.adobe.idp.DocumentPullServant;
import com.adobe.idp.HttpError;
import com.adobe.logging.AdobeLogger;
import com.adobe.util.FileCollector;
import com.adobe.util.FileUtil;
import com.adobe.util.PathToRandomAccessFileMap;
import com.adobe.util.Platform;
import com.adobe.util.Utilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.omg.CORBA.LongHolder;

public class DocumentManagerServlet
extends HttpServlet {
    private static final AdobeLogger logger = AdobeLogger.getAdobeLogger(DocumentManagerServlet.class);
    static final PathToRandomAccessFileMap pathToFileMap = new PathToRandomAccessFileMap();

    public void init() throws ServletException {
        try {
            super.init();
            InitialContext ic = Platform.UTIL.getServerSideContext();
            Document.setInitialContext(ic);
            FileCollector.enable();
        }
        catch (Throwable e) {
            logger.log(e, DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (Object)"Failed to initialize Document Manager");
            throw new ServletException(e);
        }
    }

    private boolean isSubcontextPresent(Context context, String subcontext) throws NamingException {
        NamingEnumeration<NameClassPair> en = context.list("");
        while (en.hasMoreElements()) {
            NameClassPair pair = (NameClassPair)en.nextElement();
            if (!pair.getName().equals(subcontext)) continue;
            return true;
        }
        return false;
    }

    private String getTargetDir(HttpServletRequest req, boolean required) {
        String str = req.getRequestURI();
        int i = str.lastIndexOf("/");
        if (i == -1) {
            if (required) {
                throw new HttpError(400, "target dir is missing");
            }
            return null;
        }
        str = str.substring(0, i);
        i = str.lastIndexOf("/");
        String dir = str.substring(i + 1);
        for (int j = 0; j < dir.length(); ++j) {
            if (Character.isLetterOrDigit(dir.charAt(j))) continue;
            throw new HttpError(400, "target dir is incorrect");
        }
        return dir;
    }

    private String getTargetFile(HttpServletRequest req, boolean required) {
        String target = req.getRequestURI();
        int i = target.lastIndexOf("/");
        if (i == -1) {
            if (required) {
                throw new HttpError(400, "target file is missing");
            }
            return null;
        }
        int dotPos = (target = target.substring(i + 1)).indexOf(".");
        if (dotPos >= 0) {
            target = target.substring(0, dotPos);
        }
        for (int j = 0; j < target.length(); ++j) {
            if (Character.isLetterOrDigit(target.charAt(j))) continue;
            throw new HttpError(400, "target file is incorrect");
        }
        return target;
    }

    private long getLongParam(HttpServletRequest req, String param, long def) {
        String value = req.getParameter(param);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new HttpError(400, param + " is incorrect");
            }
        }
        return def;
    }

    private int getIntParam(HttpServletRequest req, String param, int def) {
        String value = req.getParameter(param);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new HttpError(400, param + " is incorrect");
            }
        }
        return def;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block12: {
            try {
                long position = this.getLongParam(req, "pos", 0L);
                String dir = this.getTargetDir(req, true);
                String target = this.getTargetFile(req, true);
                String path = dir + "/" + target;
                File file = new File(Document.getGlobalBackend()._rootDir, path);
                int size = this.getIntParam(req, "size", -1);
                String type = req.getParameter("type");
                if (type != null) {
                    type = Utilities.decodeString((String)type);
                    res.setContentType(type);
                }
                DocumentFileBackend.checkFileExistance(file);
                ServletOutputStream os = res.getOutputStream();
                if (size >= 0) {
                    if (size > FileUtil.FILE_BLOCK_SIZE) {
                        size = FileUtil.FILE_BLOCK_SIZE;
                    }
                    byte[] buf = FileUtil.randomAccessRead(file, position, size, pathToFileMap);
                    os.write(buf);
                    break block12;
                }
                FileInputStream is = new FileInputStream(file);
                FileCollector.debugReportFileChange((File)file, (String)"inputStreamFileRead");
                try {
                    byte[] buf = new byte[FileUtil.FILE_BLOCK_SIZE];
                    while (true) {
                        int len;
                        if ((len = ((InputStream)is).read(buf)) == -1) {
                            return;
                        }
                        os.write(buf, 0, len);
                    }
                }
                finally {
                    FileCollector.debugReportFileChange((File)file, (String)"inputStreamFileClose");
                    ((InputStream)is).close();
                }
            }
            catch (HttpError e) {
                res.sendError(e.getErrorCode(), e.getMessage());
            }
            catch (Throwable e) {
                logger.log(e, DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (Object)"See the stack trace for details");
                res.sendError(500, e.getMessage());
            }
        }
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Document doc = null;
        long startTime = System.currentTimeMillis();
        try {
            int timeout = this.getIntParam(req, "timeout", Document.getDefaultDisposalTimeout());
            ServletInputStream is = req.getInputStream();
            doc = new Document((InputStream)is);
            doc.setDisposalTimeout(timeout);
            doc.setMaxInlineSize(0);
            doc.passivateGlobally();
            ObjectOutputStream out = new ObjectOutputStream((OutputStream)res.getOutputStream());
            out.writeObject(doc);
            out.close();
        }
        catch (HttpError e) {
            res.sendError(e.getErrorCode(), e.getMessage());
        }
        catch (Throwable e) {
            logger.log(e, DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (Object)("during upload which started at " + new SimpleDateFormat().format(new Date(startTime)) + "... See the stack trace for details"));
            res.sendError(500, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            DocumentP2PAttributes attr;
            String dir = this.getTargetDir(req, true);
            String target = this.getTargetFile(req, true);
            String file = dir + "/" + target;
            String timeout = req.getHeader("timeout");
            if (timeout == null) {
                attr = new DocumentP2PAttributes(Document.getDefaultDisposalTimeout());
            } else {
                try {
                    attr = new DocumentP2PAttributes(Long.parseLong(timeout));
                }
                catch (NumberFormatException e) {
                    throw new HttpError(400, "timeout parameter is incorrect");
                }
            }
            DocumentFileID id = new DocumentFileID(Document.getGlobalBackend(), file, attr);
            LongHolder length = new LongHolder();
            DocumentBackendID newId = DocumentPullServant.renewGlobalContent((DocumentBackendID)id, (DocumentBackendAttributes)attr, (LongHolder)length);
            ServletOutputStream os = res.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)os);
            try {
                oos.writeInt(1);
                oos.writeObject(newId);
                oos.writeLong(length.value);
            }
            finally {
                oos.close();
            }
        }
        catch (HttpError e) {
            res.sendError(e.getErrorCode(), e.getMessage());
        }
        catch (Throwable e) {
            logger.log(e, DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (Object)"See the stack trace for details");
            res.sendError(500, e.getMessage());
        }
    }
}

