/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp;

import com.adobe.idp.DocumentBackendAttributes;
import com.adobe.idp.DocumentBackendID;
import com.adobe.idp.DocumentBackendProvider;
import com.adobe.idp.DocumentFileBackend;
import com.adobe.util.FileUtil;
import java.io.File;

public class DocumentFileID
implements DocumentBackendID {
    static final long serialVersionUID = -5780550483767943515L;
    transient DocumentFileBackend _backend;
    private String _fileName;

    public DocumentFileID(DocumentFileBackend backend, String fileName, DocumentBackendAttributes attr) {
        this._backend = backend;
        String prefix = DocumentFileID.getPrefixDir(backend, attr);
        this._fileName = prefix + "/../" + fileName;
    }

    static String getPrefixDir(DocumentFileBackend backend, DocumentBackendAttributes attr) {
        return attr.getSessionId() != null ? "session" + attr.getSessionId() : "removeOn." + backend.toEpocTime(attr.getExpiration());
    }

    public void setBackend(DocumentBackendProvider backend) {
        this._backend = (DocumentFileBackend)backend;
    }

    public DocumentBackendProvider getBackend() {
        return this._backend;
    }

    public String getFileName() {
        return new File(this._backend._rootDir, this.getRelativePath()).getPath();
    }

    public File getFile() {
        return new File(this._backend._rootDir, this.getRelativePath());
    }

    public long length() {
        return this.getFile().length();
    }

    public static String getRelativePath(String fileName) {
        int i = fileName.lastIndexOf("/");
        i = (i = fileName.lastIndexOf("/", i - 1)) < 0 ? 0 : i + 1;
        return fileName.substring(i);
    }

    public String getRelativePath() {
        return DocumentFileID.getRelativePath(this._fileName);
    }

    public String getMarkerSuffix() {
        if (this._fileName.startsWith("session")) {
            String sessionId = this._fileName.substring("session".length(), this._fileName.indexOf("/"));
            return ".session" + sessionId;
        }
        if (this._fileName.startsWith("removeOn")) {
            String expiration = this._fileName.substring(this._fileName.indexOf(".") + 1, this._fileName.indexOf("/"));
            return FileUtil.timeToExpPostfix(Long.parseLong(expiration));
        }
        return null;
    }

    public DocumentBackendAttributes getAttr() {
        if (this._fileName.startsWith("session")) {
            String sessionId = this._fileName.substring("session".length(), this._fileName.indexOf("/"));
            return new DocumentBackendAttributes(sessionId);
        }
        if (this._fileName.startsWith("removeOn")) {
            String expiration = this._fileName.substring(this._fileName.indexOf(".") + 1, this._fileName.indexOf("/"));
            return new DocumentBackendAttributes(Long.parseLong(expiration) / 1000L);
        }
        return null;
    }

    public String toString() {
        if (this._backend == null) {
            return "<DocumentFileID remoteFileName=\"" + this._fileName + "\"/>";
        }
        return "<DocumentFileID fileName=\"" + this.getFileName() + "\"/>";
    }
}

