/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp;

import com.adobe.idp.Document;
import com.adobe.idp.DocumentBackendAttributes;
import com.adobe.idp.DocumentBackendID;
import com.adobe.idp.DocumentBackendProvider;
import com.adobe.idp.DocumentError;
import com.adobe.idp.DocumentFileID;
import com.adobe.idp.DocumentMsgSet;
import com.adobe.idp.DocumentQueue;
import com.adobe.idp.NewTempFileManager;
import com.adobe.util.BackupUtil;
import com.adobe.util.FileCollector;
import com.adobe.util.FileUtil;
import com.adobe.util.Platform;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;

class DocumentFileBackend
implements DocumentBackendProvider {
    private static Comparator pathLengthComparator = new PathLengthComparator();
    protected File _rootDir;
    private boolean _adjustTimeSkew;
    long _timeSkewDelta = Long.MAX_VALUE;
    private boolean _useContentCollector = true;
    private static TreeSet backEndRoots = new TreeSet(pathLengthComparator);
    private Long _currentDirTime = Long.MIN_VALUE;
    private int _currentDirFileCounter = 0;
    private static int _dumpStackTraceFlag = -1;
    static final String DEBUG_TRACES_SESSION = "DocManagerDebugTrace";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentFileBackend(String rootDir, boolean adjustTimeSkew) {
        try {
            this._rootDir = new File(rootDir).getCanonicalFile();
            TreeSet treeSet = backEndRoots;
            synchronized (treeSet) {
                backEndRoots.add(this._rootDir.getPath());
            }
        }
        catch (IOException e) {
            throw new DocumentError(e);
        }
        this._adjustTimeSkew = adjustTimeSkew;
        try {
            FileCollector.addRootDir((File)this._rootDir, (long)this.getTimeSkewDelta());
        }
        catch (NoClassDefFoundError e) {
            this._useContentCollector = false;
        }
    }

    private void checkCollectorThread() {
        if (this._useContentCollector) {
            FileCollector.checkCollectorThread();
        }
    }

    private long getTimeSkewDelta() {
        if (!this._adjustTimeSkew) {
            return 0L;
        }
        if (this._timeSkewDelta == Long.MAX_VALUE) {
            try {
                if (!(this._rootDir.exists() || this.mkdirs(this._rootDir) || this._rootDir.exists())) {
                    String msg = "Failed to create directory: " + this._rootDir;
                    Document.logger().log(DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (Object)msg);
                    throw new DocumentError(msg);
                }
                File file = this.createTempFile("tmp", ".tmp", this._rootDir);
                FileWriter fw = new FileWriter(file);
                fw.write("anything");
                fw.close();
                long fileServerTime = file.lastModified();
                this._timeSkewDelta = System.currentTimeMillis() - fileServerTime;
                if (this._timeSkewDelta < 1000L && this._timeSkewDelta > -1000L) {
                    this._timeSkewDelta = 0L;
                }
                FileCollector.clientDelete((File)file);
                Document.logger().finer("The time skew between the local machine and the file system is (ms):" + this._timeSkewDelta);
            }
            catch (IOException e) {
                Document.logger().log(DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, e);
                throw new DocumentError(e);
            }
        }
        return this._timeSkewDelta;
    }

    private File createTempFile(String string, String string2, File dir) throws IOException {
        File f = File.createTempFile(string, string2, dir);
        FileCollector.debugReportFileChange((File)f, (String)"create");
        return f;
    }

    private boolean mkdirs(File dir) {
        FileCollector.debugReportFileChange((File)dir, (String)"mkdirs");
        boolean result = dir.mkdirs();
        return result;
    }

    public long toEpocTime(long expirationInSeconds) {
        return expirationInSeconds * 1000L - this.getTimeSkewDelta();
    }

    File createLifetimeMarker(long disposalTimeout, String prefix, String suffix) throws IOException {
        File file = null;
        File marker = null;
        int attempts = 0;
        while (true) {
            long dirTime = this.mkdocmDir();
            String dir = FileUtil.timeToDirName(dirTime);
            String name = FileUtil.getRandomFileNameBase36(1);
            if (prefix != null || suffix != null) {
                name = prefix + name + suffix;
            }
            file = new File(this._rootDir, dir + "/" + name);
            long time = System.currentTimeMillis() - this.getTimeSkewDelta();
            long expirationTime = time + disposalTimeout * 1000L;
            long tdelta = expirationTime - dirTime;
            if (tdelta > 2147483647000L) {
                tdelta = 2147483647000L;
            } else if (tdelta < 0L) {
                tdelta = 0L;
            }
            marker = FileCollector.getShortLifeTimeMarker((File)file, (int)((int)(tdelta / 1000L)));
            try {
                if (!this.createNewFile(marker)) continue;
            }
            catch (IOException e) {
                if (++attempts > 10) {
                    Document.logger().log(DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, e);
                    throw new DocumentError(e);
                }
                this._currentDirTime = Long.MIN_VALUE;
                continue;
            }
            break;
        }
        return marker;
    }

    static long expirationFromShortMarker(File marker) {
        String name = marker.getName();
        char f = name.charAt(0);
        if (f >= 'g' || f <= 'z' && name.length() == 32) {
            char key = name.charAt(name.length() - 7);
            if (key == '0') {
                String expirationString = name.substring(name.length() - 6);
                try {
                    int expirationInt = Integer.parseInt(expirationString, 36);
                    float expirationFloat = Float.intBitsToFloat(expirationInt);
                    return (long)expirationFloat;
                }
                catch (NumberFormatException nfe) {
                    return -1L;
                }
            }
            return -1L;
        }
        return -1L;
    }

    File getLifeTimeMarker(File file, DocumentBackendAttributes attr) {
        if (attr.getSessionId() == null) {
            long time = this.toEpocTime(attr.getExpiration());
            return new File(file + FileUtil.timeToExpPostfix(time));
        }
        return new File(file + ".session" + attr.getSessionId());
    }

    private void createLifeTimeMarker(File file, DocumentBackendAttributes attr) throws IOException {
        File marker;
        this.checkCollectorThread();
        while (!this.createNewFile(marker = this.getLifeTimeMarker(file, attr)) && attr.getSessionId() == null) {
            ++attr._expiration;
        }
        if (Platform.UTIL.isLC7CompatibilityEnabled()) {
            File prefixDir = new File(this._rootDir, DocumentFileID.getPrefixDir(this, attr));
            this.mkdir(prefixDir);
        }
        this.dumpStackTrace(marker, true);
    }

    private void mkdir(File prefixDir) {
        FileCollector.debugReportFileChange((File)prefixDir, (String)"mkdir");
        prefixDir.mkdir();
    }

    private void setLastModified(File marker, long time) {
        FileCollector.debugReportFileChange((File)marker, (String)("setLastModified-" + time));
        marker.setLastModified(time);
    }

    private boolean createNewFile(File marker) throws IOException {
        FileCollector.debugReportFileChange((File)marker, (String)"create");
        boolean result = marker.createNewFile();
        return result;
    }

    public DocumentFileID createManagedFile(DocumentBackendAttributes attr) {
        return this.createManagedFile(attr, "", "");
    }

    private long mkdocmDir() {
        long time = this._currentDirTime;
        if (time == Long.MIN_VALUE || this._currentDirFileCounter > 500) {
            this._currentDirFileCounter = 0;
            time = System.currentTimeMillis() - this.getTimeSkewDelta();
            String dir = FileUtil.timeToDirName(time);
            File newDir = new File(this._rootDir, dir);
            if (!(newDir.exists() || this.mkdirs(newDir) || newDir.exists())) {
                String msg = "Failed to create directory: " + newDir;
                Document.logger().log(DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (Object)msg);
                throw new DocumentError(msg);
            }
            this._currentDirTime = time;
        }
        return time;
    }

    public DocumentFileID createManagedFile(DocumentBackendAttributes attr, String prefix, String suffix) {
        String name;
        String dir;
        this.checkCollectorThread();
        int attempts = 0;
        while (true) {
            long time = this.mkdocmDir();
            dir = FileUtil.timeToDirName(time);
            name = prefix + FileUtil.getRandomFileName() + suffix;
            File file = new File(this._rootDir, dir + "/" + name);
            try {
                this.createLifeTimeMarker(file, attr);
                if (!this.createNewFile(file)) continue;
            }
            catch (IOException e) {
                if (++attempts > 10) {
                    Document.logger().log(DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, e);
                    throw new DocumentError(e);
                }
                this._currentDirTime = Long.MIN_VALUE;
                continue;
            }
            break;
        }
        ++this._currentDirFileCounter;
        return new DocumentFileID(this, dir + "/" + name, attr);
    }

    public DocumentBackendID write(InputStream is, DocumentBackendAttributes attr) {
        DocumentFileID id = this.createManagedFile(attr);
        File file = id.getFile();
        DocumentFileBackend.saveStreamToFile(is, file);
        return id;
    }

    public static void saveStreamToFile(InputStream is, File file) {
        boolean haveNotClosedInput = true;
        boolean haveNotClosedOutput = true;
        OutputStream fos = null;
        try {
            int len;
            Document.logger().finer("Saving data in file: " + file);
            fos = new BufferedOutputStream(new FileOutputStream(file, false), FileUtil.FILE_BLOCK_SIZE);
            byte[] buf = new byte[FileUtil.FILE_BLOCK_SIZE];
            while ((len = is.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
            haveNotClosedOutput = false;
            fos.close();
            haveNotClosedInput = false;
            is.close();
            return;
        }
        catch (Throwable e) {
            try {
                if (fos != null && haveNotClosedOutput) {
                    fos.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                if (haveNotClosedInput) {
                    is.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            Document.logger().log(e, DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (Object)("while saving " + file));
            FileCollector.debugReportFileChange((File)file, (String)"exception");
            throw new DocumentError(e);
        }
    }

    static void checkFileExistance(File file) {
        if (!file.exists()) {
            throw new DocumentError("The document pointing to the file \"" + file + "\" has expired. Consider increasing the document disposal timeout.");
        }
    }

    public DocumentBackendID copy(DocumentBackendID id, DocumentBackendAttributes attr) {
        File file = ((DocumentFileID)id).getFile();
        DocumentFileBackend.checkFileExistance(file);
        return this.linkFromFile(file, attr);
    }

    public DocumentBackendID linkFromFile(File file, DocumentBackendAttributes attr) {
        String path;
        String pathRoot = null;
        try {
            File canontParentParent;
            File canonFile = file.getCanonicalFile();
            path = canonFile.toString();
            File canonParent = canonFile.getParentFile();
            if (canonParent != null && (canontParentParent = canonParent.getParentFile()) != null) {
                pathRoot = canontParentParent.toString();
            }
        }
        catch (IOException e) {
            throw new DocumentError(e);
        }
        String root = this._rootDir.toString();
        if (pathRoot != null && pathRoot.equals(root)) {
            try {
                this.createLifeTimeMarker(file, attr);
            }
            catch (IOException e) {
                throw new DocumentError(e);
            }
            String name = path.substring(root.length() + 1).replace('\\', '/');
            return new DocumentFileID(this, name, attr);
        }
        return this.copyFromFile(file, attr);
    }

    DocumentBackendID copyToShortMarker(File file, DocumentBackendAttributes attr) {
        NewTempFileManager tfm = NewTempFileManager.forBackend(this);
        File t = tfm.getTempFile((int)(attr.getExpiration() - DocumentQueue.currentTimeInSeconds()));
        try {
            FileUtil.copy(file, t);
        }
        catch (IOException e) {
            throw new DocumentError(e);
        }
        DocumentFileID result = new DocumentFileID(this, DocumentFileID.getRelativePath(t.getAbsolutePath().replace('\\', '/')), attr);
        return result;
    }

    public DocumentBackendID copyFromFile(File file, DocumentBackendAttributes attr) {
        DocumentFileID result = this.createManagedFile(attr);
        File toFile = result.getFile();
        try {
            FileUtil.copy(file, toFile);
        }
        catch (IOException e) {
            throw new DocumentError(e);
        }
        return result;
    }

    public DocumentBackendID adoptFromFile(File file, DocumentBackendAttributes attr) {
        long expiration = FileCollector.expirationFromShortMarker((File)file) / 1000L;
        if (attr._sessionId != null) {
            throw new DocumentError("File adoption cannot be used with sessions.");
        }
        String rootPath = this._rootDir.getPath();
        String fileRootPath = null;
        if (expiration != -1L) {
            fileRootPath = DocumentFileBackend.getFileRootPath(file);
        }
        if (!rootPath.equals(fileRootPath) || expiration == -1L) {
            return this.moveFromFile(file, attr);
        }
        attr._expiration = expiration;
        try {
            this.createLifeTimeMarker(file, attr);
        }
        catch (IOException e) {
            throw new DocumentError(e);
        }
        this.createDeletionMarker(file);
        DocumentFileID result = new DocumentFileID(this, DocumentFileID.getRelativePath(file.getAbsolutePath().replace('\\', '/')), attr);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileRootPath(File file) {
        String path = file.getAbsolutePath();
        TreeSet treeSet = backEndRoots;
        synchronized (treeSet) {
            for (String rootPath : backEndRoots) {
                if (!path.startsWith(rootPath)) continue;
                String tail = path.substring(rootPath.length());
                if (!rootPath.endsWith("/") && !rootPath.endsWith("\\") && !tail.startsWith("/") && !tail.startsWith("\\")) continue;
                return rootPath;
            }
        }
        return null;
    }

    public DocumentBackendID moveFromFile(File file, DocumentBackendAttributes attr) {
        DocumentFileID result = this.createManagedFile(attr);
        try {
            FileUtil.move(file, result.getFile());
        }
        catch (IOException e) {
            throw new DocumentError(e);
        }
        return result;
    }

    public InputStream read(DocumentBackendID id) {
        File file = this.getFile(id);
        try {
            Document.logger().finer("Reading data from file: " + file);
            return new FileInputStream(file);
        }
        catch (Throwable e) {
            throw new DocumentError(e);
        }
    }

    public File getFile(DocumentBackendID id) {
        File result = new File(((DocumentFileID)id).getFileName());
        DocumentFileBackend.checkFileExistance(result);
        return result;
    }

    public void copyToFile(DocumentBackendID id, File file) {
        File fromFile = ((DocumentFileID)id).getFile();
        DocumentFileBackend.checkFileExistance(fromFile);
        try {
            FileUtil.copy(fromFile, file);
        }
        catch (IOException e) {
            throw new DocumentError(e);
        }
    }

    public void removeAll(String sessionId) {
        if (BackupUtil.isBackupRoot((File)this._rootDir) && !FileCollector.isInvocationSession((String)sessionId)) {
            try {
                BackupUtil.queueDeletion((String)(FileUtil.sessionToDirName(sessionId) + ".remove"));
                this.checkCollectorThread();
            }
            catch (IOException e) {
                FileCollector.debugReportFileChange(null, (String)"exception");
                String msg = "Failed to mark the session \"" + sessionId + "\" for removal due to an exception caught.";
                Document.logger().log((Throwable)e, DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (Object)msg);
                throw new DocumentError(msg, e);
            }
        }
        File dir = new File(this._rootDir, FileUtil.sessionToDirName(sessionId));
        try {
            File removeFile = new File(dir.toString() + ".del");
            this.createNewFile(removeFile);
            this.checkCollectorThread();
        }
        catch (IOException e) {
            FileCollector.debugReportFileChange((File)dir, (String)"exception");
            String msg = "Failed to mark the directory \"" + dir + "\" for removal due to an exception caught.";
            Document.logger().log((Throwable)e, DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (Object)msg);
            throw new DocumentError(msg, e);
        }
    }

    void createDeletionMarker(File file) {
        File delMarker = new File(file.getParent(), file.getName() + ".del");
        IOException ioe = null;
        int i = 0;
        if (i < 10) {
            try {
                ioe = null;
                delMarker.createNewFile();
            }
            catch (IOException e) {
                ioe = e;
            }
        }
        if (ioe != null) {
            throw new DocumentError(ioe);
        }
    }

    public void remove(DocumentBackendID id) {
        File file = ((DocumentFileID)id).getFile();
        String markerSuffix = ((DocumentFileID)id).getMarkerSuffix();
        File marker = new File(file + markerSuffix);
        this.dumpStackTrace(file, null, false);
        if (markerSuffix.startsWith(".expiresOn") || !BackupUtil.isBackupRoot((File)this._rootDir)) {
            FileCollector.clientDelete((File)marker);
        } else {
            try {
                BackupUtil.queueDeletion((String)(marker.getParentFile().getName() + File.separator + marker.getName()));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private void dumpStackTrace(File marker, boolean create) {
        String markerSuffix = null;
        int suffix = marker.getName().indexOf(".expiresOn");
        if (suffix >= 0) {
            markerSuffix = marker.getName().substring(suffix);
        } else {
            suffix = marker.getName().indexOf(".session");
            markerSuffix = marker.getName().substring(suffix);
        }
        this.dumpStackTrace(marker, markerSuffix, create);
    }

    private void dumpStackTrace(File file, String markerSuffix, boolean create) {
        if (_dumpStackTraceFlag == -1) {
            String val = System.getProperty("com.adobe.idp.dumpDocumentStackTraces", "false");
            int n = _dumpStackTraceFlag = val.equalsIgnoreCase("false") ? 0 : 1;
        }
        if (_dumpStackTraceFlag == 0) {
            return;
        }
        String operation = create ? ".create" : ".delete";
        try {
            throw new Error();
        }
        catch (Error stackTraceError) {
            String traceName;
            String header = null;
            if (markerSuffix != null && markerSuffix.startsWith(".expiresOn")) {
                String timeString = markerSuffix.substring(".expiresOn".length());
                long time = Long.parseLong(timeString);
                traceName = "ExpirationMarker" + time;
                header = "Expires On: " + new Date(time).toString();
            } else {
                traceName = markerSuffix != null && markerSuffix.startsWith(".session") ? "SessionMarker" + markerSuffix.substring(".session".length()) : "unknown";
            }
            File traceFile = new File(file.toString() + operation + traceName);
            try {
                PrintStream ps = new PrintStream(traceFile);
                if (header != null) {
                    ps.println(header);
                }
                stackTraceError.printStackTrace(ps);
                File traceMarkerFile = new File(traceFile + ".session" + DEBUG_TRACES_SESSION);
                traceMarkerFile.createNewFile();
                ps.close();
            }
            catch (IOException e1) {
                throw new DocumentError(e1);
            }
            return;
        }
    }

    private static class PathLengthComparator
    implements Comparator {
        private PathLengthComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = null;
            String s2 = null;
            s1 = o1 instanceof String ? (String)o1 : "";
            s2 = o2 instanceof String ? (String)o2 : "";
            return s2.length() - s1.length();
        }
    }
}

