/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp;

import com.adobe.idp.ByteArrayHolder;
import com.adobe.idp.Document;
import com.adobe.idp.DocumentBackendAttributes;
import com.adobe.idp.DocumentBackendID;
import com.adobe.idp.DocumentError;
import com.adobe.idp.DocumentManagerClient;
import com.adobe.idp.DocumentMsgSet;
import com.adobe.idp.IDocumentCallbackPOATie;
import com.adobe.idp.NoSuchDocument;
import com.adobe.idp.RemoteFailure;
import com.adobe.idp.RemotePassivationResult;
import com.adobe.idp._IDocumentCallbackImplBase;
import com.adobe.util.Platform;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.omg.CORBA.LongHolder;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;

public class DocumentCallback
extends _IDocumentCallbackImplBase {
    protected static String _ior = null;
    protected static Object _instance = null;
    private static Map _documentTable = new HashMap();
    private static int _currentKey = 0;
    static POA _rootPOA = null;
    private static ORB _orb = null;

    static synchronized Object instance() {
        if (_instance == null) {
            ORB orb = DocumentCallback.getORB();
            DocumentCallback instance = new DocumentCallback();
            try {
                orb.connect((Object)instance);
                _instance = orb.string_to_object(orb.object_to_string((Object)instance));
            }
            catch (NO_IMPLEMENT e) {
                try {
                    IDocumentCallbackPOATie servant = new IDocumentCallbackPOATie(instance);
                    if (_rootPOA == null) {
                        _rootPOA = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
                        _rootPOA.the_POAManager().activate();
                    }
                    _rootPOA.activate_object((Servant)servant);
                    _instance = servant._this();
                }
                catch (Throwable t) {
                    Document.logger().log(t, DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (java.lang.Object)"Failed to register the Document Callback object.");
                    throw new DocumentError(t);
                }
            }
        }
        return _instance;
    }

    static synchronized String ior() {
        if (_ior == null) {
            ORB orb = DocumentCallback.getORB();
            _ior = orb.object_to_string(DocumentCallback.instance());
            Document.logger().finer("The callback object: " + _ior);
        }
        return _ior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document findDocument(int documentId) throws NoSuchDocument {
        Map map = _documentTable;
        synchronized (map) {
            Document doc;
            WeakReference wr = (WeakReference)_documentTable.get(new Integer(documentId));
            Document document = doc = wr != null ? (Document)wr.get() : null;
            if (wr == null || doc == null) {
                throw new NoSuchDocument("The Document is not available on the sending side anymore. Make sure that it is not disposed or garbage collected too early.");
            }
            return doc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemotePassivationResult handleRemotePassivation(int documentId, boolean isGlobal, byte[] documentBackendAttributes, ByteArrayHolder data) throws NoSuchDocument, RemoteFailure {
        Document doc = DocumentCallback.findDocument(documentId);
        if (Document.logger().isLoggable(Level.FINER)) {
            Document.logger().finer("Received a remote passivation request for Document: " + doc);
        }
        try {
            Document document = doc;
            synchronized (document) {
                RemotePassivationResult result;
                DocumentBackendID id;
                DocumentBackendAttributes attr = (DocumentBackendAttributes)DocumentManagerClient.byteArrayToObject(documentBackendAttributes);
                if (doc._passivated) {
                    if (doc._inline == null && isGlobal && doc._globalBackendId == null) {
                        doc.globalize();
                    }
                } else {
                    doc.passivate(isGlobal, doc.getBackendAttr());
                }
                if (doc._inline != null) {
                    data.value = doc._inline;
                    return RemotePassivationResult.INLINE;
                }
                if (!isGlobal && doc._localBackendId != null) {
                    id = Document.getLocalBackend().copy(doc._localBackendId, attr);
                    result = RemotePassivationResult.LOCAL_ID;
                } else {
                    id = Document.getGlobalBackend().copy(doc._globalBackendId, attr);
                    result = RemotePassivationResult.GLOBAL_ID;
                }
                data.value = DocumentManagerClient.objectToByteArray(id);
                return result;
            }
        }
        catch (Throwable e) {
            Document.logger().log(e, DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (java.lang.Object)"An exception while handling a remote request");
            throw new RemoteFailure(e.getMessage());
        }
    }

    public RemotePassivationResult handleRemotePassivation2(int documentId, boolean isGlobal, byte[] documentBackendAttributes, ByteArrayHolder data, StringHolder pullServantJndiName, LongHolder length, StringHolder contentType) throws NoSuchDocument, RemoteFailure {
        isGlobal = true;
        RemotePassivationResult result = this.handleRemotePassivation(documentId, isGlobal, documentBackendAttributes, data);
        try {
            Document doc = DocumentCallback.findDocument(documentId);
            pullServantJndiName.value = doc.getPullServantJndiName();
            if (result == RemotePassivationResult.INLINE) {
                length.value = data.value.length;
            } else {
                DocumentBackendID id = (DocumentBackendID)DocumentManagerClient.byteArrayToObject(data.value);
                if (result == RemotePassivationResult.GLOBAL_ID) {
                    id.setBackend(Document.getGlobalBackend());
                } else {
                    id.setBackend(Document.getLocalBackend());
                }
                length.value = id.length();
            }
            String type = doc.getContentType();
            contentType.value = type != null ? type : "";
        }
        catch (Throwable e) {
            Document.logger().log(e, DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (java.lang.Object)"An exception while handling a remote request");
            throw new RemoteFailure(e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int register(Document doc) {
        Map map = _documentTable;
        synchronized (map) {
            _currentKey = _currentKey == Integer.MAX_VALUE ? 1 : _currentKey + 1;
            _documentTable.put(new Integer(_currentKey), new WeakReference<Document>(doc));
            return _currentKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregister(int documentId) {
        Map map = _documentTable;
        synchronized (map) {
            _documentTable.remove(new Integer(documentId));
        }
    }

    static ORB getORB() {
        if (_orb != null) {
            return _orb;
        }
        try {
            _orb = Platform.UTIL.getOrb();
        }
        catch (Throwable t) {
            Document.logger().finer("Failed to resolve a platform ORB");
        }
        if (_orb == null) {
            Properties props = new Properties();
            _orb = ORB.init((String[])new String[0], (Properties)props);
        }
        Document.logger().finer("The ORB for callback objects: " + _orb.getClass());
        return _orb;
    }
}

