/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp;

import com.adobe.idp.Document;
import com.adobe.idp.DocumentCacheData;
import com.adobe.idp.DocumentMsgSet;
import com.adobe.idp.DocumentWriterEx;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

class DocumentCacheID
implements Serializable {
    private static Map _cache = new HashMap();
    private static int _currentDocumentId = 0;
    private static long _currentCacheId = System.currentTimeMillis() % 0x40000000L * (long)System.identityHashCode(_cache);
    private int _documentId;
    private long _cacheId;

    DocumentCacheID(long cacheId, int documentId) {
        this._cacheId = cacheId;
        this._documentId = documentId;
    }

    static synchronized DocumentCacheID register(DocumentCacheData data) {
        _currentDocumentId = _currentDocumentId == Integer.MAX_VALUE ? 1 : _currentDocumentId + 1;
        _cache.put(new Integer(_currentDocumentId), data);
        Document.logger().finer("Added a Document into the cache (" + _currentCacheId + ") with cacheId: " + _currentDocumentId);
        return new DocumentCacheID(_currentCacheId, _currentDocumentId);
    }

    static synchronized void unregister(DocumentCacheID id) {
        if (id._cacheId != _currentCacheId) {
            return;
        }
        Document.logger().finer("Removed a Document from the cache (" + _currentCacheId + ") with cacheId: " + id._documentId);
        DocumentCacheData data = (DocumentCacheData)_cache.remove(new Integer(id._documentId));
        if (data != null && data.docWriter instanceof DocumentWriterEx) {
            try {
                ((DocumentWriterEx)data.docWriter).onDisconnect(data.cachedObj);
            }
            catch (Throwable e) {
                Document.logger().log(e, DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (Object)("Custom DocumentWriterEx.onDisconnect() throws: " + e));
            }
        }
    }

    static synchronized DocumentCacheData find(DocumentCacheID id) {
        if (id._cacheId != _currentCacheId) {
            return null;
        }
        return (DocumentCacheData)_cache.get(new Integer(id._documentId));
    }

    public String toString() {
        return "<cacheId currentCacheId=\"" + _currentCacheId + "\" cacheId=\"" + this._cacheId + "\" documentId=\"" + this._documentId + "\"/>";
    }
}

