/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp;

import com.adobe.idp.DataBufferInputStream;
import com.adobe.idp.DocumentAccess;
import com.adobe.idp.DocumentBackendAttributes;
import com.adobe.idp.DocumentBackendID;
import com.adobe.idp.DocumentCacheData;
import com.adobe.idp.DocumentCacheID;
import com.adobe.idp.DocumentCallback;
import com.adobe.idp.DocumentCustomDeserializationStream;
import com.adobe.idp.DocumentCustomSerializationStream;
import com.adobe.idp.DocumentError;
import com.adobe.idp.DocumentFileBackend;
import com.adobe.idp.DocumentFileInitMode;
import com.adobe.idp.DocumentInit;
import com.adobe.idp.DocumentManagerClient;
import com.adobe.idp.DocumentManagerEJBRemote;
import com.adobe.idp.DocumentMsgSet;
import com.adobe.idp.DocumentP2PAttributes;
import com.adobe.idp.DocumentPassivationTarget;
import com.adobe.idp.DocumentQueue;
import com.adobe.idp.DocumentReader;
import com.adobe.idp.DocumentRemoteInputStream;
import com.adobe.idp.DocumentStorage;
import com.adobe.idp.DocumentWriter;
import com.adobe.idp.IDocumentCallback;
import com.adobe.idp.IDocumentCallbackHelper;
import com.adobe.idp.IDocumentPullServant;
import com.adobe.idp.IDocumentPullServantHelper;
import com.adobe.idp.TransactionHelper;
import com.adobe.jmx.JmxPortability;
import com.adobe.logging.AdobeLogger;
import com.adobe.service.ConnectionFactory;
import com.adobe.service.DataBuffer;
import com.adobe.service.DataManager;
import com.adobe.service.DataManagerHelper;
import com.adobe.service.FileDataBuffer;
import com.adobe.service.FileDataBufferHelper;
import com.adobe.service.InlinedDataBuffer;
import com.adobe.util.FileCollector;
import com.adobe.util.Utilities;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import javax.activation.FileTypeMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class Document
implements Serializable {
    static final long serialVersionUID = -4034937936652863455L;
    static final int SERIAL_VERSION_R22 = 1;
    static final int SERIAL_VERSION_R23 = 2;
    static final int SERIAL_VERSION_LC80 = 3;
    static final int CURRENT_SERIAL_VERSION = 3;
    static final int ACTIVE = 0;
    static final int PASSIVE = 1;
    static final int INVALID = 2;
    int _state;
    boolean _passivated;
    boolean _senderPassivated;
    boolean _disposed;
    boolean _deserialized;
    IDocumentCallback _callbackRef;
    String _senderCallbackRefIOR;
    int _senderCallbackId;
    int _callbackId;
    String _senderHostId;
    String _contentType;
    DocumentBackendID _localBackendId;
    DocumentBackendID _senderLocalBackendId;
    DocumentBackendID _globalBackendId;
    DocumentBackendID _senderGlobalBackendId;
    InputStream _inputStream;
    URL _url;
    File _file;
    transient DocumentFileInitMode _initFileMode = DocumentFileInitMode.NONE;
    boolean _ownFile;
    DataBuffer _dataBuffer;
    boolean _isTransactionBound;
    byte[] _inline;
    boolean _persistent;
    boolean _senderPersistent;
    DocumentCacheID _cacheId;
    int _maxInlineSize;
    int _disposalTimeout;
    boolean _isDisposalTimeoutDefault;
    Long _expirationTime;
    int _senderVersion = 0;
    HashMap _attributes;
    String _senderPullServantJndiName;
    long _length;
    private static final String INPUT_SHOULD_NOT_BE_NULL = "The input parameter should not be null";
    private static final String URL = "url";
    private static final String failedToFindCachedObject = "Failed to resolve the local cached object possibly due to a classloading issue.";
    private RandomAccessFile _randomAccessFile;
    IDocumentPullServant _pullServant = null;
    private static ConnectionFactory _dataManagerService = null;
    static final String msgStorageConfigError = "The document storage was not configured properly. See the log for details.";
    private static int _defaultDisposalTimeout = -1;
    static final String DEFAULT_DISPOSAL_TIMEOUT_PROP = "defaultDocumentDisposalTimeout";
    private static int _defaultMaxInlineSize = -1;
    static final String DEFAULT_MAX_INLINE_SIZE_PROP = "defaultDocumentMaxInlineSize";
    private static String BASENAME = "basename";
    private static String WSFILENAME = "wsfilename";
    private static String FILENAME = "file";
    private static final AdobeLogger _logger = AdobeLogger.getAdobeLogger(Document.class);
    static String _localIPs = null;
    static boolean _simulateDistrEnv = false;
    static int _isLocalizable = -1;
    private static int _isLazyPassivation = -1;
    static int _isP2PMode = -1;
    static final String ADOBE_TEMP_DIR_PROP = "AdobeTempDir";
    static String _localBackendRoot = null;
    static DocumentFileBackend _localBackend = null;
    static final String GLOBAL_STORAGE_ROOT_DIR_PROP = "globalDocumentStorageRootDir";
    static final String GLOBAL_STORAGE_SWEEP_INTERVAL_PROP = "globalDocumentStorageSweepInterval";
    static final String GLOBAL_STORAGE_USE_NETWORK_SHARE_PROP = "globalDocumentStorageUseNetworkShare";
    static int _isStorageNetworkShared = -1;
    private static DocumentFileBackend _globalBackend = null;
    static final String ADOBE_PREFIX = "com.adobe.idp.";
    static InitialContext _initialContext = null;

    private void defaultInit() {
        this._state = 0;
        this._isTransactionBound = false;
        this._maxInlineSize = Document.getDefaultMaxInlineSize();
        this._disposalTimeout = Document.getDefaultDisposalTimeout();
        this._passivated = false;
        this._deserialized = false;
        this._attributes = new HashMap();
        this._length = -1L;
        this._isDisposalTimeoutDefault = true;
    }

    public Document(byte[] data) {
        this.defaultInit();
        this.init(data);
    }

    public Document(InputStream is) {
        this.defaultInit();
        this.init(is);
    }

    public Document(URL url) {
        this.defaultInit();
        this.init(url);
    }

    public Document(File file, boolean own) {
        this.defaultInit();
        this.init(file, own);
        this._initFileMode = own ? DocumentFileInitMode.OWN_FILE : DocumentFileInitMode.COPY_FILE;
    }

    Document(File file, DocumentFileInitMode inMode) {
        this.defaultInit();
        this.init(file, inMode);
    }

    public Document(DataBuffer db) {
        this.defaultInit();
        this.init(db);
    }

    Document(InlinedDataBuffer idb) {
        this.defaultInit();
        this.init(idb);
    }

    public Document(DocumentWriter writer, java.lang.Object obj) {
        this.defaultInit();
        TransactionHelper.registerCachedDocumentSync(this);
        DocumentCacheData data = new DocumentCacheData();
        data.docWriter = writer;
        data.cachedObj = obj;
        this._cacheId = DocumentCacheID.register(data);
    }

    public Document(Document doc) {
        doc.passivate();
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            doc.writeObject(oos);
            oos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            this.readObject(ois);
        }
        catch (Throwable e) {
            throw new DocumentError(e);
        }
    }

    Document(Document doc, DocumentP2PAttributes attributes, long maxInlineSize) {
        try {
            if (doc._state == 0) {
                doc.setMaxInlineSize((int)maxInlineSize);
            }
            doc.passivate();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DocumentCloneOutputStream oos = new DocumentCloneOutputStream(bos, maxInlineSize);
            doc.writeObject(oos);
            oos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            DocumentCloneInputStream ois = new DocumentCloneInputStream(bis, doc, attributes, maxInlineSize);
            this.readObject(ois);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new DocumentError(e);
        }
        catch (ClassNotFoundException e) {
            throw new DocumentError(e);
        }
    }

    Document(Document doc, String sessionId) {
        this(doc);
        this._persistent = true;
        this.passivate(true, new DocumentP2PAttributes(sessionId));
    }

    void init(byte[] data) {
        if (data == null) {
            throw new DocumentError(INPUT_SHOULD_NOT_BE_NULL);
        }
        this._inline = data;
    }

    void init(InputStream is) {
        if (is == null) {
            throw new DocumentError(INPUT_SHOULD_NOT_BE_NULL);
        }
        this._inputStream = is;
    }

    void init(URL url) {
        if (url == null) {
            throw new DocumentError(INPUT_SHOULD_NOT_BE_NULL);
        }
        this._url = url;
        if (this.getAttribute(URL) == null) {
            this.setAttribute(URL, (Serializable)((java.lang.Object)url.toString()));
        }
    }

    void init(File file, boolean own) {
        this._file = file;
        this._ownFile = own;
        this._initFileMode = own ? DocumentFileInitMode.OWN_FILE : DocumentFileInitMode.COPY_FILE;
        FileTypeMap map = FileTypeMap.getDefaultFileTypeMap();
        if (this._contentType == null) {
            this._contentType = map.getContentType(file);
        }
        if (this.getAttribute(FILENAME) == null) {
            this.setAttribute(FILENAME, (Serializable)((java.lang.Object)file.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(File file, DocumentFileInitMode inMode) {
        try {
            switch (inMode) {
                case OWN_FILE: {
                    this.init(file, true);
                    return;
                }
                case COPY_FILE: {
                    this.init(file, false);
                    return;
                }
                case ADOPT_FILE: {
                    this.init(file, true);
                    return;
                }
            }
            return;
        }
        finally {
            this._initFileMode = inMode;
        }
    }

    void init(DataBuffer db) {
        if (db == null) {
            throw new DocumentError(INPUT_SHOULD_NOT_BE_NULL);
        }
        this._dataBuffer = db;
        if (this._contentType == null) {
            this._contentType = db.getContentType();
        }
    }

    void init(InlinedDataBuffer idb) {
        if (idb == null) {
            throw new DocumentError(INPUT_SHOULD_NOT_BE_NULL);
        }
        if (idb.isInlined) {
            this._inline = idb.inlinedData;
            this._contentType = idb.inlinedContentType;
        } else {
            this.init(idb.remoteDataBuffer);
        }
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        Document.logger().finest("Document.writeObject(): Entering");
        this.assertItIsNotInvalid();
        if (!Document.isPassivationLazy() && !this._deserialized) {
            this.passivate();
        }
        boolean persistent = this._persistent;
        DocumentBackendID globalBackendId = this._globalBackendId;
        DocumentBackendID localBackendId = this._localBackendId;
        DocumentBackendID senderLocalBackendId = this._senderLocalBackendId;
        boolean isCloneOutputStream = false;
        boolean suppressContent = false;
        if (out instanceof DocumentCustomSerializationStream) {
            DocumentCustomSerializationStream s = (DocumentCustomSerializationStream)out;
            if (s.enableDocumentCustomSerialization) {
                Document.logger().finest("Document.writeObject(): Doing custom serialization");
                if (!s.writeDocument(this, out)) {
                    return;
                }
                persistent = this._persistent;
                globalBackendId = this._globalBackendId;
                localBackendId = this._localBackendId;
                senderLocalBackendId = this._senderLocalBackendId;
            }
            if (s.enableDocumentCustomSerializationAsPersistent) {
                Document.logger().finest("Document.writeObject(): Doing custom serialization as persistent");
                this.passivateGlobally();
                persistent = true;
                localBackendId = null;
                senderLocalBackendId = null;
                globalBackendId = s.writeDocumentAsPersistent(this);
            }
            if (isCloneOutputStream = out instanceof DocumentCloneOutputStream) {
                long len = this.length();
                DocumentCloneOutputStream cloneOutputStream = (DocumentCloneOutputStream)out;
                if (len <= cloneOutputStream._maxInlineSize) {
                    suppressContent = true;
                } else if (this._inline != null) {
                    suppressContent = true;
                }
            }
        }
        out.writeInt(3);
        out.writeBoolean(this._passivated);
        out.writeBoolean(persistent);
        if (!suppressContent) {
            this.writeContent(out, isCloneOutputStream, localBackendId, senderLocalBackendId, globalBackendId);
        } else {
            this.writeNullContent(out);
        }
        out.writeObject(this._contentType);
        out.writeObject(null);
        out.writeObject(this._attributes);
        if (!suppressContent && this._senderPullServantJndiName != null && this._senderPullServantJndiName.length() > 0) {
            out.writeUTF(this._senderPullServantJndiName);
        } else if (!suppressContent && Document.isLocalizable()) {
            out.writeUTF(DocumentManagerClient.getPullServantJndiName());
        } else {
            out.writeUTF("");
        }
        out.writeLong(this._length);
        if (!suppressContent) {
            this.invalidate();
        }
    }

    private void writeNullContent(ObjectOutputStream out) throws IOException {
        out.writeObject(null);
        out.writeUTF(Document.getLocalHostId());
        out.writeObject(null);
        out.writeObject(null);
        out.writeObject(null);
        out.writeUTF("");
        out.writeInt(0);
    }

    private void writeContent(ObjectOutputStream out, boolean isCloneOutputStream, DocumentBackendID localBackendId, DocumentBackendID senderLocalBackendId, DocumentBackendID globalBackendId) throws IOException {
        boolean inlined;
        out.writeObject(this._cacheId);
        if (this._senderHostId != null) {
            out.writeUTF(this._senderHostId);
        } else {
            out.writeUTF(Document.getLocalHostId());
        }
        if (this._inline != null && (this._inline.length <= this.getMaxInlineSize() || this._passivated) && !isCloneOutputStream) {
            out.writeObject(this._inline);
            inlined = true;
        } else {
            out.writeObject(null);
            inlined = false;
        }
        if (localBackendId != null) {
            out.writeObject(localBackendId);
        } else {
            out.writeObject(senderLocalBackendId);
        }
        if (globalBackendId != null) {
            out.writeObject(globalBackendId);
        } else {
            out.writeObject(this._senderGlobalBackendId);
        }
        if (globalBackendId == null && this._senderGlobalBackendId == null) {
            if (this._senderCallbackRefIOR != null && this._senderVersion >= 3) {
                out.writeUTF(this._senderCallbackRefIOR);
                out.writeInt(this._senderCallbackId);
            } else if (Document.isLocalizable() && !inlined) {
                if (this._expirationTime == null) {
                    DocumentQueue.instance().add(this);
                }
                try {
                    out.writeUTF(DocumentCallback.ior());
                }
                catch (IOException e) {
                    throw new DocumentError(e);
                }
                if (this._callbackId == 0) {
                    this._callbackId = DocumentCallback.register(this);
                }
                out.writeInt(this._callbackId);
            } else {
                out.writeUTF("");
                out.writeInt(0);
            }
        }
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Document.logger().finest("Document.readObject(): Entering");
        this.defaultInit();
        if (in instanceof DocumentCustomDeserializationStream && ((DocumentCustomDeserializationStream)in).enableDocumentCustomDeserialization) {
            Document.logger().finest("Document.readObject(): Doing custom deserialization");
            if (!((DocumentCustomDeserializationStream)in).readDocument(new DocumentInitImpl(), in)) {
                return;
            }
        }
        this._deserialized = true;
        this._senderVersion = in.readInt();
        this._senderPassivated = in.readBoolean();
        this._senderPersistent = in.readBoolean();
        this._cacheId = (DocumentCacheID)in.readObject();
        this._senderHostId = in.readUTF();
        this._inline = (byte[])in.readObject();
        this._senderLocalBackendId = (DocumentBackendID)in.readObject();
        if (this._senderLocalBackendId != null) {
            this._senderLocalBackendId.setBackend(Document.getLocalBackend());
            this.addInvocationMarker(this._senderLocalBackendId);
        }
        this._senderGlobalBackendId = (DocumentBackendID)in.readObject();
        if (this._senderGlobalBackendId != null) {
            this._senderGlobalBackendId.setBackend(Document.getGlobalBackend());
            this.addInvocationMarker(this._senderGlobalBackendId);
        } else {
            this._senderCallbackRefIOR = in.readUTF();
            if (this._senderCallbackRefIOR.length() == 0) {
                this._senderCallbackRefIOR = null;
            }
            this._senderCallbackId = in.readInt();
            if (this._senderCallbackRefIOR != null && this._inline == null) {
                ORB orb = DocumentCallback.getORB();
                Object obj = orb.string_to_object(this._senderCallbackRefIOR);
                this._callbackRef = IDocumentCallbackHelper.narrow(obj);
            }
        }
        this._contentType = (String)in.readObject();
        if (this._senderVersion >= 2) {
            in.readObject();
        }
        if (this._senderVersion >= 2) {
            this._attributes = (HashMap)in.readObject();
            if (this._attributes != null && this.mapFilenameAttributesOnRead(this._attributes)) {
                java.lang.Object filenameValue = this._attributes.get(WSFILENAME);
                if (filenameValue == null) {
                    filenameValue = this._attributes.get(FILENAME);
                    if (filenameValue instanceof String) {
                        this._attributes.put(WSFILENAME, filenameValue);
                    } else {
                        java.lang.Object urlValue = this._attributes.get(URL);
                        if (urlValue instanceof String) {
                            this.updateBasenameFromURL((String)urlValue);
                        } else {
                            filenameValue = this._attributes.get(BASENAME);
                            if (filenameValue instanceof String) {
                                this._attributes.put(WSFILENAME, filenameValue);
                                this._attributes.put(FILENAME, filenameValue);
                            }
                        }
                    }
                } else if (filenameValue instanceof String) {
                    this._attributes.put(FILENAME, filenameValue);
                }
                if (filenameValue instanceof String) {
                    String filename = (String)filenameValue;
                    this.updateBasename(filename);
                }
            }
        }
        if (this._senderVersion >= 3) {
            this._senderPullServantJndiName = in.readUTF();
            this._length = in.readLong();
        }
        if (in instanceof DocumentCustomDeserializationStream && ((DocumentCustomDeserializationStream)in).enableDocumentCustomDeserialization) {
            ((DocumentCustomDeserializationStream)in).readDocumentAfter(this);
        }
    }

    private boolean mapFilenameAttributesOnRead(HashMap _attributes2) {
        return true;
    }

    public synchronized void passivate() {
        this.assertItIsNotInvalid();
        this.passivate(this._deserialized && this.isSenderRemote(), this.getBackendAttr());
    }

    public synchronized void passivateGlobally() {
        this.assertItIsNotInvalid();
        this.passivate(true, this.getBackendAttr());
    }

    synchronized void passivate(boolean isGlobal, DocumentP2PAttributes attr) {
        if (this.isSenderRemote() && !isGlobal) {
            isGlobal = true;
        }
        if (Document.logger().isLoggable(Level.FINER)) {
            Document.logger().finer("Document.passivate(isGlobal=" + isGlobal + ", attr=" + attr + ") called on the Document: " + this);
        }
        if (Document.logger().isLoggable(Level.FINEST)) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Document.logger().log(Level.FINEST, "See the exception stack trace below to determine where Document.passivate() was called from: ", e);
            }
        }
        if (this._passivated) {
            if (this._inline != null && this._inline.length > this.getMaxInlineSize()) {
                this.passivateInitData(isGlobal, attr, false);
            } else if (isGlobal && this._inline == null && this._localBackendId != null && this._globalBackendId == null) {
                this.setGlobalBackendId(Document.getGlobalBackend().copy(this._localBackendId, attr));
            }
            return;
        }
        if (!this._deserialized) {
            this.passivateInitData(isGlobal, attr, true);
        } else if (this._inline == null) {
            if (!(this._senderLocalBackendId == null || !Document.isLocalizable() || isGlobal || this.isSenderRemote() || this._persistent || this._senderPersistent)) {
                this.setLocalBackendId(Document.getLocalBackend().copy(this._senderLocalBackendId, attr));
            } else if (!(Document.isP2PMode() && this.isSenderRemote() || this._senderGlobalBackendId == null)) {
                this.setGlobalBackendId(Document.getGlobalBackend().copy(this._senderGlobalBackendId, attr));
            } else {
                DocumentManagerClient.requestRemotePassivation(this, isGlobal, attr);
            }
        }
        if (this._inline == null && this._localBackendId == null && this._globalBackendId == null) {
            Document.logger().log(DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (java.lang.Object)"Failed to passivate Document due to an internal error.");
            throw new DocumentError("Failed to passivate Document due to an internal error");
        }
        this._passivated = true;
        this._state = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void passivateInitData(boolean isGlobal, DocumentBackendAttributes attr, boolean useCache) {
        block55: {
            if (useCache && this._cacheId != null) {
                DocumentCacheData data = DocumentCacheID.find(this._cacheId);
                if (data == null) {
                    Document.logger().log(DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (java.lang.Object)failedToFindCachedObject);
                    throw new DocumentError(failedToFindCachedObject);
                }
                Document.logger().finer("Invoking a Document Writer");
                DocumentInitImpl initImpl = new DocumentInitImpl();
                initImpl.setAttributes(attr);
                if (isGlobal) {
                    initImpl.setPassivationTarget(DocumentPassivationTarget.Where.GLOBAL);
                }
                data.docWriter.write(initImpl, data.cachedObj);
            }
            if (this._dataBuffer != null) {
                if (this._dataBuffer._is_a(FileDataBufferHelper.id())) {
                    FileDataBuffer fdb = FileDataBufferHelper.narrow(this._dataBuffer);
                    File file = new File(fdb.getFilePath());
                    if (isGlobal) {
                        this.setGlobalBackendId(Document.getGlobalBackend().linkFromFile(file, attr));
                    } else {
                        this.setLocalBackendId(Document.getLocalBackend().linkFromFile(file, attr));
                    }
                } else {
                    this._inputStream = new DataBufferInputStream(this._dataBuffer);
                }
                this._dataBuffer = null;
            }
            if (this._inline != null && (this._inline.length > this.getMaxInlineSize() || this.getMaxInlineSize() == 0)) {
                this._inputStream = new ByteArrayInputStream(this._inline);
                this._inline = null;
            }
            if (this._file != null) {
                if (this._file.length() <= (long)this.getMaxInlineSize()) {
                    try {
                        this._inputStream = new FileInputStream(this._file);
                    }
                    catch (IOException e) {
                        throw new DocumentError(e);
                    }
                } else if (Document.isP2PMode() && !Document.isLocalizable()) {
                    try {
                        this._inputStream = new FileInputStream(this._file);
                    }
                    catch (FileNotFoundException e) {
                        throw new DocumentError(e);
                    }
                } else {
                    switch (this._initFileMode) {
                        case OWN_FILE: {
                            if (isGlobal) {
                                this.setGlobalBackendId(Document.getGlobalBackend().moveFromFile(this._file, attr));
                            } else {
                                this.setLocalBackendId(Document.getLocalBackend().moveFromFile(this._file, attr));
                            }
                            this._file = null;
                            break;
                        }
                        case COPY_FILE: {
                            if (isGlobal) {
                                this.setGlobalBackendId(Document.getGlobalBackend().copyFromFile(this._file, attr));
                                break;
                            }
                            this.setLocalBackendId(Document.getLocalBackend().copyFromFile(this._file, attr));
                            break;
                        }
                        case ADOPT_FILE: {
                            if (isGlobal) {
                                this.setGlobalBackendId(Document.getGlobalBackend().adoptFromFile(this._file, attr));
                            } else {
                                this.setLocalBackendId(Document.getLocalBackend().adoptFromFile(this._file, attr));
                            }
                            this._file = null;
                        }
                    }
                }
            }
            if (this._url != null) {
                try {
                    URLConnection conn = this._url.openConnection();
                    conn.setDoInput(true);
                    conn.setDoOutput(false);
                    if (this._contentType == null) {
                        int i;
                        this._contentType = conn.getContentType();
                        if (this._contentType != null && (i = this._contentType.indexOf(";")) >= 0) {
                            this._contentType = this._contentType.substring(0, i);
                        }
                    }
                    this._inputStream = conn.getInputStream();
                    this._url = null;
                }
                catch (IOException e) {
                    throw new DocumentError(e);
                }
            }
            if (this._inputStream != null) {
                try {
                    byte[] buf = new byte[this.getMaxInlineSize() + 1];
                    int pos = 0;
                    do {
                        int len;
                        if ((len = this._inputStream.read(buf, pos, buf.length - pos)) == -1) {
                            if (this.getMaxInlineSize() == 0) {
                                buf = new byte[]{};
                                continue;
                            }
                            this._inline = new byte[pos];
                            System.arraycopy(buf, 0, this._inline, 0, pos);
                            break block55;
                        }
                        pos += len;
                    } while (pos != buf.length);
                    SequenceInputStream sis = new SequenceInputStream(new ByteArrayInputStream(buf), this._inputStream);
                    try {
                        if (Document.isP2PMode() && !Document.isLocalizable()) {
                            DocumentManagerClient.clientSidePush(this, sis, Document.getDefaultMaxInlineSize());
                        } else if (isGlobal) {
                            this.writeToGlobalBackend(sis, attr);
                        } else {
                            this.writeToLocalBackend(sis, attr);
                        }
                    }
                    finally {
                        sis.close();
                    }
                }
                catch (IOException e) {
                    this._state = 2;
                    throw new DocumentError(e);
                }
                finally {
                    try {
                        this._inputStream.close();
                    }
                    catch (IOException e) {}
                    this._inputStream = null;
                }
            }
        }
        if (this._file != null && this._ownFile) {
            if (!FileCollector.clientDelete((File)this._file)) {
                throw new DocumentError("Failed to delete file: " + this._file);
            }
            this._file = null;
        }
    }

    boolean shouldUseRemotePullMechanism() {
        return Document.isP2PMode() && this.isSenderRemote();
    }

    public synchronized int read(long pos) {
        this.assertItIsNotInvalid();
        this.passivate();
        if (this._inline != null) {
            if (pos < (long)this._inline.length) {
                return this._inline[(int)pos];
            }
            return -1;
        }
        if (this.shouldUseRemotePullMechanism()) {
            byte[] buf = new byte[1];
            int len = this.read(pos, buf, 0, 1);
            if (len == 1) {
                return buf[0];
            }
            return -1;
        }
        try {
            RandomAccessFile raf = this.getRandomAccessFile();
            raf.seek(pos);
            return raf.read();
        }
        catch (IOException e) {
            throw new DocumentError(e);
        }
    }

    private RandomAccessFile getRandomAccessFile() throws IOException {
        if (this._randomAccessFile == null) {
            FileCollector.debugReportFileChange((File)this.getFile(), (String)"randomAccessFileRead");
            this._randomAccessFile = new RandomAccessFile(this.getFile(), "r");
        }
        return this._randomAccessFile;
    }

    public synchronized void doneReading() {
        try {
            if (this._randomAccessFile != null) {
                FileCollector.debugReportFileChange((File)this._file, (String)"randomAccessFileClose");
                this._randomAccessFile.close();
                this._randomAccessFile = null;
            }
        }
        catch (IOException e) {
            FileCollector.debugReportFileChange((File)this._file, (String)"exception");
            Document.logger().log(DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (java.lang.Object)("while closing " + this));
            throw new DocumentError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(long pos, byte[] b, int off, int len) {
        this.assertItIsNotInvalid();
        this.passivate();
        if (this._inline != null) {
            if (pos < (long)this._inline.length && off < b.length) {
                if (b.length - off < len) {
                    len = b.length - off;
                }
                if ((long)this._inline.length - pos < (long)len) {
                    len = this._inline.length - (int)pos;
                }
                System.arraycopy(this._inline, (int)pos, b, off, len);
                return len;
            }
            return pos >= (long)this._inline.length ? -1 : 0;
        }
        if (this.shouldUseRemotePullMechanism()) {
            if (DocumentManagerClient._httpRoot != null) {
                int n;
                BufferedInputStream is = new BufferedInputStream(DocumentManagerClient.getHttpPullStream(this, pos, len), 16384);
                try {
                    n = ((InputStream)is).read(b, off, len);
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)is).close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        Document.logger().log(DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (java.lang.Object)("while reading " + this));
                        throw new DocumentError(e);
                    }
                }
                ((InputStream)is).close();
                return n;
            }
            try {
                byte[] temp = DocumentRemoteInputStream.pullContent(this.getPullServant(), new DocumentBackendID[]{this._localBackendId, this._globalBackendId}, pos, len);
                if (temp.length == 0) {
                    return -1;
                }
                System.arraycopy(temp, 0, b, off, temp.length);
                return temp.length;
            }
            catch (RuntimeException e) {
                Document.logger().log(DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (java.lang.Object)("while reading " + this));
                throw e;
            }
        }
        try {
            RandomAccessFile raf = this.getRandomAccessFile();
            raf.seek(pos);
            return raf.read(b, off, len);
        }
        catch (IOException e) {
            if (this._file != null) {
                FileCollector.debugReportFileChange((File)this._file, (String)"exception");
            }
            Document.logger().log(DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (java.lang.Object)("while reading " + this));
            throw new DocumentError(e);
        }
    }

    String getPullServantJndiName() {
        if (this._senderPullServantJndiName != null && this._senderPullServantJndiName.length() > 0) {
            return this._senderPullServantJndiName;
        }
        return DocumentManagerClient.getPullServantJndiName();
    }

    IDocumentPullServant getPullServant() {
        if (this._pullServant == null) {
            try {
                DocumentManagerEJBRemote ejb = DocumentManagerClient.getRemoteDocManagerEjb();
                String ior = ejb.getDocumentPullServantIor();
                ORB orb = DocumentCallback.getORB();
                Object obj = orb.string_to_object(ior);
                this._pullServant = IDocumentPullServantHelper.narrow(obj);
            }
            catch (Exception e) {
                throw new DocumentError(e);
            }
        }
        return this._pullServant;
    }

    public long length() {
        this.passivate();
        if (this._length >= 0L) {
            return this._length;
        }
        this._length = this._inline != null ? (long)this._inline.length : (this._localBackendId != null ? this._localBackendId.length() : this._globalBackendId.length());
        return this._length;
    }

    public synchronized InputStream getInputStream() {
        this.assertItIsNotInvalid();
        this.passivate();
        this.invalidate();
        if (this._inline != null) {
            return new ByteArrayInputStream(this._inline);
        }
        if (this.shouldUseRemotePullMechanism()) {
            if (DocumentManagerClient._httpRoot != null) {
                return DocumentManagerClient.getHttpPullStream(this, -1L, -1);
            }
            return new DocumentRemoteInputStream(this, Document.getP2PChunkSize());
        }
        if (Document.isLocalizable()) {
            if (this._localBackendId == null) {
                this.localize();
            }
            return Document.getLocalBackend().read(this._localBackendId);
        }
        return Document.getGlobalBackend().read(this._globalBackendId);
    }

    public synchronized File getFile() {
        this.assertItIsNotInvalid();
        this.passivate();
        this.invalidate();
        if (Document.isLocalizable()) {
            if (this._localBackendId == null) {
                if (this._inline != null) {
                    this.writeToLocalBackend(new ByteArrayInputStream(this._inline), this.getBackendAttr());
                } else if (this.shouldUseRemotePullMechanism()) {
                    this.writeToLocalBackend(this.getInputStream(), this.getBackendAttr());
                } else {
                    this.localize();
                }
            }
            return Document.getLocalBackend().getFile(this._localBackendId);
        }
        if (!Document.isP2PMode()) {
            if (this._inline != null && this._globalBackendId == null) {
                this.writeToGlobalBackend(new ByteArrayInputStream(this._inline), this.getBackendAttr());
            }
            return Document.getGlobalBackend().getFile(this._globalBackendId);
        }
        try {
            File file = this.createTempFile("adobe-lc-", ".tmp");
            file.deleteOnExit();
            this.copyToFile(file);
            return file;
        }
        catch (IOException e) {
            throw new DocumentError(e);
        }
    }

    private File createTempFile(String string, String string2) throws IOException {
        File out = File.createTempFile(string, string2);
        FileCollector.debugReportFileChange((File)out, (String)"create");
        return out;
    }

    public synchronized void copyToFile(File file) {
        InputStream is = this.getInputStream();
        DocumentFileBackend.saveStreamToFile(is, file);
    }

    public synchronized DataBuffer getDataBuffer() {
        this.assertItIsNotInvalid();
        try {
            DataManager dm = Document.getDataManager();
            File file = this.getFile();
            FileDataBuffer buffer = dm.createFileDataBuffer(file.toString());
            String type = this.getContentType();
            if (type != null && type.length() != 0) {
                buffer.setContentType(type);
            }
            return buffer;
        }
        catch (Exception e) {
            throw new DocumentError(e);
        }
    }

    synchronized InlinedDataBuffer getInlinedDataBuffer() {
        this.assertItIsNotInvalid();
        this.passivate();
        this.invalidate();
        InlinedDataBuffer inlinedDataBuffer = new InlinedDataBuffer();
        if (this._inline != null) {
            inlinedDataBuffer.isInlined = true;
            inlinedDataBuffer.inlinedContentType = this.getContentType();
            inlinedDataBuffer.inlinedData = this._inline;
        } else {
            inlinedDataBuffer.isInlined = false;
            inlinedDataBuffer.remoteDataBuffer = this.getDataBuffer();
        }
        return inlinedDataBuffer;
    }

    private static DataManager getDataManager() {
        try {
            if (_dataManagerService == null) {
                _dataManagerService = Utilities.serviceLookup((String)"DataManagerService");
            }
            Object obj = (Object)_dataManagerService.getConnection();
            return DataManagerHelper.narrow(obj);
        }
        catch (Exception e) {
            throw new DocumentError(e);
        }
    }

    public java.lang.Object getObject(DocumentReader reader) {
        this.assertItIsNotInvalid();
        if (this._cacheId != null) {
            DocumentCacheData data = DocumentCacheID.find(this._cacheId);
            if (data == null && !this._deserialized) {
                Document.logger().log(DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (java.lang.Object)failedToFindCachedObject);
                throw new DocumentError(failedToFindCachedObject);
            }
            if (data != null && reader.isSupported(data.cachedObj)) {
                return data.cachedObj;
            }
        }
        java.lang.Object result = reader.read(new DocumentAccessImpl());
        this.invalidate();
        return result;
    }

    public void setDisposalTimeout(int seconds) {
        this.assertActiveState();
        this._disposalTimeout = seconds;
        this._isDisposalTimeoutDefault = false;
        if (this._expirationTime != null) {
            DocumentQueue.instance().update(this);
        }
    }

    public int getDisposalTimeout() {
        return this._disposalTimeout;
    }

    public static void setDefaultDisposalTimeout(int seconds) {
        _defaultDisposalTimeout = seconds;
    }

    public static synchronized int getDefaultDisposalTimeout() {
        if (_defaultDisposalTimeout == -1) {
            _defaultDisposalTimeout = Document.getConfigParamAsPositiveInt(DEFAULT_DISPOSAL_TIMEOUT_PROP, 600);
            Document.logger().fine("The document default disposal timeout is: " + _defaultDisposalTimeout);
        }
        return _defaultDisposalTimeout;
    }

    public void setTransactionBound(boolean value) {
        this.assertActiveState();
        if (!this._isTransactionBound && value) {
            TransactionHelper.registerTransactionBoundDocumentSync(this);
        }
        this._isTransactionBound = value;
    }

    public boolean isTransactionBound() {
        return this._isTransactionBound;
    }

    public void setMaxInlineSize(int bytes) {
        this.assertActiveState();
        this._maxInlineSize = bytes;
    }

    public int getMaxInlineSize() {
        return this._maxInlineSize;
    }

    public static void setDefaultMaxInlineSize(int bytes) {
        _defaultMaxInlineSize = bytes;
    }

    public static synchronized int getDefaultMaxInlineSize() {
        if (_defaultMaxInlineSize == -1) {
            _defaultMaxInlineSize = Document.getConfigParamAsPositiveInt(DEFAULT_MAX_INLINE_SIZE_PROP, 65536);
            Document.logger().fine("The document default max inline size is: " + _defaultMaxInlineSize);
        }
        return _defaultMaxInlineSize;
    }

    static int getP2PChunkSize() {
        return Document.getDefaultMaxInlineSize();
    }

    public void setContentType(String type) {
        this._contentType = type;
    }

    public String getContentType() {
        return this._contentType;
    }

    public void setAttribute(String name, Serializable value) {
        this._attributes.put(name, value);
        boolean isFilename = false;
        if (name.equals(WSFILENAME)) {
            this._attributes.put(FILENAME, value);
            isFilename = true;
        } else if (name.equals(FILENAME)) {
            this._attributes.put(WSFILENAME, value);
            isFilename = true;
        } else if (name.equals(BASENAME)) {
            this._attributes.put(WSFILENAME, value);
            this._attributes.put(FILENAME, value);
        }
        boolean isString = value instanceof String;
        if (isFilename && isString) {
            this.updateBasename((String)((java.lang.Object)value));
        } else if (name.equals(URL) && isString) {
            this.updateBasenameFromURL((String)((java.lang.Object)value));
        }
    }

    private void updateBasenameFromURL(String url) {
        String basenameURL;
        int i = url.lastIndexOf(47);
        String result = basenameURL = url.substring(i + 1);
        if (basenameURL.indexOf(37) != -1) {
            try {
                URI uri = new URI(basenameURL);
                result = uri.getPath();
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        this._attributes.put(BASENAME, result);
    }

    private void updateBasename(String filename) {
        int i = filename.lastIndexOf(47);
        int j = filename.lastIndexOf(92);
        if (j > i) {
            i = j;
        }
        String basename = filename.substring(i + 1);
        this._attributes.put(BASENAME, basename);
    }

    public Serializable getAttribute(String name) {
        return (Serializable)this._attributes.get(name);
    }

    public void removeAttribute(String name) {
        if (name.equals(FILENAME) || name.equals(WSFILENAME) || name.equals(BASENAME)) {
            this._attributes.remove(WSFILENAME);
            this._attributes.remove(FILENAME);
            this._attributes.remove(BASENAME);
        } else {
            this._attributes.remove(name);
        }
    }

    public Set listAttributes() {
        return this._attributes.keySet();
    }

    public void dispose() {
        Document.logger().fine("Disposing Document: " + System.identityHashCode(this));
        if (!this._disposed) {
            this._disposed = true;
            this._state = 2;
            this._inline = null;
            this.doneReading();
            if (this._inputStream != null) {
                try {
                    this._inputStream.close();
                }
                catch (IOException e) {
                    throw new DocumentError(e);
                }
            }
            if (this._callbackId != 0) {
                DocumentCallback.unregister(this._callbackId);
            }
            if (this._expirationTime != null) {
                DocumentQueue.instance().remove(this);
            }
            if (!this._deserialized && this._cacheId != null) {
                DocumentCacheID.unregister(this._cacheId);
                this._cacheId = null;
            }
            if (Document.isLocalizable() && this._localBackendId != null) {
                Document.getLocalBackend().remove(this._localBackendId);
            }
            if (Document.isLocalizable() && !this._persistent && this._globalBackendId != null) {
                Document.getGlobalBackend().remove(this._globalBackendId);
            }
            if (this._ownFile && this._file != null) {
                FileCollector.clientDelete((File)this._file);
            }
        }
    }

    private void assertActiveState() {
        if (this._state != 0) {
            throw new DocumentError("The Document is not in the ACTIVE state, which is required when calling this method.");
        }
    }

    private void assertItIsNotInvalid() {
        if (this._state == 2) {
            throw new DocumentError("Cannot do anything with the Document that is in the INVALID state.");
        }
    }

    private void invalidate() {
        this._state = 1;
    }

    static AdobeLogger logger() {
        return _logger;
    }

    static String getLocalHostId() {
        if (_localIPs == null) {
            try {
                StringBuffer buffer = new StringBuffer();
                Enumeration<NetworkInterface> i = NetworkInterface.getNetworkInterfaces();
                while (i != null && i.hasMoreElements()) {
                    NetworkInterface ni = i.nextElement();
                    Enumeration<InetAddress> j = ni.getInetAddresses();
                    while (j != null && j.hasMoreElements()) {
                        InetAddress ia = j.nextElement();
                        buffer.append(ia.getHostAddress());
                        if (!j.hasMoreElements()) continue;
                        buffer.append("/");
                    }
                    if (!i.hasMoreElements()) continue;
                    buffer.append("/");
                }
                _localIPs = buffer.toString();
            }
            catch (Throwable e) {
                Document.logger().log(e, DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (java.lang.Object)"Failed to resolve local network addresses");
                throw new DocumentError(e);
            }
        }
        if (Document.getSimulateDistrEnv()) {
            Document.logger().finer("Simulating a distributed environment on the same host.");
            return new Integer(System.identityHashCode(_localBackend)).toString();
        }
        return _localIPs;
    }

    static boolean getSimulateDistrEnv() {
        return _simulateDistrEnv;
    }

    private boolean isSenderRemote() {
        return !Document.isLocalizable() || this._senderPullServantJndiName != null && (!this._senderPullServantJndiName.equals(DocumentManagerClient.getPullServantJndiName()) || Document.getSimulateDistrEnv());
    }

    private void writeToGlobalBackend(InputStream is, DocumentBackendAttributes attr) {
        if (Document.logger().isLoggable(Level.FINER)) {
            Document.logger().finer("Saving content into global backend with attributes: " + attr + " for Document: " + this.toString());
        }
        this.setGlobalBackendId(Document.getGlobalBackend().write(is, attr));
    }

    private void writeToLocalBackend(InputStream is, DocumentBackendAttributes attr) {
        if (Document.logger().isLoggable(Level.FINER)) {
            Document.logger().finer("Saving content into local backend with attributes: " + attr + " for Document: " + this.toString());
        }
        this.setLocalBackendId(Document.getLocalBackend().write(is, attr));
    }

    void localize() {
        if (this._localBackendId == null) {
            this.setLocalBackendId(Document.getLocalBackend().copy(this._globalBackendId, this.getBackendAttr()));
        }
    }

    void globalize() {
        if (this._globalBackendId == null) {
            this.setGlobalBackendId(Document.getGlobalBackend().copy(this._localBackendId, this.getBackendAttr()));
        }
    }

    static boolean isLocalizable() {
        if (_isLocalizable < 0) {
            try {
                Document.getDataManagerJmxAttr(GLOBAL_STORAGE_ROOT_DIR_PROP);
                _isLocalizable = 1;
            }
            catch (Throwable t) {
                Document.logger().fine("Assuming a non-J2EE environment as failed to talk to DataManager via JMX: " + t);
                _isLocalizable = 0;
            }
        }
        return _isLocalizable > 0;
    }

    static boolean isP2PMode() {
        if (_isP2PMode < 0) {
            _isP2PMode = Document.isStorageNetworkShared() ? 0 : 1;
        }
        return _isP2PMode > 0;
    }

    public static boolean isPassivationLazy() {
        if (_isLazyPassivation < 0) {
            _isLazyPassivation = Document.isLocalizable() ? 1 : 0;
        }
        return _isLazyPassivation > 0;
    }

    public static void setPassivationLazy(boolean enable) {
        _isLazyPassivation = enable ? 1 : 0;
    }

    DocumentP2PAttributes getBackendAttr() {
        return new DocumentP2PAttributes(this.getDisposalTimeout());
    }

    static synchronized DocumentFileBackend getLocalBackend() {
        if (_localBackend == null) {
            if (_localBackendRoot == null) {
                String defaultRoot = new File(System.getProperty("java.io.tmpdir"), "AdobeDocumentStorage").toString();
                String root = Document.getConfigParamAsString(ADOBE_TEMP_DIR_PROP, defaultRoot);
                File tempDirWithAppServer = new File(root);
                String tempDirWithoutAppServer = tempDirWithAppServer.getParent();
                if (tempDirWithoutAppServer != null) {
                    root = tempDirWithoutAppServer;
                }
                _localBackendRoot = root = new File(root, "AdobeDocumentStorage/local").toString();
            }
            _localBackend = new DocumentFileBackend(_localBackendRoot, false);
            Document.logger().fine("The local document storage is under: " + _localBackendRoot);
        }
        return _localBackend;
    }

    static synchronized void setLocalBackendRoot(String path) {
        _localBackendRoot = path;
        _localBackend = null;
    }

    static boolean isStorageNetworkShared() {
        if (_isStorageNetworkShared < 0) {
            boolean flag = Document.getConfigParamAsBoolean(GLOBAL_STORAGE_USE_NETWORK_SHARE_PROP, false);
            _isStorageNetworkShared = flag ? 1 : 0;
            Document.logger().fine("The global document storage is a newtwok share: " + flag);
        }
        return _isStorageNetworkShared > 0;
    }

    static synchronized DocumentFileBackend getGlobalBackend() {
        if (_globalBackend == null) {
            String root = Document.getConfigParamAsString(GLOBAL_STORAGE_ROOT_DIR_PROP, "");
            boolean adjustTimeSkew = Document.isStorageNetworkShared();
            _globalBackend = new DocumentFileBackend(root, adjustTimeSkew);
            Document.logger().fine("The global document storage is under: " + root);
            Document.logSettings();
        }
        return _globalBackend;
    }

    private static void logSettings() {
        try {
            Document.logger().log(DocumentMsgSet.GLOBAL_STORAGE_SWEEP_INTERVAL_PROP_VALUE_IS, FileCollector.getSleepTime());
            Document.logger().log(DocumentMsgSet.GLOBAL_STORAGE_ROOT_DIR_PROP_VALUE_IS, Document.getGlobalBackend()._rootDir);
            Document.logger().log(DocumentMsgSet.LOCAL_STORAGE_ROOT_DIR_PROP_VALUE_IS, Document.getLocalBackend()._rootDir);
            Document.logger().log(DocumentMsgSet.DEFAULT_DISPOSAL_TIMEOUT_PROP_VALUE_IS, Document.getDefaultDisposalTimeout());
            Document.logger().log(DocumentMsgSet.DEFAULT_MAX_INLINE_SIZE_PROP_VALUE_IS, Document.getDefaultMaxInlineSize());
            Document.logger().log(DocumentMsgSet.GLOBAL_STORAGE_USE_NETWORK_SHARE_PROP_VALUE_IS, Document.isStorageNetworkShared());
            new DocumentStorage().removeAll("DocManagerDebugTrace");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    void setGlobalBackendId(DocumentBackendID id) {
        if (id != null) {
            id.setBackend(Document.getGlobalBackend());
            this.addInvocationMarker(id);
        }
        this._globalBackendId = id;
    }

    void setLocalBackendId(DocumentBackendID id) {
        if (id != null) {
            id.setBackend(Document.getLocalBackend());
            this.addInvocationMarker(id);
        }
        this._localBackendId = id;
    }

    void addInvocationMarker(DocumentBackendID id) {
        String sessionId = DocumentManagerClient.getCurrentInvocationSessionId();
        if (sessionId != null) {
            id.getBackend().copy(id, new DocumentP2PAttributes(sessionId));
        }
    }

    public String toString() {
        String str = "<document state=\"" + (this._state == 0 ? "active" : (this._state == 1 ? "passive" : "invalid")) + "\"" + " senderVersion=\"" + this._senderVersion + "\"" + " persistent=\"" + this._persistent + "\"" + " senderPersistent=\"" + this._senderPersistent + "\"" + " passivated=\"" + this._passivated + "\"" + " senderPassivated=\"" + this._senderPassivated + "\"" + " deserialized=\"" + this._deserialized + "\"" + " senderHostId=\"" + this._senderHostId + "\"" + " callbackId=\"" + this._callbackId + "\"" + " senderCallbackId=\"" + this._senderCallbackId + "\"" + " callbackRef=\"" + this._callbackRef + "\"" + " isLocalizable=\"" + Document.isLocalizable() + "\"" + " isTransactionBound=\"" + this.isTransactionBound() + "\"" + " defaultDisposalTimeout=\"" + Document.getDefaultDisposalTimeout() + "\"" + " disposalTimeout=\"" + this.getDisposalTimeout() + "\"" + " maxInlineSize=\"" + this.getMaxInlineSize() + "\"" + " defaultMaxInlineSize=\"" + Document.getDefaultMaxInlineSize() + "\"" + " inlineSize=\"" + (this._inline == null ? "0" : new Integer(this._inline.length).toString()) + "\"" + " contentType=\"" + this._contentType + "\"" + " length=\"" + this._length + "\"" + ">" + (this._cacheId != null ? this._cacheId.toString() : "<cacheId/>") + (this._localBackendId != null ? "<localBackendId>" + this._localBackendId.toString() + "<localBackendId/>" : "<localBackendId/>") + (this._globalBackendId != null ? "<globalBackendId>" + this._globalBackendId.toString() + "<globalBackendId/>" : "<globalBackendId/>") + (this._senderLocalBackendId != null ? "<senderLocalBackendId>" + this._senderLocalBackendId.toString() + "<senderLocalBackendId/>" : "<senderLocalBackendId/>") + (this._senderGlobalBackendId != null ? "<senderGlobalBackendId>" + this._senderGlobalBackendId.toString() + "<senderGlobalBackendId/>" : "<senderGlobalBackendId/>") + (this._inline != null ? "<inline>" + (this._inline.length > 100 ? new String(this._inline, 0, 100) + "..." : new String(this._inline)) + "</inline>" : "<inline/>") + (this._senderPullServantJndiName != null ? "<senderPullServantJndiName>" + this._senderPullServantJndiName + "</senderPullServantJndiName>" : "<senderPullServantJndiName/>") + "<attributes";
        java.lang.Object[] attrKeys = this._attributes.keySet().toArray();
        for (int i = 0; i < attrKeys.length; ++i) {
            str = str + " " + attrKeys[i] + "=\"" + this._attributes.get(attrKeys[i]) + "\"";
        }
        return str + "/></document>";
    }

    private static java.lang.Object getDataManagerJmxAttr(final String attrName) {
        final MBeanServer mbs = JmxPortability.mBeanServer;
        final ObjectName name = JmxPortability.makeName((String)JmxPortability.ADOBE_SERVICE_TYPE, (String)"DataManagerService");
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public java.lang.Object run() throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
                    return mbs.getAttribute(name, attrName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Document.logger().debug(e, "Failed to resolve \"" + attrName + "\" attribute.");
            throw new DocumentError(e);
        }
    }

    private static java.lang.Object getConfigParamAsObject(String paramName) {
        String val = System.getProperty(ADOBE_PREFIX + paramName);
        if (val != null) {
            Document.logger().debug("The \"" + paramName + "\" parameter was set in a systemt property." + " The value is \"" + val + "\"");
            return val;
        }
        try {
            java.lang.Object obj = Document.getDataManagerJmxAttr(paramName);
            Document.logger().debug("The \"" + paramName + "\" parameter was set in the DataManager service." + " The value is \"" + obj + "\"");
            return obj;
        }
        catch (Throwable t) {
            Document.logger().debug(t, "Failed to resolve the \"" + paramName + "\" property via DataManager.");
            return null;
        }
    }

    private static String getConfigParamAsString(String paramName, String defaultVal) {
        String result = (String)Document.getConfigParamAsObject(paramName);
        if (result == null || result.length() == 0) {
            result = defaultVal;
        }
        return result;
    }

    static int getConfigParamAsPositiveInt(String paramName, int defaultVal) {
        int result;
        java.lang.Object val = Document.getConfigParamAsObject(paramName);
        if (val == null) {
            result = defaultVal;
        } else if (val instanceof Integer) {
            result = (Integer)val;
        } else {
            try {
                result = Integer.parseInt((String)val);
            }
            catch (NumberFormatException e) {
                result = -1;
            }
        }
        if (result <= 0) {
            throw new DocumentError("Property " + paramName + " should be set to a positive non-zero number. \"" + val + "\" is invalid value");
        }
        return result;
    }

    private static boolean getConfigParamAsBoolean(String paramName, boolean defaultVal) {
        java.lang.Object val = Document.getConfigParamAsObject(paramName);
        boolean result = val == null ? defaultVal : (val instanceof Boolean ? ((Boolean)val).booleanValue() : new Boolean((String)val).booleanValue());
        return result;
    }

    public static void setInitialContext(InitialContext ic) {
        _initialContext = ic;
    }

    static InitialContext getInitialContext() {
        if (_initialContext == null) {
            try {
                _initialContext = new InitialContext();
            }
            catch (NamingException e) {
                throw new DocumentError(e);
            }
        }
        return _initialContext;
    }

    class DocumentAccessImpl
    implements DocumentAccess {
        DocumentAccessImpl() {
        }

        public InputStream getInputStream() {
            return Document.this.getInputStream();
        }

        public File getFile() {
            return Document.this.getFile();
        }

        public void copyToFile(File file) {
            Document.this.copyToFile(file);
        }

        public DataBuffer getDataBuffer() {
            return Document.this.getDataBuffer();
        }
    }

    class DocumentInitImpl
    implements DocumentInit,
    DocumentPassivationTarget {
        DocumentPassivationTarget.Where _passivationTarget = DocumentPassivationTarget.Where.LOCAL;
        DocumentBackendAttributes attributes = null;

        DocumentInitImpl() {
        }

        public void init(byte[] data) {
            Document.this.init(data);
        }

        public void init(InputStream is) {
            Document.this.init(is);
        }

        public void init(URL url) {
            Document.this.init(url);
        }

        public void init(File file, boolean own) {
            Document.this.init(file, own);
        }

        public void init(DataBuffer db) {
            Document.this.init(db);
        }

        public void init(InlinedDataBuffer idb) {
            Document.this.init(idb);
        }

        public void passivate() {
            Document.this.passivate();
        }

        public void passivateGlobally() {
            Document.this.passivateGlobally();
        }

        public void init(File file, DocumentFileInitMode mode) {
            Document.this.init(file, mode);
        }

        public DocumentPassivationTarget.Where getPassivationTarget() {
            return this._passivationTarget;
        }

        void setPassivationTarget(DocumentPassivationTarget.Where _where) {
            this._passivationTarget = _where;
        }

        public long getDisposalTimeout() {
            if (this.attributes instanceof DocumentP2PAttributes) {
                DocumentP2PAttributes p2pAttrs = (DocumentP2PAttributes)this.attributes;
                return p2pAttrs._timeoutInSeconds;
            }
            return this.attributes.getExpiration() - DocumentQueue.currentTimeInSeconds();
        }

        void setAttributes(DocumentBackendAttributes attributes) {
            this.attributes = attributes;
        }
    }

    private static class DocumentCloneInputStream
    extends DocumentCustomDeserializationStream {
        Document _orig = null;
        DocumentP2PAttributes _attributes = null;
        long _maxInlineSize = 0L;

        public DocumentCloneInputStream(InputStream stream, Document orig, DocumentP2PAttributes attributes, long maxInlineSize) throws IOException {
            super(stream);
            this.enableDocumentCustomDeserialization = true;
            this._orig = orig;
            this._attributes = attributes;
            this._maxInlineSize = maxInlineSize;
        }

        protected boolean readDocument(DocumentInit doc, ObjectInputStream in) throws IOException {
            if (!DocumentCloneOutputStream.id.equals(this.readUTF())) {
                throw new RuntimeException("DocumentCloneInputStream mismatched to its outputstream!");
            }
            return true;
        }

        protected void readDocumentAfter(Document doc) throws IOException {
            long olen = this._orig.length();
            boolean passivate = false;
            boolean isGlobal = false;
            if (this._attributes.getSessionId() != null) {
                isGlobal = true;
                doc._persistent = true;
            }
            if (this._attributes == null) {
                this._attributes = doc.getBackendAttr();
            }
            doc._deserialized = false;
            doc._maxInlineSize = (int)this._maxInlineSize;
            if (olen <= this._maxInlineSize) {
                if (this._orig._inline != null) {
                    doc._inline = this._orig._inline;
                } else {
                    doc.init(this._orig.getInputStream());
                }
                passivate = true;
            } else if (this._orig._inline != null) {
                doc._inline = this._orig._inline;
                passivate = true;
            } else if (this._orig._globalBackendId != null || this._orig._senderGlobalBackendId != null) {
                DocumentBackendID id = this._orig._globalBackendId;
                if (id == null) {
                    id = this._orig._senderGlobalBackendId;
                }
                doc.setGlobalBackendId(Document.getGlobalBackend().copy(id, this._attributes));
                doc.invalidate();
            } else {
                doc.init(this._orig.getInputStream());
                passivate = true;
            }
            if (passivate) {
                doc.passivate(isGlobal, this._attributes);
            }
        }
    }

    private static class DocumentCloneOutputStream
    extends DocumentCustomSerializationStream {
        static final String id = DocumentCloneOutputStream.class.getName() + ".1.0";
        long _maxInlineSize = -1L;

        public DocumentCloneOutputStream(OutputStream out, long maxInlineSize) throws IOException {
            super(out);
            this.enableDocumentCustomSerialization = true;
            this._maxInlineSize = maxInlineSize;
        }

        public boolean writeDocument(Document doc, ObjectOutputStream out) throws IOException {
            out.writeUTF(id);
            return true;
        }
    }
}

