/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp;

import com.adobe.service.DataBuffer;
import java.io.IOException;
import java.io.InputStream;

class DataBufferInputStream
extends InputStream {
    private DataBuffer _dataBuffer;
    private long _pos = 0L;
    private long _len = 0L;

    public DataBufferInputStream(DataBuffer db) {
        this._dataBuffer = db;
        this._len = this._dataBuffer.getBufLength();
    }

    public int available() throws IOException {
        long available = this._len - this._pos;
        if (available > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)available;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this._len <= this._pos) {
            return -1;
        }
        if (len > this.available()) {
            len = this.available();
        }
        if (len == 0) {
            return 0;
        }
        byte[] buf = this._dataBuffer.getBytes(this._pos, len);
        len = buf.length;
        System.arraycopy(buf, 0, b, off, len);
        this._pos += (long)len;
        return len;
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int len = this.read(buf);
        if (len == -1) {
            return -1;
        }
        return buf[0];
    }

    public void close() throws IOException {
        this._dataBuffer = null;
    }
}

