/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp;

import com.adobe.idp.Document;
import com.adobe.idp.DocumentCacheID;
import com.adobe.idp.DocumentMsgSet;
import java.util.logging.Level;
import javax.transaction.Synchronization;

class CachedDocumentSync
implements Synchronization {
    private Document _document;

    CachedDocumentSync(Document doc) {
        this._document = doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void passivateAndUnregister(boolean alwaysPassivate) {
        Document document = this._document;
        synchronized (document) {
            if (this._document._state == 2) {
                return;
            }
            try {
                if (alwaysPassivate || this._document._state != 1) {
                    this._document.passivate();
                }
            }
            finally {
                if (this._document._cacheId != null) {
                    DocumentCacheID.unregister(this._document._cacheId);
                    this._document._cacheId = null;
                }
            }
        }
    }

    public void beforeCompletion() {
        Document.logger().finer("CachedDocumentSync.beforeCompletion");
        this.passivateAndUnregister(true);
    }

    public void afterCompletion(int status) {
        if (Document.logger().isLoggable(Level.FINER)) {
            Document.logger().finer("CachedDocumentSync.afterCompletion status=" + (status == 3 ? "COMMITED" : (status == 4 ? "ROLLEDBACK" : Integer.toString(status))));
        }
        if (status == 4) {
            try {
                this.passivateAndUnregister(false);
            }
            catch (Exception e) {
                Document.logger().log((Throwable)e, DocumentMsgSet.AN_UNEXPECTED_EXCEPTION, (Object)"While passivating com.adobe.idp.Document cached objects during transaction rollback.");
            }
        }
    }
}

