/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.util;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.jaxen.expr.AdditiveExpr;
import org.jaxen.expr.AllNodeStep;
import org.jaxen.expr.CommentNodeStep;
import org.jaxen.expr.EqualityExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LiteralExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.LogicalExpr;
import org.jaxen.expr.MultiplicativeExpr;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.NumberExpr;
import org.jaxen.expr.PathExpr;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.ProcessingInstructionNodeStep;
import org.jaxen.expr.RelationalExpr;
import org.jaxen.expr.Step;
import org.jaxen.expr.TextNodeStep;
import org.jaxen.expr.UnaryExpr;
import org.jaxen.expr.UnionExpr;
import org.jaxen.expr.VariableReferenceExpr;
import org.jaxen.expr.Visitor;

public class XPath2XMLVisitor
implements Visitor {
    protected PrintWriter printer;
    protected int tabIndex;

    public XPath2XMLVisitor() {
        this.printer = new PrintWriter(System.out);
    }

    public XPath2XMLVisitor(PrintWriter printer) {
        this.printer = printer;
    }

    public void visit(PathExpr expr) {
        this.printLn("<PathExpr>");
        if (expr.getFilterExpr() != null) {
            expr.getFilterExpr().accept(this);
        }
        if (expr.getLocationPath() != null) {
            expr.getLocationPath().accept(this);
        }
        this.printLn("</PathExpr>");
    }

    public void visit(LocationPath expr) {
        this.printLn("<LocationPath absolute=\"" + expr.isAbsolute() + "\">");
        for (Step step : expr.getSteps()) {
            step.accept(this);
        }
        this.printLn("</LocationPath>");
    }

    public void visit(LogicalExpr expr) {
        this.printLn("<LogicalExpr operator=\"" + expr.getOperator() + "\">");
        this.printLhsRhs(expr.getLHS(), expr.getRHS());
        this.printLn("</LogicalExpr>");
    }

    void printLhsRhs(Expr lhs, Expr rhs) {
        ++this.tabIndex;
        this.printLn("<lhsExpr>");
        lhs.accept(this);
        this.printLn("</lhsExpr>");
        this.printLn("<rhsExpr>");
        rhs.accept(this);
        this.printLn("</rhsExpr>");
        --this.tabIndex;
    }

    public void visit(EqualityExpr expr) {
        this.printLn("<EqualityExpr operator=\"" + expr.getOperator() + "\">");
        this.printLhsRhs(expr.getLHS(), expr.getRHS());
        this.printLn("</EqualityExpr>");
    }

    public void visit(FilterExpr expr) {
        this.printLn("<FilterExpr>");
        ++this.tabIndex;
        if (expr.getExpr() != null) {
            expr.getExpr().accept(this);
        }
        Iterator iter = expr.getPredicates().iterator();
        while (iter.hasNext()) {
            ((Predicate)iter.next()).getExpr().accept(this);
        }
        --this.tabIndex;
        this.printLn("</FilterExpr>");
    }

    public void visit(RelationalExpr expr) {
        this.printLn("<RelationalExpr operator=\"" + expr.getOperator() + "\">");
        this.printLhsRhs(expr.getLHS(), expr.getRHS());
        this.printLn("</RelationalExpr>");
    }

    public void visit(AdditiveExpr expr) {
        this.printLn("<AdditiveExpr operator=\"" + expr.getOperator() + "\">");
        this.printLhsRhs(expr.getLHS(), expr.getRHS());
        this.printLn("</AdditiveExpr>");
    }

    public void visit(MultiplicativeExpr expr) {
        this.printLn("<MultiplicativeExpr operator=\"" + expr.getOperator() + "\">");
        this.printLhsRhs(expr.getLHS(), expr.getRHS());
        this.printLn("</MultiplicativeExpr>");
    }

    public void visit(UnaryExpr expr) {
        this.printLn("<UnaryExpr>");
        expr.getExpr().accept(this);
        this.printLn("</UnaryExpr>");
    }

    public void visit(UnionExpr expr) {
        this.printLn("<UnionExpr>");
        this.printLhsRhs(expr.getLHS(), expr.getRHS());
        this.printLn("</UnionExpr>");
    }

    public void visit(NumberExpr expr) {
        this.printLn("<NumberExpr>");
        this.printLn(expr.getNumber().toString());
        this.printLn("</NumberExpr>");
    }

    public void visit(LiteralExpr expr) {
        this.printLn("<LiteralExpr literal=\"" + expr.getLiteral() + "\"/>");
    }

    public void visit(VariableReferenceExpr expr) {
        this.printLn("<VariableReferenceExpr name=\"" + expr.getVariableName() + "\"/>");
    }

    public void visit(FunctionCallExpr expr) {
        this.printLn("<FunctionCallExpr prefix=\"" + expr.getPrefix() + "\" functionName=\"" + expr.getFunctionName() + "\">");
        Iterator iterator = expr.getParameters().iterator();
        ++this.tabIndex;
        this.printLn("<Args>");
        while (iterator.hasNext()) {
            ((Expr)iterator.next()).accept(this);
        }
        this.printLn("</Args>");
        --this.tabIndex;
        this.printLn("</FunctionCallExpr>");
    }

    public void visit(NameStep step) {
        this.printLn("<NameStep prefix=\"" + step.getPrefix() + "\" localName=\"" + step.getLocalName() + "\">");
        Iterator iter = step.getPredicates().iterator();
        ++this.tabIndex;
        while (iter.hasNext()) {
            Predicate predicate = (Predicate)iter.next();
            predicate.accept(this);
        }
        --this.tabIndex;
        this.printLn("</NameStep>");
    }

    public void visit(ProcessingInstructionNodeStep step) {
        this.printLn("<ProcessingInstructionNodeStep name=\"" + step.getName() + "\" axis=\"" + step.getAxis() + ">");
        ++this.tabIndex;
        this.handlePredicates(step.getPredicates());
        --this.tabIndex;
        this.printLn("</ProcessingInstructionNodeStep>");
    }

    public void visit(AllNodeStep step) {
        this.printLn("<AllNodeStep>");
        ++this.tabIndex;
        this.handlePredicates(step.getPredicates());
        --this.tabIndex;
        this.printLn("</AllNodeStep>");
    }

    public void visit(TextNodeStep step) {
        this.printLn("<TextNodeStep>");
        ++this.tabIndex;
        this.handlePredicates(step.getPredicates());
        --this.tabIndex;
        this.printLn("</TextNodeStep>");
    }

    public void visit(CommentNodeStep step) {
        this.printLn("<CommentNodeStep>");
        ++this.tabIndex;
        this.handlePredicates(step.getPredicates());
        --this.tabIndex;
        this.printLn("</CommentNodeStep>");
    }

    public void visit(Predicate predicate) {
        this.printLn("<Predicate>");
        ++this.tabIndex;
        predicate.getExpr().accept(this);
        --this.tabIndex;
        this.printLn("</Predicate>");
    }

    protected void printLn(String str) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.tabIndex; ++i) {
            buffer.append("\t");
        }
        buffer.append(str);
        this.printer.println(buffer.toString());
    }

    protected void handlePredicates(List predicates) {
        if (predicates != null) {
            Iterator iter = predicates.iterator();
            while (iter.hasNext()) {
                ((Predicate)iter.next()).accept(this);
            }
        }
    }
}

