/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdf.impl;

import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFPageTree;
import com.adobe.internal.pdfedit.PDEContents;
import com.adobe.internal.pdfedit.PDEWord;
import com.adobe.pdf.impl.PDFWordImpl;
import java.util.ListIterator;

public class PDFWordIterator
implements ListIterator {
    private PDFDocument doc;
    private PDFPageTree pages;
    private int pageIndex;
    private int pageCount;
    private PDEContents contents;
    private int wordIndex;
    private ListIterator wordIter;

    public PDFWordIterator(PDFDocument pDFDocument) {
        this.doc = pDFDocument;
        this.pages = pDFDocument.requirePages();
        this.pageCount = this.pages.size();
        this.pageIndex = 0;
        this.wordIndex = 0;
        this.setupPage();
    }

    boolean hasNextPage() {
        return this.pageIndex < this.pageCount - 1;
    }

    void nextPage() {
        ++this.pageIndex;
        this.setupPage();
    }

    boolean hasPreviousPage() {
        return this.pageIndex > 0;
    }

    void previousPage() {
        --this.pageIndex;
        this.setupPage();
    }

    void setupPage() {
        this.contents = new PDEContents(this.pages.getPage(this.pageIndex));
        this.wordIter = this.contents.getWordList().listIterator();
    }

    public int nextIndex() {
        return this.wordIndex + 1;
    }

    public int previousIndex() {
        if (this.wordIndex > 0) {
            return this.wordIndex - 1;
        }
        return -1;
    }

    public boolean hasNext() {
        if (this.wordIter.hasNext()) {
            return true;
        }
        if (this.hasNextPage()) {
            this.nextPage();
            return this.hasNext();
        }
        return false;
    }

    public boolean hasPrevious() {
        if (this.wordIter.hasPrevious()) {
            return true;
        }
        if (this.hasPreviousPage()) {
            this.previousPage();
            return this.hasPrevious();
        }
        return false;
    }

    public Object next() {
        if (this.hasNext()) {
            return new PDFWordImpl((PDEWord)this.wordIter.next());
        }
        return null;
    }

    public Object previous() {
        if (this.hasPrevious()) {
            return new PDFWordImpl((PDEWord)this.wordIter.previous());
        }
        return null;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void add(Object object) {
        throw new UnsupportedOperationException();
    }

    public void set(Object object) {
        throw new UnsupportedOperationException();
    }
}

