/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdf.impl;

import com.adobe.internal.pdf.PDFEmbeddedFile;
import com.adobe.internal.pdf.PDFFileSpecification;
import com.adobe.internal.pdf.PDFInteractiveForm;
import com.adobe.internal.pdf.PDFPage;
import com.adobe.internal.pdf.PDFPageTree;
import com.adobe.internal.pdf.PDFResources;
import com.adobe.internal.pdf.PDFXObject;
import com.adobe.internal.pdf.PDFXObjectForm;
import com.adobe.internal.pdf.PDFXObjectImage;
import com.adobe.internal.pdf.PDFXObjectMap;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.OutputByteBuffer;
import com.adobe.internal.pdf.cos.util.exceptions.PDFIOException;
import com.adobe.internal.xdp.XDP2PDFReader;
import com.adobe.internal.xfdf.XFDFObject;
import com.adobe.pdf.FileAttachment;
import com.adobe.pdf.FormDataFormat;
import com.adobe.pdf.FormType;
import com.adobe.pdf.PDFDocument;
import com.adobe.pdf.PDFFactory;
import com.adobe.pdf.exceptions.PDFException;
import com.adobe.pdf.exceptions.XDPException;
import com.adobe.pdf.exceptions.XFDFException;
import com.adobe.pdf.exceptions.XFDFParseException;
import com.adobe.pdf.impl.PDFImageImpl;
import com.adobe.pdf.impl.PDFWordIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class PDFDocumentImpl
implements PDFDocument {
    private com.adobe.internal.pdf.PDFDocument pdfDocument;

    public PDFDocumentImpl(InputStream inputStream) throws IOException, PDFException {
        ByteStream byteStream = new ByteStream(inputStream);
        if (byteStream.limit() <= 0L) {
            throw new IllegalArgumentException("Empty InputStream");
        }
        byte[] byArray = new byte[]{37, 80, 68, 70, 45};
        if (byteStream.exists(byArray, 1024L)) {
            this.pdfDocument = new com.adobe.internal.pdf.PDFDocument(byteStream);
        } else {
            XDP2PDFReader xDP2PDFReader = new XDP2PDFReader();
            this.pdfDocument = xDP2PDFReader.createFromXDP(byteStream);
        }
    }

    public String getVersion() throws PDFException {
        return this.pdfDocument.getVersion();
    }

    public int getNumberOfPages() throws PDFException {
        PDFPageTree pDFPageTree = this.pdfDocument.requirePages();
        if (pDFPageTree == null) {
            return 0;
        }
        return pDFPageTree.size();
    }

    public FormType getFormType() throws PDFException {
        PDFInteractiveForm pDFInteractiveForm = this.pdfDocument.getInteractiveForm();
        if (pDFInteractiveForm == null) {
            return FormType.NOT_A_FORM;
        }
        if (pDFInteractiveForm.hasXFA()) {
            return FormType.XML_FORM;
        }
        return FormType.ACROFORM;
    }

    public InputStream save() throws IOException, PDFException {
        return this.pdfDocument.save(false);
    }

    public InputStream saveAsXDP() throws IOException, PDFException {
        try {
            return this.pdfDocument.saveAsXDP();
        }
        catch (TransformerException transformerException) {
            throw new XDPException(transformerException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new XDPException(sAXException.getMessage());
        }
        catch (PDFIOException pDFIOException) {
            throw new IOException(pDFIOException.getMessage());
        }
    }

    public InputStream exportXMP() throws IOException, PDFException {
        return this.pdfDocument.exportXMP();
    }

    public void importXMP(InputStream inputStream) throws IOException, PDFException {
        ByteStream byteStream = new ByteStream(inputStream);
        if (byteStream.limit() <= 0L) {
            throw new IllegalArgumentException("Empty InputStream");
        }
        this.pdfDocument.importXMP(byteStream);
    }

    public void importFormData(InputStream inputStream) throws IOException, PDFException {
        PDFInteractiveForm pDFInteractiveForm = this.pdfDocument.getInteractiveForm();
        if (pDFInteractiveForm == null) {
            return;
        }
        ByteStream byteStream = new ByteStream(inputStream);
        if (byteStream.limit() <= 0L) {
            throw new IllegalArgumentException("Empty InputStream");
        }
        byte[] byArray = new byte[]{120, 102, 100, 102};
        boolean bl = true;
        if (byteStream.exists(byArray, byteStream.limit())) {
            bl = false;
        }
        try {
            if (bl) {
                pDFInteractiveForm.importXFAData(byteStream);
            } else {
                pDFInteractiveForm.importFormData(byteStream);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XFDFException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new XFDFException(sAXException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new XFDFException(transformerException.getMessage());
        }
    }

    public InputStream exportFormData(FormDataFormat formDataFormat) throws IOException, PDFException {
        PDFInteractiveForm pDFInteractiveForm = this.pdfDocument.getInteractiveForm();
        if (pDFInteractiveForm == null) {
            return null;
        }
        try {
            if (formDataFormat == FormDataFormat.XFDF) {
                OutputByteBuffer outputByteBuffer = new OutputByteBuffer();
                pDFInteractiveForm.exportFormData(outputByteBuffer);
                return new ByteStream(outputByteBuffer.getBuffer());
            }
            if (pDFInteractiveForm.hasXFA()) {
                return pDFInteractiveForm.exportXFAData();
            }
        }
        catch (SAXException sAXException) {
            throw new XFDFException(sAXException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new XFDFException(transformerException.getMessage());
        }
        return null;
    }

    public void importFileAttachment(byte[] byArray, FileAttachment fileAttachment) throws IOException, PDFException {
        ASString aSString = new ASString(byArray);
        ASString aSString2 = new ASString(fileAttachment.getFilename());
        InputStream inputStream = fileAttachment.getData();
        PDFEmbeddedFile pDFEmbeddedFile = PDFEmbeddedFile.create(this.pdfDocument, null, inputStream, true);
        PDFFileSpecification pDFFileSpecification = PDFFileSpecification.create(this.pdfDocument, aSString2, pDFEmbeddedFile);
        this.pdfDocument.replaceEmbeddedFile(aSString, pDFFileSpecification);
    }

    public byte[][] getFileAttachmentNames() throws PDFException {
        List list = this.pdfDocument.getEmbeddedFileKeys();
        if (list == null) {
            return null;
        }
        int n = list.size();
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ASString aSString = (ASString)list.get(i);
            byArrayArray[i] = aSString.getBytes();
        }
        return byArrayArray;
    }

    public FileAttachment exportFileAttachment(byte[] byArray) throws IOException, PDFException {
        ASString aSString = new ASString(byArray);
        PDFFileSpecification pDFFileSpecification = this.pdfDocument.getEmbeddedFile(aSString);
        if (pDFFileSpecification == null) {
            return null;
        }
        PDFEmbeddedFile pDFEmbeddedFile = pDFFileSpecification.getEmbeddedFile();
        if (pDFEmbeddedFile == null) {
            return null;
        }
        return PDFFactory.newFileAttachment(pDFEmbeddedFile.getFileData(), pDFFileSpecification.getFilename().asString(), null);
    }

    public void deleteFileAttachment(byte[] byArray) throws PDFException {
        ASString aSString = new ASString(byArray);
        this.pdfDocument.deleteEmbeddedFile(aSString);
    }

    public void importAnnotations(InputStream inputStream) throws IOException, PDFException {
        ByteStream byteStream = new ByteStream(inputStream);
        if (byteStream.limit() <= 0L) {
            throw new IllegalArgumentException("Empty InputStream");
        }
        try {
            XFDFObject.importAnnotations(byteStream, this.pdfDocument);
        }
        catch (SAXException sAXException) {
            throw new XFDFParseException(sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XFDFException(parserConfigurationException.getMessage());
        }
    }

    public InputStream exportAnnotations() throws IOException, PDFException {
        OutputByteBuffer outputByteBuffer = new OutputByteBuffer();
        try {
            XFDFObject.exportAnnotations(this.pdfDocument, outputByteBuffer);
        }
        catch (SAXException sAXException) {
            throw new XFDFException(sAXException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new XFDFException(transformerException.getMessage());
        }
        return new ByteStream(outputByteBuffer.getBuffer());
    }

    public void deleteAnnotations() throws PDFException {
        XFDFObject.deleteAnnotations(this.pdfDocument);
    }

    private void getImages(PDFResources pDFResources, ArrayList arrayList) throws PDFException {
        if (pDFResources == null) {
            return;
        }
        PDFXObjectMap pDFXObjectMap = pDFResources.getXObjectMap();
        if (pDFXObjectMap == null) {
            return;
        }
        Iterator iterator = pDFXObjectMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            ASName aSName = (ASName)iterator.next();
            PDFXObject pDFXObject = (PDFXObject)pDFXObjectMap.get((Object)aSName);
            if (pDFXObject instanceof PDFXObjectImage) {
                object = new PDFImageImpl((PDFXObjectImage)pDFXObject);
                arrayList.add(object);
                continue;
            }
            if (!(pDFXObject instanceof PDFXObjectForm)) continue;
            object = (PDFXObjectForm)pDFXObject;
            this.getImages(((PDFXObjectForm)object).getResources(), arrayList);
        }
    }

    public List getImages() throws PDFException {
        ArrayList arrayList = new ArrayList();
        PDFPageTree pDFPageTree = this.pdfDocument.requirePages();
        int n = this.pdfDocument.requirePages().size();
        for (int i = 0; i < n; ++i) {
            PDFResources pDFResources;
            PDFPage pDFPage = pDFPageTree.getPage(i);
            if (pDFPage == null || (pDFResources = pDFPage.getResources()) == null) continue;
            this.getImages(pDFResources, arrayList);
        }
        return arrayList;
    }

    public ListIterator getWords() throws PDFException {
        return new PDFWordIterator(this.pdfDocument);
    }
}

