/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.internal.pdf.PDFAnnotation;
import com.adobe.internal.pdf.PDFAnnotationList;
import com.adobe.internal.pdf.PDFAnnotationPopup;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFInteractiveForm;
import com.adobe.internal.pdf.PDFPage;
import com.adobe.internal.pdf.PDFPageTree;
import com.adobe.internal.pdf.cos.util.Utility;
import com.adobe.internal.xfdf.PDF2XFDFAnnotationsReader;
import com.adobe.internal.xfdf.PDF2XFDFFormsReader;
import com.adobe.internal.xfdf.XFDF2PDFAnnotationReader;
import com.adobe.internal.xfdf.XFDF2PDFFormReader;
import com.adobe.internal.xfdf.XFDFAnnotation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XFDFObject {
    static final String NAMESPACES_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";

    XFDFObject() {
    }

    public static void exportAnnotations(PDFDocument pDFDocument, OutputStream outputStream) throws SAXException, TransformerConfigurationException, TransformerException {
        Utility.transformToXML(new PDF2XFDFAnnotationsReader(pDFDocument), null, outputStream);
    }

    public static void importAnnotations(InputStream inputStream, PDFDocument pDFDocument) throws SAXParseException, SAXException, ParserConfigurationException, IOException {
        XFDF2PDFAnnotationReader xFDF2PDFAnnotationReader = new XFDF2PDFAnnotationReader(pDFDocument);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(true);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.getXMLReader().setFeature(NAMESPACES_PREFIXES, true);
        sAXParser.parse(inputStream, (DefaultHandler)xFDF2PDFAnnotationReader);
    }

    public static void deleteAnnotations(PDFDocument pDFDocument) {
        PDFPage pDFPage;
        PDFPageTree pDFPageTree = pDFDocument.requirePages();
        int n = 0;
        while ((pDFPage = pDFPageTree.getPage(n++)) != null) {
            PDFAnnotationList pDFAnnotationList = pDFPage.getAnnotationList();
            if (pDFAnnotationList == null) continue;
            int n2 = 0;
            while (n2 < pDFAnnotationList.size()) {
                int n3 = pDFAnnotationList.size();
                PDFAnnotation pDFAnnotation = (PDFAnnotation)pDFAnnotationList.get(n2);
                if (pDFAnnotation == null) {
                    ++n2;
                    continue;
                }
                if (XFDFAnnotation.createXFDFAnnotation(pDFAnnotation) != null) {
                    if (pDFAnnotation.hasPopup()) {
                        PDFAnnotationPopup pDFAnnotationPopup = pDFAnnotation.getAnnotationPopup();
                        int n4 = pDFAnnotationList.indexOf(pDFAnnotationPopup);
                        pDFAnnotationList.remove(pDFAnnotationPopup);
                        if (n4 < n2) {
                            --n2;
                        }
                    }
                    pDFAnnotationList.remove(n2);
                    --n2;
                }
                ++n2;
            }
            if (pDFAnnotationList.size() == 0) {
                pDFPage.deleteAnnotationList();
                continue;
            }
            pDFPage.setAnnotationList(pDFAnnotationList);
        }
    }

    public static void exportFormData(PDFInteractiveForm pDFInteractiveForm, OutputStream outputStream) throws SAXException, TransformerConfigurationException, TransformerException {
        Utility.transformToXML(new PDF2XFDFFormsReader(pDFInteractiveForm), null, outputStream);
    }

    public static void importFormData(InputStream inputStream, PDFInteractiveForm pDFInteractiveForm) throws SAXParseException, SAXException, ParserConfigurationException, IOException {
        XFDF2PDFFormReader xFDF2PDFFormReader = new XFDF2PDFFormReader(pDFInteractiveForm);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(true);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(inputStream, (DefaultHandler)xFDF2PDFFormReader);
    }
}

