/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.internal.pdf.PDFField;
import com.adobe.internal.pdf.PDFFieldNode;
import com.adobe.internal.pdf.cos.util.exceptions.PDFInteractiveFormException;
import java.util.ArrayList;
import java.util.List;

public class XFDFFieldList
extends ArrayList {
    private String name;
    private XFDFFieldList parent;

    XFDFFieldList(List list, String string) {
        this.name = string;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.placeXFDFField(list.get(i));
            }
        }
    }

    XFDFFieldList(List list) {
        this(list, "");
    }

    XFDFFieldList(String string) {
        this(null, string);
    }

    private void placeXFDFField(Object object) {
        XFDFFieldList xFDFFieldList;
        Object object2;
        if (object instanceof PDFField) {
            PDFField pDFField = (PDFField)object;
            object2 = pDFField;
            String string = pDFField.getPartialName();
            if (string == null) {
                throw new PDFInteractiveFormException("Expected a partial field name");
            }
            String string2 = XFDFFieldList.getBaseFieldName(string);
            xFDFFieldList = this.getParentField(string);
            if (object instanceof PDFFieldNode) {
                object2 = new XFDFFieldList(((PDFFieldNode)object).getFieldList(), string2);
            }
        } else {
            throw new PDFInteractiveFormException("Expected a field");
        }
        xFDFFieldList.add(object2);
    }

    static String getBaseFieldName(String string) {
        String string2 = string;
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    private XFDFFieldList getParentField(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return this;
        }
        return this.getFieldByName(string.substring(0, n));
    }

    XFDFFieldList getFieldByName(String string) {
        XFDFFieldList xFDFFieldList = this.getParentField(string);
        String string2 = XFDFFieldList.getBaseFieldName(string);
        XFDFFieldList xFDFFieldList2 = xFDFFieldList.findFieldByName(string);
        if (xFDFFieldList2 != null) {
            return xFDFFieldList2;
        }
        XFDFFieldList xFDFFieldList3 = new XFDFFieldList(string2);
        xFDFFieldList.add(xFDFFieldList3);
        return xFDFFieldList3;
    }

    XFDFFieldList findFieldByName(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.size(); ++i) {
            Object e = this.get(i);
            if (!(e instanceof XFDFFieldList) || !string.equals(((XFDFFieldList)e).name)) continue;
            return (XFDFFieldList)e;
        }
        return null;
    }

    public boolean add(Object object) {
        super.add(object);
        if (object instanceof XFDFFieldList) {
            ((XFDFFieldList)object).parent = this;
        }
        return true;
    }

    String getName() {
        return this.name;
    }

    XFDFFieldList getParent() {
        return this.parent;
    }
}

