/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.pdf.exceptions.XFDFException;
import com.adobe.pdf.exceptions.XFDFParseException;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class XFDFCopyBlob2String
implements XMLReader {
    ContentHandler handler;
    static final String nsu = "";
    static final Attributes nullAtts = new AttributesImpl();
    static final String rootElement = "xfdf";
    static final String secondRoot = "annots";
    private StringWriter blob = null;
    private StringBuffer rawContent = null;

    public XFDFCopyBlob2String() {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            this.blob = new StringWriter();
            transformer.transform(new SAXSource(this, new InputSource()), new StreamResult(this.blob));
        }
        catch (Exception exception) {
            throw new XFDFParseException("Error in the imported XML blob");
        }
    }

    void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.handler.startElement(string, string2, string3, attributes);
    }

    void endElement(String string, String string2, String string3) throws SAXException {
        this.handler.endElement(string, string2, string3);
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (this.handler == null) {
            throw new XFDFException("No content handler");
        }
    }

    void copyCharacters(char[] cArray, int n, int n2) throws SAXException {
        if (this.handler == null) {
            throw new XFDFException("Wrong structure of XFDF");
        }
        if (!this.allSpaces(cArray, n, n2)) {
            this.handler.characters(cArray, n, n2);
            if (this.rawContent == null) {
                this.rawContent = new StringBuffer(n2);
            }
            this.rawContent.append(cArray, n, n2);
        }
    }

    String getBlob() {
        return this.blob != null ? this.blob.toString() : null;
    }

    String getRawContent() {
        return this.rawContent != null ? this.rawContent.toString() : null;
    }

    private boolean allSpaces(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (Character.isWhitespace(cArray[i + n])) continue;
            return false;
        }
        return true;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.handler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(String string) throws IOException, SAXException {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public Object getProperty(String string) {
        return null;
    }

    public void setProperty(String string, Object object) {
    }

    public void setFeature(String string, boolean bl) {
    }

    public boolean getFeature(String string) {
        return false;
    }
}

