/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.internal.pdf.PDFAnnotation;
import com.adobe.internal.pdf.PDFAnnotationText;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.xfdf.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XFDFAnnotationText
extends XFDFAnnotation {
    static final String ATTR_ICON = "icon";
    static final String ATTR_STATE = "state";
    static final String ATTR_STATEMODEL = "statemodel";
    static final String ATTR_INREPLYTO = "inreplyto";
    static final String ELEM_TEXT = "text";

    public XFDFAnnotationText(PDFAnnotationText pDFAnnotationText) {
        this.pdfAnnot = pDFAnnotationText;
        this.pdfDoc = null;
    }

    XFDFAnnotationText(PDFDocument pDFDocument) {
        this.pdfDoc = pDFDocument;
        this.pdfAnnot = null;
    }

    void transformToXFDF(ContentHandler contentHandler, int n) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.addCommonXFDFAttributes(attributesImpl, n);
        this.addMarkupXFDFAttributes(attributesImpl);
        CosDictionary cosDictionary = ((PDFAnnotationText)this.pdfAnnot).getInReplyTo();
        if (cosDictionary != null && cosDictionary.containsKey(ASName.k_NM)) {
            attributesImpl.addAttribute("", ATTR_INREPLYTO, ATTR_INREPLYTO, "string", ((PDFAnnotationText)this.pdfAnnot).getInReplyToName());
        }
        if (this.pdfAnnot.hasIcon()) {
            attributesImpl.addAttribute("", ATTR_ICON, ATTR_ICON, "string", ((PDFAnnotationText)this.pdfAnnot).getIconName());
        }
        if (this.pdfAnnot.dictionaryContains(ASName.k_State)) {
            attributesImpl.addAttribute("", ATTR_STATE, ATTR_STATE, "string", ((PDFAnnotationText)this.pdfAnnot).getState());
        }
        if (this.pdfAnnot.dictionaryContains(ASName.k_StateModel)) {
            attributesImpl.addAttribute("", ATTR_STATEMODEL, ATTR_STATEMODEL, "string", ((PDFAnnotationText)this.pdfAnnot).getStateModel());
        }
        contentHandler.startElement("", ELEM_TEXT, ELEM_TEXT, attributesImpl);
        if (!this.createXFDFRichContent(contentHandler)) {
            this.createXFDFContent(contentHandler);
        }
        this.createXFDFPopupElement(contentHandler);
        contentHandler.endElement("", ELEM_TEXT, ELEM_TEXT);
        contentHandler.characters(END_ELEM, 0, 1);
    }

    PDFAnnotation createPDFAnnotation(Attributes attributes) {
        if (this.pdfDoc == null) {
            return null;
        }
        int n = -1;
        PDFAnnotationText pDFAnnotationText = PDFAnnotationText.create(this.pdfDoc);
        this.pdfAnnot = null;
        n = this.fillCommonAttributes(pDFAnnotationText, attributes);
        if (n >= 0) {
            int n2;
            this.fillMarkupAttributes(pDFAnnotationText, attributes);
            int n3 = this.findAttribute(ATTR_ICON, attributes);
            if (n3 != -1) {
                pDFAnnotationText.setIconName(attributes.getValue(n3));
            }
            if ((n2 = this.findAttribute(ATTR_STATE, attributes)) != -1) {
                pDFAnnotationText.setState(attributes.getValue(n2));
            }
            if ((n2 = this.findAttribute(ATTR_STATEMODEL, attributes)) != -1) {
                pDFAnnotationText.setStateModel(attributes.getValue(n2));
            }
            if (this.setAnnotation(pDFAnnotationText, n)) {
                this.pdfAnnot = pDFAnnotationText;
                this.curPage = n;
            }
        }
        return this.pdfAnnot;
    }

    protected String getInReplyTo(Attributes attributes) {
        int n = this.findAttribute(ATTR_INREPLYTO, attributes);
        return n != -1 ? attributes.getValue(n) : null;
    }
}

