/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.internal.pdf.PDFAnnotation;
import com.adobe.internal.pdf.PDFAnnotationSound;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.cos.util.Utility;
import com.adobe.internal.xfdf.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XFDFAnnotationSound
extends XFDFAnnotation {
    static final String[] pdfEncodings = new String[]{"Raw", "Signed", "muLaw", "ALaw"};
    static final String[] xfdfEncodings = new String[]{"raw", "signed", "mulaw", "alaw"};
    static final String ATTR_ICON = "icon";
    static final String ATTR_BITS = "bits";
    static final String ATTR_RATE = "rate";
    static final String ATTR_CHANNELS = "channels";
    static final String ATTR_ENCODING = "encoding";
    static final String ELEM_SOUND = "sound";

    XFDFAnnotationSound(PDFAnnotationSound pDFAnnotationSound) {
        this.pdfAnnot = pDFAnnotationSound;
        this.pdfDoc = null;
    }

    XFDFAnnotationSound(PDFDocument pDFDocument) {
        this.pdfDoc = pDFDocument;
        this.pdfAnnot = null;
    }

    void transformToXFDF(ContentHandler contentHandler, int n) throws SAXException {
        String string;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.addCommonXFDFAttributes(attributesImpl, n);
        this.addMarkupXFDFAttributes(attributesImpl);
        if (this.pdfAnnot.hasIcon()) {
            attributesImpl.addAttribute("", ATTR_ICON, ATTR_ICON, "string", this.pdfAnnot.getIcon());
        }
        if (((PDFAnnotationSound)this.pdfAnnot).hasBits()) {
            attributesImpl.addAttribute("", ATTR_BITS, ATTR_BITS, "string", Integer.toString(((PDFAnnotationSound)this.pdfAnnot).getBits()));
        }
        if (((PDFAnnotationSound)this.pdfAnnot).hasChannels()) {
            attributesImpl.addAttribute("", ATTR_CHANNELS, ATTR_CHANNELS, "string", Integer.toString(((PDFAnnotationSound)this.pdfAnnot).getChannels()));
        }
        if (((PDFAnnotationSound)this.pdfAnnot).hasRate()) {
            attributesImpl.addAttribute("", ATTR_RATE, ATTR_RATE, "string", Double.toString(((PDFAnnotationSound)this.pdfAnnot).getRate()));
        }
        if (((PDFAnnotationSound)this.pdfAnnot).hasEncoding() && (string = Utility.substituteStringFromArray(((PDFAnnotationSound)this.pdfAnnot).getEncoding(), pdfEncodings, xfdfEncodings)) != null) {
            attributesImpl.addAttribute("", ATTR_ENCODING, ATTR_ENCODING, "string", string);
        }
        contentHandler.startElement("", ELEM_SOUND, ELEM_SOUND, attributesImpl);
        if (!this.createXFDFRichContent(contentHandler)) {
            this.createXFDFContent(contentHandler);
        }
        this.createXFDFStreamData(contentHandler, ((PDFAnnotationSound)this.pdfAnnot).getDataStream());
        contentHandler.endElement("", ELEM_SOUND, ELEM_SOUND);
        contentHandler.characters(END_ELEM, 0, 1);
    }

    PDFAnnotation createPDFAnnotation(Attributes attributes) {
        if (this.pdfDoc == null) {
            return null;
        }
        int n = -1;
        PDFAnnotationSound pDFAnnotationSound = PDFAnnotationSound.create(this.pdfDoc);
        this.pdfAnnot = null;
        n = this.fillCommonAttributes(pDFAnnotationSound, attributes);
        if (n >= 0) {
            String string;
            this.fillMarkupAttributes(pDFAnnotationSound, attributes);
            int n2 = this.findAttribute(ATTR_BITS, attributes);
            if (n2 >= 0) {
                pDFAnnotationSound.setBits(Integer.parseInt(attributes.getValue(n2)));
            }
            if ((n2 = this.findAttribute(ATTR_ICON, attributes)) >= 0) {
                pDFAnnotationSound.setIcon(attributes.getValue(n2));
            }
            if ((n2 = this.findAttribute(ATTR_CHANNELS, attributes)) >= 0) {
                pDFAnnotationSound.setChannels(Integer.parseInt(attributes.getValue(n2)));
            }
            if ((n2 = this.findAttribute(ATTR_RATE, attributes)) >= 0) {
                pDFAnnotationSound.setRate(Double.parseDouble(attributes.getValue(n2)));
            }
            if ((n2 = this.findAttribute(ATTR_ENCODING, attributes)) >= 0 && (string = Utility.substituteStringFromArray(attributes.getValue(n2), xfdfEncodings, pdfEncodings)) != null) {
                pDFAnnotationSound.setEncoding(string);
            }
            if (this.setAnnotation(pDFAnnotationSound, n)) {
                this.pdfAnnot = pDFAnnotationSound;
            }
        }
        return this.pdfAnnot;
    }
}

