/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.internal.pdf.PDFAnnotation;
import com.adobe.internal.pdf.PDFAnnotationPopup;
import com.adobe.internal.xfdf.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XFDFAnnotationPopup
extends XFDFAnnotation {
    static final String ELEM_POPUP = "popup";
    static final String ATTR_OPEN = "open";

    XFDFAnnotationPopup(PDFAnnotationPopup pDFAnnotationPopup) {
        this.pdfAnnot = pDFAnnotationPopup;
        this.pdfDoc = null;
    }

    XFDFAnnotationPopup(XFDFAnnotation xFDFAnnotation) {
        this.pdfAnnot = xFDFAnnotation.pdfAnnot;
        this.pdfDoc = this.pdfAnnot.getPDFDocument();
        this.curPage = xFDFAnnotation.getCurPage();
    }

    void transformToXFDF(ContentHandler contentHandler, int n) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.addCommonXFDFAttributes(attributesImpl, -1);
        if (((PDFAnnotationPopup)this.pdfAnnot).hasOpenState()) {
            attributesImpl.addAttribute("", ATTR_OPEN, ATTR_OPEN, "string", ((PDFAnnotationPopup)this.pdfAnnot).getOpenState() ? "yes" : "no");
        }
        contentHandler.startElement("", ELEM_POPUP, ELEM_POPUP, attributesImpl);
        contentHandler.endElement("", ELEM_POPUP, ELEM_POPUP);
    }

    PDFAnnotation createPDFAnnotation(Attributes attributes) {
        if (this.pdfDoc == null) {
            return null;
        }
        PDFAnnotationPopup pDFAnnotationPopup = null;
        if (this.pdfAnnot != null) {
            pDFAnnotationPopup = PDFAnnotationPopup.create(this.pdfDoc);
            this.fillCommonAttributes(pDFAnnotationPopup, attributes);
            int n = this.findAttribute(ATTR_OPEN, attributes);
            if (n != -1) {
                pDFAnnotationPopup.setOpenState(attributes.getValue(n));
            }
            pDFAnnotationPopup.setParent(this.pdfAnnot);
            this.setAnnotation(pDFAnnotationPopup, this.curPage);
            this.pdfAnnot.setAnnotationPopup(pDFAnnotationPopup);
        }
        return pDFAnnotationPopup;
    }
}

