/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.internal.pdf.PDFActions;
import com.adobe.internal.pdf.PDFAnnotation;
import com.adobe.internal.pdf.PDFAnnotationLink;
import com.adobe.internal.pdf.PDFDestination;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.util.PDFDocEncoding;
import com.adobe.internal.pdf.cos.util.Utility;
import com.adobe.internal.xfdf.XFDFAnnotation;
import java.io.Serializable;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XFDFAnnotationLink
extends XFDFAnnotation {
    private boolean inDestination = false;
    private static final String[] pdfHighlight = new String[]{"N", "I", "O", "P"};
    private static final String[] xfdfHighlight = new String[]{"None", "Invert", "Outline", "Push"};
    static final String ATTR_HIGHLIGHT = "Highlight";
    static final String ATTR_NAME = "Name";
    static final String ATTR_PAGE = "Page";
    static final String ATTR_LEFT = "Left";
    static final String ATTR_TOP = "Top";
    static final String ATTR_ZOOM = "Zoom";
    static final String ATTR_RIGHT = "Right";
    static final String ATTR_BOTTOM = "Bottom";
    static final String ATTR_ISMAP = "IsMap";
    static final String ATTR_NEW_WINDOW = "NewWindow";
    static final String ATTR_ORIG_NAME = "OriginalName";
    static final String ATTR_HCORNER = "HCornerRadius";
    static final String ATTR_VCORNER = "VCornerRadius";
    static final String ATTR_WIDTH = "Width";
    static final String ATTR_DASH_PATTERN = "DashPattern";
    static final String ELEM_LINK = "link";
    static final String ELEM_DESTS = "Dest";
    static final String ELEM_DEST_XYZ = "XYZ";
    static final String ELEM_DEST_Fit = "Fit";
    static final String ELEM_DEST_FitH = "FitH";
    static final String ELEM_DEST_FitV = "FitV";
    static final String ELEM_DEST_FitR = "FitR";
    static final String ELEM_DEST_FitB = "FitB";
    static final String ELEM_DEST_FitBH = "FitBH";
    static final String ELEM_DEST_FitBV = "FitBV";
    static final String ELEM_ACTIONS = "OnActivation";
    static final String ELEM_ACTION = "Action";
    static final String ELEM_URI = "URI";
    static final String ELEM_GOTO = "GoTo";
    static final String ELEM_GOTOR = "GoToR";
    static final String ELEM_NAMED = "Named";
    static final String ELEM_LAUNCH = "Launch";
    static final String ELEM_FILE = "File";
    static final String ELEM_BORDER = "BorderStyleAlt";

    public XFDFAnnotationLink(PDFAnnotationLink pDFAnnotationLink) {
        this.pdfAnnot = pDFAnnotationLink;
        this.pdfDoc = null;
    }

    XFDFAnnotationLink(PDFDocument pDFDocument) {
        this.pdfDoc = pDFDocument;
        this.pdfAnnot = null;
    }

    boolean createXFDFDestination(ContentHandler contentHandler) throws SAXException {
        if (((PDFAnnotationLink)this.pdfAnnot).hasDestination()) {
            PDFDestination pDFDestination = ((PDFAnnotationLink)this.pdfAnnot).getDestination();
            return this.createXFDFDest(contentHandler, pDFDestination);
        }
        return false;
    }

    private void addNewWindow(PDFActions pDFActions, AttributesImpl attributesImpl) {
        String string = pDFActions.getNewWindow();
        if (string != null) {
            attributesImpl.addAttribute("", ATTR_NEW_WINDOW, ATTR_NEW_WINDOW, "string", string);
        }
    }

    private void createDestinationElement(PDFActions pDFActions, ContentHandler contentHandler) throws SAXException {
        PDFDestination pDFDestination = pDFActions.getDestination();
        if (pDFDestination != null) {
            this.createXFDFDest(contentHandler, pDFDestination);
        }
    }

    private boolean createXFDFDest(ContentHandler contentHandler, PDFDestination pDFDestination) throws SAXException {
        String string = null;
        boolean bl = false;
        AttributesImpl attributesImpl = new AttributesImpl();
        int n = pDFDestination.getType();
        if (n == 1) {
            string = ELEM_NAMED;
            attributesImpl.addAttribute("", ATTR_NAME, ATTR_NAME, "string", pDFDestination.getDestName());
            bl = true;
        } else if (n != 0) {
            String string2;
            String string3;
            String string4 = pDFDestination.getPage();
            if (string4 != null) {
                attributesImpl.addAttribute("", ATTR_PAGE, ATTR_PAGE, "string", string4);
                bl = true;
            }
            if ((string = pDFDestination.getTypeAsString()) == null) {
                return false;
            }
            switch (n) {
                case 2: 
                case 5: 
                case 6: 
                case 9: {
                    string3 = pDFDestination.getLeftOrTop();
                    if (string3 == null) break;
                    attributesImpl.addAttribute("", ATTR_LEFT, ATTR_LEFT, "string", string3);
                    bl = true;
                    break;
                }
                case 4: 
                case 8: {
                    string2 = pDFDestination.getLeftOrTop();
                    if (string2 == null) break;
                    attributesImpl.addAttribute("", ATTR_TOP, ATTR_TOP, "string", string2);
                    bl = true;
                }
            }
            if (n == 2) {
                string3 = pDFDestination.getTopOrBottom();
                if (string3 != null) {
                    attributesImpl.addAttribute("", ATTR_TOP, ATTR_TOP, "string", string3);
                    bl = true;
                }
                if ((string2 = pDFDestination.getZoomOrRight()) != null) {
                    attributesImpl.addAttribute("", ATTR_ZOOM, ATTR_ZOOM, "string", string2);
                    bl = true;
                }
            }
            if (n == 6) {
                String string5;
                string3 = pDFDestination.getTopOrBottom();
                if (string3 != null) {
                    attributesImpl.addAttribute("", ATTR_BOTTOM, ATTR_BOTTOM, "string", string3);
                    bl = true;
                }
                if ((string2 = pDFDestination.getZoomOrRight()) != null) {
                    attributesImpl.addAttribute("", ATTR_RIGHT, ATTR_RIGHT, "string", string2);
                    bl = true;
                }
                if ((string5 = pDFDestination.getTop()) != null) {
                    attributesImpl.addAttribute("", ATTR_TOP, ATTR_TOP, "string", string5);
                    bl = true;
                }
            }
        }
        if (bl) {
            contentHandler.startElement("", ELEM_DESTS, ELEM_DESTS, nullAttrs);
            contentHandler.startElement("", string, string, attributesImpl);
            contentHandler.endElement("", string, string);
            contentHandler.endElement("", ELEM_DESTS, ELEM_DESTS);
        }
        return bl;
    }

    boolean createXFDFFileName(ContentHandler contentHandler, String string) throws SAXException {
        if (string == null) {
            return false;
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", ATTR_ORIG_NAME, ATTR_ORIG_NAME, "string", string);
        contentHandler.startElement("", ELEM_FILE, ELEM_FILE, attributesImpl);
        contentHandler.endElement("", ELEM_FILE, ELEM_FILE);
        return true;
    }

    boolean createXFDFAction(ContentHandler contentHandler) throws SAXException {
        PDFActions pDFActions;
        int n;
        if (((PDFAnnotationLink)this.pdfAnnot).hasActions() && (n = (pDFActions = ((PDFAnnotationLink)this.pdfAnnot).getActions()).getType()) != 0) {
            AttributesImpl attributesImpl = new AttributesImpl();
            contentHandler.startElement("", ELEM_ACTIONS, ELEM_ACTIONS, nullAttrs);
            contentHandler.startElement("", ELEM_ACTION, ELEM_ACTION, nullAttrs);
            switch (n) {
                case 5: {
                    attributesImpl.addAttribute("", ATTR_NAME, ATTR_NAME, "string", pDFActions.getURI());
                    if (pDFActions.hasIsMap()) {
                        attributesImpl.addAttribute("", ATTR_ISMAP, ATTR_ISMAP, "string", Boolean.toString(pDFActions.getIsMap()));
                    }
                    contentHandler.startElement("", ELEM_URI, ELEM_URI, attributesImpl);
                    contentHandler.endElement("", ELEM_URI, ELEM_URI);
                    break;
                }
                case 1: {
                    this.addNewWindow(pDFActions, attributesImpl);
                    contentHandler.startElement("", ELEM_LAUNCH, ELEM_LAUNCH, attributesImpl);
                    this.createXFDFFileName(contentHandler, pDFActions.getFilename());
                    contentHandler.endElement("", ELEM_LAUNCH, ELEM_LAUNCH);
                    break;
                }
                case 2: {
                    contentHandler.startElement("", ELEM_GOTO, ELEM_GOTO, nullAttrs);
                    this.createDestinationElement(pDFActions, contentHandler);
                    contentHandler.endElement("", ELEM_GOTO, ELEM_GOTO);
                    break;
                }
                case 3: {
                    this.addNewWindow(pDFActions, attributesImpl);
                    contentHandler.startElement("", ELEM_GOTOR, ELEM_GOTOR, attributesImpl);
                    this.createDestinationElement(pDFActions, contentHandler);
                    this.createXFDFFileName(contentHandler, pDFActions.getFilename());
                    contentHandler.endElement("", ELEM_GOTOR, ELEM_GOTOR);
                    break;
                }
                case 4: {
                    if (!pDFActions.hasNamed()) break;
                    attributesImpl.addAttribute("", ATTR_NAME, ATTR_NAME, "string", pDFActions.getNamed().toString());
                    contentHandler.startElement("", ELEM_NAMED, ELEM_NAMED, attributesImpl);
                    contentHandler.endElement("", ELEM_NAMED, ELEM_NAMED);
                }
            }
            contentHandler.endElement("", ELEM_ACTION, ELEM_ACTION);
            contentHandler.endElement("", ELEM_ACTIONS, ELEM_ACTIONS);
            return true;
        }
        return false;
    }

    boolean createXFDFAltBorder(ContentHandler contentHandler) throws SAXException {
        CosArray cosArray;
        if (((PDFAnnotationLink)this.pdfAnnot).hasBorder() && (cosArray = ((PDFAnnotationLink)this.pdfAnnot).getBorder()).size() > 2) {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", ATTR_HCORNER, ATTR_HCORNER, "string", Double.toString(cosArray.getDouble(0)));
            attributesImpl.addAttribute("", ATTR_VCORNER, ATTR_VCORNER, "string", Double.toString(cosArray.getDouble(1)));
            attributesImpl.addAttribute("", ATTR_WIDTH, ATTR_WIDTH, "string", Double.toString(cosArray.getDouble(2)));
            if (cosArray.size() == 4) {
                attributesImpl.addAttribute("", ATTR_DASH_PATTERN, ATTR_DASH_PATTERN, "string", Utility.makeNumbersString(cosArray.getCosArray(3).getArrayDouble(), ","));
            }
            contentHandler.startElement("", ELEM_BORDER, ELEM_BORDER, attributesImpl);
            contentHandler.endElement("", ELEM_BORDER, ELEM_BORDER);
            return true;
        }
        return false;
    }

    void transformToXFDF(ContentHandler contentHandler, int n) throws SAXException {
        String string;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.addCommonXFDFAttributes(attributesImpl, n);
        this.addBorderStyleXFDFAttributes(attributesImpl, false);
        if (((PDFAnnotationLink)this.pdfAnnot).hasHighlight() && (string = Utility.substituteStringFromArray(((PDFAnnotationLink)this.pdfAnnot).getHighlight(), pdfHighlight, xfdfHighlight)) != null) {
            attributesImpl.addAttribute("", ATTR_HIGHLIGHT, ATTR_HIGHLIGHT, "string", string);
        }
        contentHandler.startElement("", ELEM_LINK, ELEM_LINK, attributesImpl);
        this.createXFDFContent(contentHandler);
        if (!this.createXFDFAction(contentHandler)) {
            this.createXFDFDestination(contentHandler);
        }
        this.createXFDFAltBorder(contentHandler);
        contentHandler.endElement("", ELEM_LINK, ELEM_LINK);
        contentHandler.characters(END_ELEM, 0, 1);
    }

    static String getPDFHighlight(String string) {
        return Utility.substituteStringFromArray(string, xfdfHighlight, pdfHighlight);
    }

    PDFAnnotation createPDFAnnotation(Attributes attributes) {
        if (this.pdfDoc == null) {
            return null;
        }
        int n = -1;
        PDFAnnotationLink pDFAnnotationLink = PDFAnnotationLink.create(this.pdfDoc);
        this.pdfAnnot = null;
        n = this.fillCommonAttributes(pDFAnnotationLink, attributes);
        if (n >= 0) {
            this.fillBorderStyleAttributes(pDFAnnotationLink, attributes);
            this.fillInteriorColorAttribute(pDFAnnotationLink, attributes);
            int n2 = this.findAttribute(ATTR_HIGHLIGHT, attributes);
            if (n2 >= 0) {
                pDFAnnotationLink.setHighlight(XFDFAnnotationLink.getPDFHighlight(attributes.getValue(n2)));
            }
            if (this.setAnnotation(pDFAnnotationLink, n)) {
                this.pdfAnnot = pDFAnnotationLink;
                this.curPage = n;
            }
        }
        return this.pdfAnnot;
    }

    boolean createAction(String string, Attributes attributes, PDFAnnotationLink pDFAnnotationLink) {
        if (pDFAnnotationLink == null || !pDFAnnotationLink.hasActions()) {
            return false;
        }
        PDFActions pDFActions = pDFAnnotationLink.getActions();
        pDFActions.setType(string);
        switch (pDFActions.getType()) {
            case 5: {
                int n = this.findAttribute(ATTR_NAME, attributes);
                if (n == -1) {
                    return false;
                }
                pDFActions.setURI(attributes.getValue(n));
                n = this.findAttribute(ATTR_ISMAP, attributes);
                if (n == -1) break;
                pDFActions.setIsMap(attributes.getValue(n));
                break;
            }
            case 1: {
                int n = this.findAttribute(ATTR_NEW_WINDOW, attributes);
                if (n == -1) break;
                pDFActions.setNewWindow(attributes.getValue(n));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                int n = this.findAttribute(ATTR_NEW_WINDOW, attributes);
                if (n == -1) break;
                pDFActions.setNewWindow(attributes.getValue(n));
                break;
            }
            case 4: {
                int n = this.findAttribute(ATTR_NAME, attributes);
                if (n == -1) break;
                pDFActions.setNamed(attributes.getValue(n));
            }
        }
        return true;
    }

    private PDFDestination createDest(String string, Attributes attributes) {
        if (string.equals(ELEM_NAMED)) {
            int n = this.findAttribute(ATTR_NAME, attributes);
            return n != -1 ? PDFDestination.create(this.pdfAnnot.getPDFDocument(), PDFDocEncoding.fromEscapeString(attributes.getValue(n))) : null;
        }
        PDFDestination pDFDestination = PDFDestination.create(this.pdfAnnot.getPDFDocument());
        int n = this.findAttribute(ATTR_PAGE, attributes);
        if (n == -1) {
            return null;
        }
        pDFDestination.setPage(attributes.getValue(n), false);
        pDFDestination.setType(string);
        n = this.findAttribute(ATTR_LEFT, attributes);
        if (n != -1) {
            pDFDestination.setLeftOrTop(attributes.getValue(n));
        }
        if ((n = this.findAttribute(ATTR_TOP, attributes)) != -1) {
            switch (pDFDestination.getType()) {
                case 4: 
                case 8: {
                    pDFDestination.setLeftOrTop(attributes.getValue(n));
                    break;
                }
                case 2: {
                    pDFDestination.setTopOrBottom(attributes.getValue(n));
                    break;
                }
                case 6: {
                    pDFDestination.setTop(attributes.getValue(n));
                }
            }
        }
        if ((n = this.findAttribute(ATTR_ZOOM, attributes)) != -1) {
            pDFDestination.setZoomOrRight(attributes.getValue(n));
        }
        if ((n = this.findAttribute(ATTR_BOTTOM, attributes)) != -1) {
            pDFDestination.setTopOrBottom(attributes.getValue(n));
        }
        if ((n = this.findAttribute(ATTR_RIGHT, attributes)) != -1) {
            pDFDestination.setZoomOrRight(attributes.getValue(n));
        }
        pDFDestination.finalizeArray();
        return pDFDestination;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean createDestination(String string, Attributes attributes) {
        this.setInDestination(false);
        if (this.pdfAnnot == null || !(this.pdfAnnot instanceof PDFAnnotationLink)) {
            return false;
        }
        PDFDestination pDFDestination = this.createDest(string, attributes);
        if (pDFDestination == null) {
            return false;
        }
        PDFAnnotationLink pDFAnnotationLink = (PDFAnnotationLink)this.pdfAnnot;
        if (pDFAnnotationLink.hasActions()) {
            PDFActions pDFActions = pDFAnnotationLink.getActions();
            if (pDFActions.getType() != 2 && pDFActions.getType() != 3) return false;
            pDFActions.setDestination(pDFDestination);
            return true;
        } else {
            pDFAnnotationLink.setDestination(pDFDestination);
        }
        return true;
    }

    boolean createAltBorder(Attributes attributes) {
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>(3);
        int n = this.findAttribute(ATTR_HCORNER, attributes);
        if (n == -1) {
            return false;
        }
        arrayList.add(0, new Double(attributes.getValue(n)));
        n = this.findAttribute(ATTR_VCORNER, attributes);
        if (n == -1) {
            return false;
        }
        arrayList.add(1, new Double(attributes.getValue(n)));
        n = this.findAttribute(ATTR_WIDTH, attributes);
        if (n == -1) {
            return false;
        }
        arrayList.add(2, new Double(attributes.getValue(n)));
        n = this.findAttribute(ATTR_DASH_PATTERN, attributes);
        if (n != -1) {
            arrayList.add(3, Utility.parseNumbers(attributes.getValue(n), ","));
        }
        ((PDFAnnotationLink)this.pdfAnnot).setBorder(arrayList);
        return true;
    }

    protected void setInDestination(boolean bl) {
        this.inDestination = bl;
    }

    protected boolean getInDestination() {
        return this.inDestination;
    }
}

