/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.internal.pdf.PDFAnnotation;
import com.adobe.internal.pdf.PDFAnnotationLine;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.util.Utility;
import com.adobe.internal.xfdf.XFDFAnnotation;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XFDFAnnotationLine
extends XFDFAnnotation {
    static final String ATTR_START = "start";
    static final String ATTR_END = "end";
    static final String ATTR_HEAD = "head";
    static final String ATTR_TAIL = "tail";
    static final String ELEM_LINE = "line";

    XFDFAnnotationLine(PDFAnnotationLine pDFAnnotationLine) {
        this.pdfAnnot = pDFAnnotationLine;
        this.pdfDoc = null;
    }

    XFDFAnnotationLine(PDFDocument pDFDocument) {
        this.pdfDoc = pDFDocument;
        this.pdfAnnot = null;
    }

    void transformToXFDF(ContentHandler contentHandler, int n) throws SAXException {
        CosArray cosArray;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.addCommonXFDFAttributes(attributesImpl, n);
        this.addMarkupXFDFAttributes(attributesImpl);
        this.addBorderStyleXFDFAttributes(attributesImpl, false);
        if (((PDFAnnotationLine)this.pdfAnnot).hasLineCoords() && (cosArray = ((PDFAnnotationLine)this.pdfAnnot).getLineCoords()).size() == 4) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cosArray.getDouble(0));
            stringBuffer.append(",");
            stringBuffer.append(cosArray.getDouble(1));
            attributesImpl.addAttribute("", ATTR_START, ATTR_START, "string", stringBuffer.toString());
            stringBuffer.setLength(0);
            stringBuffer.append(cosArray.getDouble(2));
            stringBuffer.append(",");
            stringBuffer.append(cosArray.getDouble(3));
            attributesImpl.addAttribute("", ATTR_END, ATTR_END, "string", stringBuffer.toString());
        }
        if (((PDFAnnotationLine)this.pdfAnnot).hasLineEnds() && (cosArray = ((PDFAnnotationLine)this.pdfAnnot).getLineEnds()).size() == 2) {
            attributesImpl.addAttribute("", ATTR_HEAD, ATTR_HEAD, "string", cosArray.getName(0).toString());
            attributesImpl.addAttribute("", ATTR_TAIL, ATTR_TAIL, "string", cosArray.getName(1).toString());
        }
        this.addInteriorColorXFDFAttribute(attributesImpl);
        contentHandler.startElement("", ELEM_LINE, ELEM_LINE, attributesImpl);
        if (!this.createXFDFRichContent(contentHandler)) {
            this.createXFDFContent(contentHandler);
        }
        this.createXFDFPopupElement(contentHandler);
        contentHandler.endElement("", ELEM_LINE, ELEM_LINE);
        contentHandler.characters(END_ELEM, 0, 1);
    }

    PDFAnnotation createPDFAnnotation(Attributes attributes) {
        if (this.pdfDoc == null) {
            return null;
        }
        int n = -1;
        PDFAnnotationLine pDFAnnotationLine = PDFAnnotationLine.create(this.pdfDoc);
        this.pdfAnnot = null;
        n = this.fillCommonAttributes(pDFAnnotationLine, attributes);
        if (n >= 0) {
            ArrayList arrayList;
            this.fillMarkupAttributes(pDFAnnotationLine, attributes);
            this.fillBorderStyleAttributes(pDFAnnotationLine, attributes);
            this.fillInteriorColorAttribute(pDFAnnotationLine, attributes);
            int n2 = this.findAttribute(ATTR_START, attributes);
            if (n2 >= 0) {
                ArrayList arrayList2;
                arrayList = new ArrayList(4);
                ArrayList arrayList3 = Utility.parseNumbers(attributes.getValue(n2), ",");
                if (arrayList3.size() == 2) {
                    arrayList.add(arrayList3.get(0));
                    arrayList.add(arrayList3.get(1));
                }
                if ((n2 = this.findAttribute(ATTR_END, attributes)) >= 0 && (arrayList2 = Utility.parseNumbers(attributes.getValue(n2), ",")).size() == 2) {
                    arrayList.add(arrayList2.get(0));
                    arrayList.add(arrayList2.get(1));
                    pDFAnnotationLine.setLineCoords(arrayList);
                }
            }
            if ((n2 = this.findAttribute(ATTR_HEAD, attributes)) >= 0) {
                arrayList = new ArrayList(2);
                arrayList.add(attributes.getValue(n2));
                n2 = this.findAttribute(ATTR_TAIL, attributes);
                if (n2 >= 0) {
                    arrayList.add(attributes.getValue(n2));
                    pDFAnnotationLine.setLineEnds(arrayList);
                }
            }
            if (this.setAnnotation(pDFAnnotationLine, n)) {
                this.pdfAnnot = pDFAnnotationLine;
                this.curPage = n;
            }
        }
        return this.pdfAnnot;
    }
}

