/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.internal.pdf.PDFAnnotation;
import com.adobe.internal.pdf.PDFAnnotationInk;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFInk;
import com.adobe.internal.pdf.PDFInkList;
import com.adobe.internal.pdf.cos.CosNumeric;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.Utility;
import com.adobe.internal.xfdf.XFDFAnnotation;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XFDFAnnotationInk
extends XFDFAnnotation {
    static final String ELEM_INK = "ink";
    static final String ELEM_INKLIST = "inklist";
    static final String ELEM_GESTURE = "gesture";
    static final String GESTTURE_PAIR = ",";
    static final String GESTTURE_END = ";";
    static final int GESTURE_LEN = 32;

    XFDFAnnotationInk(PDFAnnotationInk pDFAnnotationInk) {
        this.pdfAnnot = pDFAnnotationInk;
        this.pdfDoc = null;
    }

    XFDFAnnotationInk(PDFDocument pDFDocument) {
        this.pdfDoc = pDFDocument;
        this.pdfAnnot = null;
    }

    void transformToXFDF(ContentHandler contentHandler, int n) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.addCommonXFDFAttributes(attributesImpl, n);
        this.addMarkupXFDFAttributes(attributesImpl);
        this.addBorderStyleXFDFAttributes(attributesImpl, false);
        contentHandler.startElement("", ELEM_INK, ELEM_INK, attributesImpl);
        if (this.pdfAnnot.dictionaryContains(ASName.k_InkList)) {
            contentHandler.characters(END_ELEM, 0, 1);
            contentHandler.startElement("", ELEM_INKLIST, ELEM_INKLIST, nullAttrs);
            PDFInkList pDFInkList = ((PDFAnnotationInk)this.pdfAnnot).getInkList();
            for (int i = 0; i < pDFInkList.size(); ++i) {
                PDFInk pDFInk = (PDFInk)pDFInkList.get(i);
                String string = "";
                String string2 = GESTTURE_END;
                String string3 = GESTTURE_PAIR;
                int n2 = 0;
                StringBuffer stringBuffer = new StringBuffer(pDFInk.size());
                while (n2 < pDFInk.size()) {
                    CosNumeric cosNumeric = (CosNumeric)pDFInk.get(n2++);
                    stringBuffer.append(string);
                    stringBuffer.append(cosNumeric.doubleValue());
                    string = string3;
                    string3 = string2;
                    string2 = string;
                }
                this.createGesture(contentHandler, stringBuffer);
            }
            contentHandler.endElement("", ELEM_INKLIST, ELEM_INKLIST);
        }
        if (!this.createXFDFRichContent(contentHandler)) {
            this.createXFDFContent(contentHandler);
        }
        this.createXFDFPopupElement(contentHandler);
        contentHandler.endElement("", ELEM_INK, ELEM_INK);
        contentHandler.characters(END_ELEM, 0, 1);
    }

    PDFAnnotation createPDFAnnotation(Attributes attributes) {
        if (this.pdfDoc == null) {
            return null;
        }
        int n = -1;
        PDFAnnotationInk pDFAnnotationInk = PDFAnnotationInk.create(this.pdfDoc);
        this.pdfAnnot = null;
        n = this.fillCommonAttributes(pDFAnnotationInk, attributes);
        if (n >= 0) {
            this.fillCommonAttributes(pDFAnnotationInk, attributes);
            this.fillMarkupAttributes(pDFAnnotationInk, attributes);
            this.fillBorderStyleAttributes(pDFAnnotationInk, attributes);
            if (this.setAnnotation(pDFAnnotationInk, n)) {
                this.pdfAnnot = pDFAnnotationInk;
                this.curPage = n;
            }
        }
        return this.pdfAnnot;
    }

    void createInk(String string) {
        if (!(this.pdfAnnot instanceof PDFAnnotationInk)) {
            return;
        }
        PDFAnnotationInk pDFAnnotationInk = (PDFAnnotationInk)this.pdfAnnot;
        PDFInkList pDFInkList = pDFAnnotationInk.getOrMakeInkList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, GESTTURE_END);
        ArrayList arrayList = new ArrayList(stringTokenizer.countTokens() * 2);
        while (stringTokenizer.hasMoreTokens()) {
            ArrayList arrayList2 = Utility.parseNumbers(stringTokenizer.nextToken(), GESTTURE_PAIR);
            if (arrayList2.size() != 2) continue;
            arrayList.add(arrayList2.get(0));
            arrayList.add(arrayList2.get(1));
        }
        if (arrayList.size() > 0) {
            pDFInkList.add(arrayList);
            pDFAnnotationInk.setInkList(pDFInkList);
        }
    }

    void createGesture(ContentHandler contentHandler, StringBuffer stringBuffer) throws SAXException {
        if (stringBuffer.length() > 0) {
            String string = stringBuffer.toString();
            contentHandler.startElement("", ELEM_GESTURE, ELEM_GESTURE, nullAttrs);
            contentHandler.characters(string.toCharArray(), 0, string.length());
            contentHandler.endElement("", ELEM_GESTURE, ELEM_GESTURE);
            stringBuffer.setLength(0);
            stringBuffer.ensureCapacity(32);
        }
    }
}

