/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.internal.pdf.PDFAnnotation;
import com.adobe.internal.pdf.PDFAnnotationFreeText;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.cos.util.Utility;
import com.adobe.internal.xfdf.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XFDFAnnotationFreeText
extends XFDFAnnotation {
    static final String[] justStr = new String[]{"left", "centered", "right"};
    static final String ATTR_ROTATION = "rotation";
    static final String ATTR_JUSTIFICATION = "justification";
    static final String ELEM_FREETEXT = "freetext";

    XFDFAnnotationFreeText(PDFAnnotationFreeText pDFAnnotationFreeText) {
        this.pdfAnnot = pDFAnnotationFreeText;
        this.pdfDoc = null;
    }

    XFDFAnnotationFreeText(PDFDocument pDFDocument) {
        this.pdfDoc = pDFDocument;
        this.pdfAnnot = null;
    }

    void transformToXFDF(ContentHandler contentHandler, int n) throws SAXException {
        int n2;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.addCommonXFDFAttributes(attributesImpl, n);
        this.addMarkupXFDFAttributes(attributesImpl);
        this.addBorderStyleXFDFAttributes(attributesImpl, false);
        if (this.pdfAnnot.hasRotation()) {
            attributesImpl.addAttribute("", ATTR_ROTATION, ATTR_ROTATION, "string", Integer.toString(this.pdfAnnot.getRotation()));
        }
        if (((PDFAnnotationFreeText)this.pdfAnnot).hasJustification() && (n2 = ((PDFAnnotationFreeText)this.pdfAnnot).getJustification()) >= 0 && n2 < justStr.length) {
            attributesImpl.addAttribute("", ATTR_JUSTIFICATION, ATTR_JUSTIFICATION, "string", justStr[n2]);
        }
        contentHandler.startElement("", ELEM_FREETEXT, ELEM_FREETEXT, attributesImpl);
        this.createXFDFDefaultStyle(contentHandler);
        if (!this.createXFDFRichContent(contentHandler)) {
            this.createXFDFContent(contentHandler);
        }
        this.createXFDFDefaultAppearance(contentHandler);
        contentHandler.endElement("", ELEM_FREETEXT, ELEM_FREETEXT);
        contentHandler.characters(END_ELEM, 0, 1);
    }

    PDFAnnotation createPDFAnnotation(Attributes attributes) {
        if (this.pdfDoc == null) {
            return null;
        }
        int n = -1;
        PDFAnnotationFreeText pDFAnnotationFreeText = PDFAnnotationFreeText.create(this.pdfDoc);
        this.pdfAnnot = null;
        n = this.fillCommonAttributes(pDFAnnotationFreeText, attributes);
        if (n >= 0) {
            int n2;
            int n3;
            this.fillCommonAttributes(pDFAnnotationFreeText, attributes);
            this.fillMarkupAttributes(pDFAnnotationFreeText, attributes);
            this.fillBorderStyleAttributes(pDFAnnotationFreeText, attributes);
            int n4 = this.findAttribute(ATTR_ROTATION, attributes);
            if (n4 != -1) {
                pDFAnnotationFreeText.setRotation(attributes.getValue(n4));
            }
            if ((n3 = this.findAttribute(ATTR_JUSTIFICATION, attributes)) != -1 && (n2 = Utility.findStringInArray(attributes.getValue(n3), justStr)) >= 0) {
                pDFAnnotationFreeText.setJustification(n2);
            }
            if (this.setAnnotation(pDFAnnotationFreeText, n)) {
                this.pdfAnnot = pDFAnnotationFreeText;
                this.curPage = n;
            }
        }
        return this.pdfAnnot;
    }
}

