/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.internal.pdf.PDFAnnotation;
import com.adobe.internal.pdf.PDFAnnotationFileAttachment;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFEmbeddedFile;
import com.adobe.internal.pdf.PDFEmbeddedFileInfo;
import com.adobe.internal.pdf.PDFFileSpecification;
import com.adobe.internal.pdf.cos.util.PDFDocEncoding;
import com.adobe.internal.pdf.cos.util.Utility;
import com.adobe.internal.xfdf.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XFDFAnnotationFileAttachment
extends XFDFAnnotation {
    static final String ATTR_ICON = "icon";
    static final String ATTR_FILE = "file";
    static final String ATTR_MIMETYPE = "mimetype";
    static final String ATTR_MODIFICATION = "modification";
    static final String ATTR_CREATION = "creation";
    static final String ATTR_CHECKSUM = "checksum";
    static final String ATTR_SIZE = "size";
    static final String ELEM_FILEATTACHMENT = "fileattachment";

    XFDFAnnotationFileAttachment(PDFAnnotationFileAttachment pDFAnnotationFileAttachment) {
        this.pdfAnnot = pDFAnnotationFileAttachment;
        this.pdfDoc = null;
    }

    XFDFAnnotationFileAttachment(PDFDocument pDFDocument) {
        this.pdfDoc = pDFDocument;
        this.pdfAnnot = null;
    }

    void transformToXFDF(ContentHandler contentHandler, int n) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        PDFEmbeddedFile pDFEmbeddedFile = null;
        PDFEmbeddedFileInfo pDFEmbeddedFileInfo = null;
        this.addCommonXFDFAttributes(attributesImpl, n);
        this.addMarkupXFDFAttributes(attributesImpl);
        if (this.pdfAnnot.hasIcon()) {
            attributesImpl.addAttribute("", ATTR_ICON, ATTR_ICON, "string", this.pdfAnnot.getIcon());
        }
        if (((PDFAnnotationFileAttachment)this.pdfAnnot).hasFileSpecification()) {
            PDFFileSpecification pDFFileSpecification = ((PDFAnnotationFileAttachment)this.pdfAnnot).getFileSpecification();
            if (pDFFileSpecification.hasFilename()) {
                attributesImpl.addAttribute("", ATTR_FILE, ATTR_FILE, "string", PDFDocEncoding.toEscapeString(pDFFileSpecification.getFilename().getBytes()));
            }
            if (pDFFileSpecification.hasEmbeddedFile()) {
                pDFEmbeddedFile = pDFFileSpecification.getEmbeddedFile();
                if (pDFEmbeddedFile.hasMIMEType()) {
                    attributesImpl.addAttribute("", ATTR_MIMETYPE, ATTR_MIMETYPE, "string", pDFEmbeddedFile.getMIMEType());
                }
                if ((pDFEmbeddedFileInfo = pDFEmbeddedFile.getFileInfo()) != null) {
                    if (pDFEmbeddedFileInfo.hasModificationDate()) {
                        attributesImpl.addAttribute("", ATTR_MODIFICATION, ATTR_MODIFICATION, "string", pDFEmbeddedFileInfo.getModificationDate());
                    }
                    if (pDFEmbeddedFileInfo.hasCreationDate()) {
                        attributesImpl.addAttribute("", ATTR_CREATION, ATTR_CREATION, "string", pDFEmbeddedFileInfo.getCreationDate());
                    }
                    if (pDFEmbeddedFileInfo.hasChecksum()) {
                        attributesImpl.addAttribute("", ATTR_CHECKSUM, ATTR_CHECKSUM, "string", Utility.toHexString(pDFEmbeddedFileInfo.getCheckSum().getBytes()));
                    }
                    if (pDFEmbeddedFileInfo.hasSize()) {
                        attributesImpl.addAttribute("", ATTR_SIZE, ATTR_SIZE, "string", Integer.toString(pDFEmbeddedFileInfo.getSize()));
                    }
                }
            }
        }
        contentHandler.startElement("", ELEM_FILEATTACHMENT, ELEM_FILEATTACHMENT, attributesImpl);
        if (!this.createXFDFRichContent(contentHandler)) {
            this.createXFDFContent(contentHandler);
        }
        if (pDFEmbeddedFile != null) {
            this.createXFDFStreamData(contentHandler, pDFEmbeddedFile.getFileStream());
        }
        contentHandler.endElement("", ELEM_FILEATTACHMENT, ELEM_FILEATTACHMENT);
        contentHandler.characters(END_ELEM, 0, 1);
    }

    PDFAnnotation createPDFAnnotation(Attributes attributes) {
        if (this.pdfDoc == null) {
            return null;
        }
        int n = -1;
        PDFAnnotationFileAttachment pDFAnnotationFileAttachment = PDFAnnotationFileAttachment.create(this.pdfDoc);
        this.pdfAnnot = null;
        n = this.fillCommonAttributes(pDFAnnotationFileAttachment, attributes);
        if (n >= 0) {
            PDFCosObject pDFCosObject;
            this.fillMarkupAttributes(pDFAnnotationFileAttachment, attributes);
            int n2 = this.findAttribute(ATTR_ICON, attributes);
            if (n2 >= 0) {
                pDFAnnotationFileAttachment.setIcon(attributes.getValue(n2));
            }
            if ((n2 = this.findAttribute(ATTR_FILE, attributes)) >= 0) {
                pDFCosObject = pDFAnnotationFileAttachment.getOrMakeFileSpecification();
                ((PDFFileSpecification)pDFCosObject).setFileName(PDFDocEncoding.fromEscapeString(attributes.getValue(n2)));
                pDFAnnotationFileAttachment.setFileSpecification((PDFFileSpecification)pDFCosObject);
            }
            if ((n2 = this.findAttribute(ATTR_MIMETYPE, attributes)) >= 0) {
                pDFCosObject = pDFAnnotationFileAttachment.getOrMakeFileSpecification().getOrMakeEmbeddedFile();
                ((PDFEmbeddedFile)pDFCosObject).setMIMEType(attributes.getValue(n2));
                pDFAnnotationFileAttachment.setEmbededFile((PDFEmbeddedFile)pDFCosObject);
            }
            if ((n2 = this.findAttribute(ATTR_MODIFICATION, attributes)) >= 0) {
                pDFCosObject = pDFAnnotationFileAttachment.getOrMakeFileInfo();
                ((PDFEmbeddedFileInfo)pDFCosObject).setModificationDate(attributes.getValue(n2));
                pDFAnnotationFileAttachment.setFileInfo((PDFEmbeddedFileInfo)pDFCosObject);
            }
            if ((n2 = this.findAttribute(ATTR_CREATION, attributes)) >= 0) {
                pDFCosObject = pDFAnnotationFileAttachment.getOrMakeFileInfo();
                ((PDFEmbeddedFileInfo)pDFCosObject).setCreationDate(attributes.getValue(n2));
                pDFAnnotationFileAttachment.setFileInfo((PDFEmbeddedFileInfo)pDFCosObject);
            }
            if ((n2 = this.findAttribute(ATTR_CHECKSUM, attributes)) >= 0) {
                pDFCosObject = pDFAnnotationFileAttachment.getOrMakeFileInfo();
                ((PDFEmbeddedFileInfo)pDFCosObject).setCheckSum(Utility.fromHexString(attributes.getValue(n2)));
                pDFAnnotationFileAttachment.setFileInfo((PDFEmbeddedFileInfo)pDFCosObject);
            }
            if ((n2 = this.findAttribute(ATTR_SIZE, attributes)) >= 0) {
                pDFCosObject = pDFAnnotationFileAttachment.getOrMakeFileInfo();
                ((PDFEmbeddedFileInfo)pDFCosObject).setSize(attributes.getValue(n2));
                pDFAnnotationFileAttachment.setFileInfo((PDFEmbeddedFileInfo)pDFCosObject);
            }
            if (this.setAnnotation(pDFAnnotationFileAttachment, n)) {
                this.pdfAnnot = pDFAnnotationFileAttachment;
                this.curPage = n;
            }
        }
        return this.pdfAnnot;
    }
}

