/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.internal.pdf.PDFActions;
import com.adobe.internal.pdf.PDFAnnotation;
import com.adobe.internal.pdf.PDFAnnotationCircle;
import com.adobe.internal.pdf.PDFAnnotationFileAttachment;
import com.adobe.internal.pdf.PDFAnnotationFreeText;
import com.adobe.internal.pdf.PDFAnnotationHighlight;
import com.adobe.internal.pdf.PDFAnnotationInk;
import com.adobe.internal.pdf.PDFAnnotationLine;
import com.adobe.internal.pdf.PDFAnnotationLink;
import com.adobe.internal.pdf.PDFAnnotationPopup;
import com.adobe.internal.pdf.PDFAnnotationSound;
import com.adobe.internal.pdf.PDFAnnotationSquare;
import com.adobe.internal.pdf.PDFAnnotationStrikeOut;
import com.adobe.internal.pdf.PDFAnnotationText;
import com.adobe.internal.pdf.PDFAnnotationUnderline;
import com.adobe.internal.pdf.PDFBorderEffects;
import com.adobe.internal.pdf.PDFBorderStyle;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFFileSpecification;
import com.adobe.internal.pdf.PDFPage;
import com.adobe.internal.pdf.PDFRectangle;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.PDFDocEncoding;
import com.adobe.internal.pdf.cos.util.Utility;
import com.adobe.internal.xfdf.XFDFAnnotationCircle;
import com.adobe.internal.xfdf.XFDFAnnotationFileAttachment;
import com.adobe.internal.xfdf.XFDFAnnotationFreeText;
import com.adobe.internal.xfdf.XFDFAnnotationHighlight;
import com.adobe.internal.xfdf.XFDFAnnotationInk;
import com.adobe.internal.xfdf.XFDFAnnotationLine;
import com.adobe.internal.xfdf.XFDFAnnotationLink;
import com.adobe.internal.xfdf.XFDFAnnotationPopup;
import com.adobe.internal.xfdf.XFDFAnnotationSound;
import com.adobe.internal.xfdf.XFDFAnnotationSquare;
import com.adobe.internal.xfdf.XFDFAnnotationStrikeOut;
import com.adobe.internal.xfdf.XFDFAnnotationText;
import com.adobe.internal.xfdf.XFDFAnnotationUnderline;
import com.adobe.internal.xfdf.XFDFCopyString2Blob;
import com.adobe.internal.xfdf.XFDFObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class XFDFAnnotation
extends XFDFObject {
    static final int[] flagsBits = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256};
    static final String[] flagsText = new String[]{"invisible", "hidden", "print", "nozoom", "norotate", "noview", "readonly", "locked", "togglenoview"};
    static final String[] acroBorderStyle = new String[]{"S", "D", "B", "I", "U"};
    static final String[] xfdfBorderStyle = new String[]{"solid", "dash", "bevelled", "inset", "underline"};
    static final String flagsSeparator = ",";
    static final Attributes nullAttrs = new AttributesImpl();
    protected PDFAnnotation pdfAnnot = null;
    protected PDFDocument pdfDoc = null;
    protected int curPage = -1;
    private static final int L4K = 4096;
    private static final int STREAMBUFLEN = 512;
    static final String ATTR_PAGE = "page";
    static final String ATTR_COLOR = "color";
    static final String ATTR_MOD_DATE = "date";
    static final String ATTR_TITLE = "title";
    static final String ATTR_NAME = "name";
    static final String ATTR_RECT = "rect";
    static final String ATTR_FLAGS = "flags";
    static final String ATTR_CREATE_DATE = "creationdate";
    static final String ATTR_OPACITY = "opacity";
    static final String ATTR_SUBJ = "subject";
    static final String ATTR_WIDTH = "width";
    static final String ATTR_DASHES = "dashes";
    static final String ATTR_STYLE = "style";
    static final String ATTR_INTENSITY = "intensity";
    static final String ATTR_INTERIOR_COLOR = "interior-color";
    static final String ATTR_FRINGE = "fringe";
    static final String ATTR_QUADPOINTS = "coords";
    static final String ATTR_LENGTH = "length";
    static final String ATTR_FILTER = "filter";
    static final String ATTR_RAW = "raw";
    static final String ATTR_FILTERED = "filtered";
    static final String ATTR_ASCII = "ascii";
    static final String ATTR_HEX = "hex";
    static final String ATTR_MODE = "mode";
    static final String ATTR_ENCODING = "encoding";
    static final String ATTR_C = "cloudy";
    static final String ATTR_S = "solid";
    static final String ATTR_BODY_XFA = "xmlns:xfa";
    static final String ATTR_BODY_XHTML = "xmlns";
    static final String STRING_TYPE = "string";
    static final String ELEM_CONTENTS = "contents";
    static final String ELEM_DEFAULT_STYLE = "defaultstyle";
    static final String ELEM_DEFAULT_APPEARANCE = "defaultappearance";
    static final String ELEM_RICH_CONTENTS = "contents-richtext";
    static final String ELEM_DATA = "data";
    static final String ELEM_BODY = "body";
    static final String XMLNS_XFA = "http://www.xfa.org/schema/xfa-data/1.0/";
    static final String XMLNS_XHTML = "http://www.w3.org/1999/xhtml";
    static final String NS_XFA = "xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\"";
    static final String NS_XHTML = "xmlns=\"http://www.w3.org/1999/xhtml\"";
    static final char[] END_ELEM = "\n".toCharArray();

    XFDFAnnotation() {
    }

    XFDFAnnotation(PDFAnnotation pDFAnnotation) {
        this.pdfAnnot = pDFAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotation(PDFDocument pDFDocument) {
        this.pdfDoc = pDFDocument;
        this.pdfAnnot = null;
    }

    abstract PDFAnnotation createPDFAnnotation(Attributes var1);

    static XFDFAnnotation createXFDFAnnotation(PDFAnnotation pDFAnnotation) {
        if (pDFAnnotation instanceof PDFAnnotationCircle) {
            return new XFDFAnnotationCircle((PDFAnnotationCircle)pDFAnnotation);
        }
        if (pDFAnnotation instanceof PDFAnnotationFileAttachment) {
            return new XFDFAnnotationFileAttachment((PDFAnnotationFileAttachment)pDFAnnotation);
        }
        if (pDFAnnotation instanceof PDFAnnotationFreeText) {
            return new XFDFAnnotationFreeText((PDFAnnotationFreeText)pDFAnnotation);
        }
        if (pDFAnnotation instanceof PDFAnnotationHighlight) {
            return new XFDFAnnotationHighlight((PDFAnnotationHighlight)pDFAnnotation);
        }
        if (pDFAnnotation instanceof PDFAnnotationInk) {
            return new XFDFAnnotationInk((PDFAnnotationInk)pDFAnnotation);
        }
        if (pDFAnnotation instanceof PDFAnnotationLine) {
            return new XFDFAnnotationLine((PDFAnnotationLine)pDFAnnotation);
        }
        if (pDFAnnotation instanceof PDFAnnotationLink) {
            return new XFDFAnnotationLink((PDFAnnotationLink)pDFAnnotation);
        }
        if (pDFAnnotation instanceof PDFAnnotationSound) {
            return new XFDFAnnotationSound((PDFAnnotationSound)pDFAnnotation);
        }
        if (pDFAnnotation instanceof PDFAnnotationSquare) {
            return new XFDFAnnotationSquare((PDFAnnotationSquare)pDFAnnotation);
        }
        if (pDFAnnotation instanceof PDFAnnotationStrikeOut) {
            return new XFDFAnnotationStrikeOut((PDFAnnotationStrikeOut)pDFAnnotation);
        }
        if (pDFAnnotation instanceof PDFAnnotationText) {
            return new XFDFAnnotationText((PDFAnnotationText)pDFAnnotation);
        }
        if (pDFAnnotation instanceof PDFAnnotationUnderline) {
            return new XFDFAnnotationUnderline((PDFAnnotationUnderline)pDFAnnotation);
        }
        return null;
    }

    protected String getInReplyTo(Attributes attributes) {
        return null;
    }

    protected boolean setAnnotation(PDFAnnotation pDFAnnotation, int n) {
        PDFPage pDFPage = this.pdfDoc.requirePages().getPage(n);
        if (pDFPage != null) {
            pDFPage.addAnnotation(pDFAnnotation);
            return true;
        }
        return false;
    }

    int getCurPage() {
        return this.curPage;
    }

    static double[] getRectangle(String string) {
        String string2;
        double[] dArray = new double[4];
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while ((string2 = XFDFAnnotation.getCommaToken(stringBuffer)) != null) {
            if (n > 3) {
                return null;
            }
            Double d = new Double(string2);
            dArray[n] = d;
            ++n;
        }
        if (n != 4) {
            return null;
        }
        return dArray;
    }

    private String encodeStream(byte[] byArray, boolean bl) {
        if (bl) {
            return Utility.toHexString(byArray);
        }
        return Utility.toString(byArray);
    }

    private static String getCommaToken(StringBuffer stringBuffer) {
        int n = stringBuffer.indexOf(flagsSeparator);
        if (n == -1 && (n = stringBuffer.length()) == 0) {
            return null;
        }
        String string = XFDFAnnotation.skipSpaces(stringBuffer.substring(0, n));
        stringBuffer.delete(0, n + 1);
        return string;
    }

    private static String skipSpaces(String string) {
        int n = 0;
        while (string.charAt(n) == ' ') {
            ++n;
        }
        return string.substring(n);
    }

    static int makeFlags(String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        while ((string2 = XFDFAnnotation.getCommaToken(stringBuffer)) != null) {
            n2 = Utility.findStringInArray(string2, flagsText);
            if (n2 < 0) continue;
            n |= flagsBits[n2];
        }
        return n;
    }

    static String getAcroBorderStyle(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, flagsSeparator);
        while (stringTokenizer.hasMoreTokens() && (string2 = Utility.substituteStringFromArray(stringTokenizer.nextToken(), xfdfBorderStyle, acroBorderStyle)) == null) {
        }
        return string2;
    }

    static ASName getAcroEffectsStyle(String string) {
        ASName aSName = null;
        if (string == null) {
            return null;
        }
        Object var2_2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, flagsSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().equals(ATTR_C)) continue;
            aSName = ASName.k_C;
            break;
        }
        return aSName;
    }

    XFDFAnnotationPopup getXFDFAnnotationPopup() {
        PDFAnnotationPopup pDFAnnotationPopup = this.pdfAnnot.getAnnotationPopup();
        if (pDFAnnotationPopup == null) {
            return null;
        }
        return new XFDFAnnotationPopup(pDFAnnotationPopup);
    }

    String getBorderEffectsStyle(PDFBorderEffects pDFBorderEffects) {
        ASName aSName = pDFBorderEffects.getStyle();
        if (aSName == ASName.k_C) {
            return ATTR_C;
        }
        return null;
    }

    String getRGBColorsForXFDF(ASName aSName) {
        if (!this.pdfAnnot.dictionaryContains(aSName)) {
            return null;
        }
        CosArray cosArray = this.pdfAnnot.getDictionaryArrayValue(aSName);
        if (cosArray.size() != 3) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(7);
        stringBuffer.append('#');
        for (int i = 0; i < 3; ++i) {
            BigDecimal bigDecimal = new BigDecimal(cosArray.getDouble(i) * 255.0);
            int n = bigDecimal.setScale(0, 4).intValue();
            String string = Integer.toHexString(n).toUpperCase();
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    void transformToXFDF(ContentHandler contentHandler, int n) throws SAXException {
    }

    void addCommonXFDFAttributes(AttributesImpl attributesImpl, int n) {
        String string;
        String string2;
        String string3;
        if (n >= 0) {
            attributesImpl.addAttribute("", ATTR_PAGE, ATTR_PAGE, STRING_TYPE, Integer.toString(n));
        }
        if ((string3 = this.getRGBColorsForXFDF(ASName.k_C)) != null) {
            attributesImpl.addAttribute("", ATTR_COLOR, ATTR_COLOR, STRING_TYPE, string3);
        }
        if (this.pdfAnnot.hasModificationDate()) {
            attributesImpl.addAttribute("", ATTR_MOD_DATE, ATTR_MOD_DATE, STRING_TYPE, this.pdfAnnot.getModificationDate().asString());
        }
        if ((string2 = this.pdfAnnot.getTitle()) != null) {
            attributesImpl.addAttribute("", ATTR_TITLE, ATTR_TITLE, STRING_TYPE, string2);
        }
        if ((string = this.pdfAnnot.getName()) != null) {
            attributesImpl.addAttribute("", ATTR_NAME, ATTR_NAME, STRING_TYPE, string);
        }
        if (this.pdfAnnot.hasRectangle()) {
            PDFRectangle pDFRectangle = this.pdfAnnot.getRectangle();
            attributesImpl.addAttribute("", ATTR_RECT, ATTR_RECT, STRING_TYPE, Double.toString(pDFRectangle.llx()) + ", " + Double.toString(pDFRectangle.lly()) + ", " + Double.toString(pDFRectangle.urx()) + ", " + Double.toString(pDFRectangle.ury()));
        }
        int n2 = 0;
        n2 = this.pdfAnnot.getFlags();
        if (n2 != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            String string4 = "";
            for (int i = 0; i < flagsText.length; ++i) {
                if ((n2 & flagsBits[i]) == 0) continue;
                stringBuffer.append(string4);
                stringBuffer.append(flagsText[i]);
                string4 = flagsSeparator;
            }
            attributesImpl.addAttribute("", ATTR_FLAGS, ATTR_FLAGS, STRING_TYPE, stringBuffer.toString());
        }
    }

    void addMarkupXFDFAttributes(AttributesImpl attributesImpl) {
        if (this.pdfAnnot.hasCreationDate()) {
            attributesImpl.addAttribute("", ATTR_CREATE_DATE, ATTR_CREATE_DATE, STRING_TYPE, this.pdfAnnot.getCreationDate().asString());
        }
        if (this.pdfAnnot.hasOpacity()) {
            attributesImpl.addAttribute("", ATTR_OPACITY, ATTR_OPACITY, STRING_TYPE, this.pdfAnnot.getOpacity());
        }
        if (this.pdfAnnot.hasSubject()) {
            attributesImpl.addAttribute("", ATTR_SUBJ, ATTR_SUBJ, STRING_TYPE, this.pdfAnnot.getSubject());
        }
    }

    void addBorderStyleXFDFAttributes(AttributesImpl attributesImpl, boolean bl) {
        PDFBorderStyle pDFBorderStyle = this.pdfAnnot.getBorderStyle();
        if (pDFBorderStyle != null) {
            PDFBorderEffects pDFBorderEffects;
            boolean bl2 = false;
            if (pDFBorderStyle.hasWidth()) {
                attributesImpl.addAttribute("", ATTR_WIDTH, ATTR_WIDTH, STRING_TYPE, pDFBorderStyle.getWidthAsString());
            }
            String string = null;
            String string2 = null;
            if (pDFBorderStyle.hasStyle()) {
                string2 = pDFBorderStyle.getStyle().toString();
                string = Utility.substituteStringFromArray(string2, acroBorderStyle, xfdfBorderStyle);
            }
            if (pDFBorderStyle.hasDash() && string2 != null && string2.equals("D")) {
                attributesImpl.addAttribute("", ATTR_DASHES, ATTR_DASHES, STRING_TYPE, Utility.makeNumbersString(pDFBorderStyle.getDash(), flagsSeparator));
                bl2 = true;
            }
            if (!bl2 && string != null && string.equals("dash")) {
                string = null;
            }
            if (bl && (pDFBorderEffects = this.pdfAnnot.getBorderEffects()) != null) {
                String string3;
                if (pDFBorderEffects.hasStyle() && (string3 = this.getBorderEffectsStyle(pDFBorderEffects)) != null) {
                    if (string == null) {
                        string = string3;
                    } else {
                        StringBuffer stringBuffer = new StringBuffer(string.length() + string3.length() + 1);
                        stringBuffer.append(string);
                        stringBuffer.append(flagsSeparator);
                        stringBuffer.append(string3);
                        string = stringBuffer.toString();
                    }
                }
                if (pDFBorderEffects.hasIntensity()) {
                    attributesImpl.addAttribute("", ATTR_INTENSITY, ATTR_INTENSITY, STRING_TYPE, pDFBorderEffects.getIntensityAsString());
                }
            }
            if (string != null) {
                attributesImpl.addAttribute("", ATTR_STYLE, ATTR_STYLE, STRING_TYPE, string);
            }
        }
    }

    private boolean addStreamXFDFAttributes(AttributesImpl attributesImpl, CosStream cosStream) {
        String string;
        int n;
        String string2 = null;
        CosObject cosObject = cosStream.get(ASName.k_Filter);
        int n2 = n = cosObject != null ? cosObject.getType() : 0;
        if (n == 3) {
            string2 = cosStream.getName(ASName.k_Filter).toString();
        } else if (n == 5) {
            CosArray cosArray = cosStream.getCosArray(ASName.k_Filter);
            string = "";
            StringBuffer stringBuffer = new StringBuffer(cosArray.size() * 10);
            for (int i = 0; i < cosArray.size(); ++i) {
                stringBuffer.append(string);
                stringBuffer.append(cosArray.getName(i).toString());
                string = flagsSeparator;
            }
            string2 = stringBuffer.toString();
        }
        if (string2 != null) {
            attributesImpl.addAttribute("", ATTR_FILTER, ATTR_FILTER, STRING_TYPE, string2);
        }
        int n3 = cosStream.getInt(ASName.k_Length);
        attributesImpl.addAttribute("", ATTR_LENGTH, ATTR_LENGTH, STRING_TYPE, Integer.toString(n3));
        String string3 = n3 < 4096 && cosStream.isASCIIEncoded() ? ATTR_FILTERED : ATTR_RAW;
        string = string3.equals(ATTR_RAW) ? ATTR_HEX : ATTR_ASCII;
        attributesImpl.addAttribute("", ATTR_MODE, ATTR_MODE, STRING_TYPE, string3);
        attributesImpl.addAttribute("", ATTR_ENCODING, ATTR_ENCODING, STRING_TYPE, string);
        return string3.equals(ATTR_RAW);
    }

    void addInteriorColorXFDFAttribute(AttributesImpl attributesImpl) {
        String string = this.getRGBColorsForXFDF(ASName.k_IC);
        if (string != null) {
            attributesImpl.addAttribute("", ATTR_INTERIOR_COLOR, ATTR_INTERIOR_COLOR, STRING_TYPE, string);
        }
    }

    void addFringeXFDFAttribute(AttributesImpl attributesImpl) {
        double[] dArray;
        if (this.pdfAnnot.hasFringe() && (dArray = this.pdfAnnot.getFringe()).length == 4) {
            attributesImpl.addAttribute("", ATTR_FRINGE, ATTR_FRINGE, STRING_TYPE, Utility.makeNumbersString(this.pdfAnnot.getFringe(), flagsSeparator));
        }
    }

    boolean addCoordXFDFAttribute(AttributesImpl attributesImpl) {
        if (this.pdfAnnot.hasQuadPoints()) {
            attributesImpl.addAttribute("", ATTR_QUADPOINTS, ATTR_QUADPOINTS, STRING_TYPE, Utility.makeNumbersString(this.pdfAnnot.getQuadPoints(), flagsSeparator));
        }
        return false;
    }

    static String getAttributeName(Attributes attributes, int n) {
        String string = attributes.getLocalName(n);
        if (string == null || string.length() == 0) {
            string = attributes.getQName(n);
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    protected int findAttribute(String string, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!string.equals(XFDFAnnotation.getAttributeName(attributes, i))) continue;
            return i;
        }
        return -1;
    }

    protected void createFileSpec(Attributes attributes) {
        if (this.pdfAnnot == null || !(this.pdfAnnot instanceof PDFAnnotationLink)) {
            return;
        }
        int n = this.findAttribute("OriginalName", attributes);
        if (n != -1) {
            String string = attributes.getValue(n);
            PDFAnnotationLink pDFAnnotationLink = (PDFAnnotationLink)this.pdfAnnot;
            PDFActions pDFActions = pDFAnnotationLink.getActions();
            PDFFileSpecification pDFFileSpecification = PDFFileSpecification.create(pDFAnnotationLink.getPDFDocument(), PDFDocEncoding.fromEscapeString(string), null);
            pDFActions.setFileSpecification(pDFFileSpecification);
        }
    }

    protected boolean startDataStream(Attributes attributes) {
        CosStream cosStream;
        boolean bl = false;
        CosStream cosStream2 = this.pdfAnnot instanceof PDFAnnotationSound ? ((PDFAnnotationSound)this.pdfAnnot).getDataStream() : (cosStream = this.pdfAnnot instanceof PDFAnnotationFileAttachment ? ((PDFAnnotationFileAttachment)this.pdfAnnot).getDataStream() : null);
        if (cosStream == null) {
            return false;
        }
        int n = this.findAttribute(ATTR_FILTER, attributes);
        if (n >= 0) {
            String string = attributes.getValue(n);
            if (string.indexOf(flagsSeparator) == -1) {
                this.pdfAnnot.setStreamFilter(cosStream, string);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, flagsSeparator);
                ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                this.pdfAnnot.setStreamFilter(cosStream, arrayList);
            }
        }
        if ((n = this.findAttribute(ATTR_LENGTH, attributes)) >= 0) {
            this.pdfAnnot.setStreamLength(cosStream, Integer.parseInt(attributes.getValue(n)));
        }
        if ((n = this.findAttribute(ATTR_MODE, attributes)) >= 0) {
            bl = attributes.getValue(n).equals(ATTR_RAW);
        }
        return bl;
    }

    protected void endDataStream(String string, boolean bl) {
        CosStream cosStream;
        CosStream cosStream2 = this.pdfAnnot instanceof PDFAnnotationSound ? ((PDFAnnotationSound)this.pdfAnnot).getDataStream() : (cosStream = this.pdfAnnot instanceof PDFAnnotationFileAttachment ? ((PDFAnnotationFileAttachment)this.pdfAnnot).getDataStream() : null);
        if (cosStream == null) {
            return;
        }
        try {
            byte[] byArray = bl ? Utility.fromHexString(string) : string.getBytes("ASCII");
            this.pdfAnnot.setDataStreamEncoded(cosStream, byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException();
        }
    }

    protected int fillCommonAttributes(PDFAnnotation pDFAnnotation, Attributes attributes) {
        int n = -1;
        int n2 = attributes.getLength();
        for (int i = 0; i < n2; ++i) {
            String string = XFDFAnnotation.getAttributeName(attributes, i);
            if (string == null) continue;
            if (string.equals(ATTR_PAGE)) {
                Integer n3 = new Integer(attributes.getValue(i));
                n = n3;
                continue;
            }
            if (string.equals(ATTR_COLOR)) {
                pDFAnnotation.setRGBColor(attributes.getValue(i));
                continue;
            }
            if (string.equals(ATTR_MOD_DATE)) {
                pDFAnnotation.setModificationDate(attributes.getValue(i));
                continue;
            }
            if (string.equals(ATTR_TITLE)) {
                pDFAnnotation.setTitle(attributes.getValue(i));
                continue;
            }
            if (string.equals(ATTR_NAME)) {
                pDFAnnotation.setName(attributes.getValue(i));
                continue;
            }
            if (string.equals(ATTR_RECT)) {
                double[] dArray = XFDFAnnotation.getRectangle(attributes.getValue(i));
                if (dArray == null) continue;
                pDFAnnotation.setRectangle(dArray[0], dArray[1], dArray[2], dArray[3]);
                continue;
            }
            if (!string.equals(ATTR_FLAGS)) continue;
            int n4 = XFDFAnnotation.makeFlags(attributes.getValue(i));
            pDFAnnotation.setFlags(n4);
        }
        return n;
    }

    protected void fillMarkupAttributes(PDFAnnotation pDFAnnotation, Attributes attributes) {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string = XFDFAnnotation.getAttributeName(attributes, i);
            if (string == null) continue;
            if (string.equals(ATTR_CREATE_DATE)) {
                pDFAnnotation.setCreationDate(attributes.getValue(i));
                continue;
            }
            if (string.equals(ATTR_OPACITY)) {
                pDFAnnotation.setOpacity(attributes.getValue(i));
                continue;
            }
            if (!string.equals(ATTR_SUBJ)) continue;
            pDFAnnotation.setSubject(attributes.getValue(i));
        }
    }

    protected void fillBorderStyleAttributes(PDFAnnotation pDFAnnotation, Attributes attributes) {
        int n = attributes.getLength();
        boolean bl = false;
        PDFBorderStyle pDFBorderStyle = pDFAnnotation.getOrMakeBorderStyle();
        for (int i = 0; i < n; ++i) {
            String string = XFDFAnnotation.getAttributeName(attributes, i);
            if (string == null) continue;
            if (string.equals(ATTR_WIDTH)) {
                pDFBorderStyle.setWidth(attributes.getValue(i));
                bl = true;
                continue;
            }
            if (string.equals(ATTR_STYLE)) {
                String string2 = XFDFAnnotation.getAcroBorderStyle(attributes.getValue(i));
                if (string2 == null) continue;
                pDFBorderStyle.setStyle(string2);
                bl = true;
                continue;
            }
            if (!string.equals(ATTR_DASHES)) continue;
            pDFBorderStyle.setDash(attributes.getValue(i), flagsSeparator);
            bl = true;
        }
        if (bl) {
            pDFAnnotation.setBorderStyle(pDFBorderStyle);
        }
    }

    protected void fillBorderEffectsAttributes(PDFAnnotation pDFAnnotation, Attributes attributes) {
        int n = attributes.getLength();
        boolean bl = false;
        PDFBorderEffects pDFBorderEffects = pDFAnnotation.getOrMakeBorderEffects();
        for (int i = 0; i < n; ++i) {
            String string = XFDFAnnotation.getAttributeName(attributes, i);
            if (string == null) continue;
            if (string.equals(ATTR_STYLE)) {
                ASName aSName = XFDFAnnotation.getAcroEffectsStyle(attributes.getValue(i));
                if (aSName == null) continue;
                pDFBorderEffects.setStyle(aSName);
                bl = true;
                continue;
            }
            if (!string.equals(ATTR_INTENSITY)) continue;
            pDFBorderEffects.setIntensity(attributes.getValue(i));
            bl = true;
        }
        if (bl) {
            pDFAnnotation.setBorderEffects(pDFBorderEffects);
        }
    }

    protected void fillInteriorColorAttribute(PDFAnnotation pDFAnnotation, Attributes attributes) {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string = XFDFAnnotation.getAttributeName(attributes, i);
            if (string == null || !string.equals(ATTR_INTERIOR_COLOR)) continue;
            pDFAnnotation.setRGBInteriorColor(attributes.getValue(i));
            return;
        }
    }

    protected void fillFringeAttribute(PDFAnnotation pDFAnnotation, Attributes attributes) {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string = XFDFAnnotation.getAttributeName(attributes, i);
            if (string == null || !string.equals(ATTR_FRINGE)) continue;
            pDFAnnotation.setFringe(attributes.getValue(i), flagsSeparator);
            return;
        }
    }

    protected void fillCoordAttribute(PDFAnnotation pDFAnnotation, Attributes attributes) {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string = XFDFAnnotation.getAttributeName(attributes, i);
            if (string == null || !string.equals(ATTR_QUADPOINTS)) continue;
            pDFAnnotation.setQuadPoints(attributes.getValue(i), flagsSeparator);
            return;
        }
    }

    boolean createXFDFContent(ContentHandler contentHandler) throws SAXException {
        String string = this.pdfAnnot.getContents();
        if (string != null) {
            contentHandler.startElement("", ELEM_CONTENTS, ELEM_CONTENTS, nullAttrs);
            contentHandler.characters(string.toCharArray(), 0, string.length());
            contentHandler.endElement("", ELEM_CONTENTS, ELEM_CONTENTS);
            return true;
        }
        return false;
    }

    private String ensureNSinBodyElement(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.indexOf("<body");
        if (n < 0) {
            return null;
        }
        if (n > 0) {
            stringBuffer.append(string.substring(0, n));
        }
        stringBuffer.append("<body xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\" ");
        n += ELEM_BODY.length() + 2;
        int n2 = string.indexOf(NS_XHTML);
        int n3 = string.indexOf(NS_XFA);
        if (n2 > 0) {
            if (n3 > 0) {
                if (n2 < n3) {
                    if (n <= n2) {
                        stringBuffer.append(string.substring(n, n2));
                        n = n2 + NS_XHTML.length();
                    }
                    if (n <= n3) {
                        stringBuffer.append(string.substring(n, n3));
                        n = n3 + NS_XFA.length();
                    }
                } else {
                    if (n <= n3) {
                        stringBuffer.append(string.substring(n, n3));
                        n = n3 + NS_XFA.length();
                    }
                    if (n <= n2) {
                        stringBuffer.append(string.substring(n, n2));
                        n = n2 + NS_XHTML.length();
                    }
                }
            } else if (n <= n2) {
                stringBuffer.append(string.substring(n, n2));
                n = n2 + NS_XHTML.length();
            }
        } else if (n3 > 0 && n <= n3) {
            stringBuffer.append(string.substring(n, n3));
            n = n3 + NS_XFA.length();
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    boolean createXFDFRichContent(ContentHandler contentHandler) throws SAXException {
        try {
            String string = this.ensureNSinBodyElement(this.pdfAnnot.getRichContents());
            if (string != null) {
                XFDFCopyString2Blob xFDFCopyString2Blob = new XFDFCopyString2Blob(contentHandler, null);
                contentHandler.startElement("", ELEM_RICH_CONTENTS, ELEM_RICH_CONTENTS, nullAttrs);
                xFDFCopyString2Blob.copyBlob(string);
                contentHandler.endElement("", ELEM_RICH_CONTENTS, ELEM_RICH_CONTENTS);
                return true;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        return false;
    }

    boolean createXFDFDefaultStyle(ContentHandler contentHandler) throws SAXException {
        String string = this.pdfAnnot.getDefaultStyle();
        if (string != null) {
            contentHandler.startElement("", ELEM_DEFAULT_STYLE, ELEM_DEFAULT_STYLE, nullAttrs);
            contentHandler.characters(string.toCharArray(), 0, string.length());
            contentHandler.endElement("", ELEM_DEFAULT_STYLE, ELEM_DEFAULT_STYLE);
            return true;
        }
        return false;
    }

    boolean createXFDFDefaultAppearance(ContentHandler contentHandler) throws SAXException {
        String string = this.pdfAnnot.getDefaultAppearance();
        if (string != null) {
            contentHandler.startElement("", ELEM_DEFAULT_APPEARANCE, ELEM_DEFAULT_APPEARANCE, nullAttrs);
            contentHandler.characters(string.toCharArray(), 0, string.length());
            contentHandler.endElement("", ELEM_DEFAULT_APPEARANCE, ELEM_DEFAULT_APPEARANCE);
            return true;
        }
        return false;
    }

    boolean createXFDFStreamData(ContentHandler contentHandler, CosStream cosStream) throws SAXException {
        long l;
        if (cosStream == null) {
            return false;
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        boolean bl = this.addStreamXFDFAttributes(attributesImpl, cosStream);
        ByteStream byteStream = cosStream.getStreamEncoded();
        byteStream.setPosition(0L);
        contentHandler.characters(END_ELEM, 0, 1);
        contentHandler.startElement("", ELEM_DATA, ELEM_DATA, attributesImpl);
        while ((l = byteStream.bytesAvailable()) > 0L) {
            int n = (int)StrictMath.min(l, 512L);
            byte[] byArray = new byte[n];
            byteStream.get(byArray, 0, n);
            String string = this.encodeStream(byArray, bl);
            contentHandler.characters(END_ELEM, 0, 1);
            contentHandler.characters(string.toCharArray(), 0, string.length());
        }
        contentHandler.characters(END_ELEM, 0, 1);
        contentHandler.endElement("", ELEM_DATA, ELEM_DATA);
        return true;
    }

    boolean createXFDFPopupElement(ContentHandler contentHandler) throws SAXException {
        if (this.pdfAnnot.hasPopup()) {
            XFDFAnnotationPopup xFDFAnnotationPopup = this.getXFDFAnnotationPopup();
            xFDFAnnotationPopup.transformToXFDF(contentHandler, -1);
        }
        return false;
    }
}

