/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.internal.pdf.PDFField;
import com.adobe.internal.pdf.PDFFieldButton;
import com.adobe.internal.pdf.PDFFieldSignature;
import com.adobe.internal.pdf.PDFInteractiveForm;
import com.adobe.internal.pdf.PDFText;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.xfdf.XFDFFieldList;
import com.adobe.pdf.exceptions.XFDFParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XFDF2PDFFormReader
extends DefaultHandler {
    private PDFField curFormField;
    private XFDFFieldList curFormList;
    private PDFInteractiveForm acroFormTop;
    private StringBuffer valuesBuff = null;
    private LinkedList valuesList = null;
    private int skipElement = 0;
    private int inValue = 0;
    private int countXFDF = 0;
    private boolean inXFDF = false;
    private boolean inFields = false;
    private int countFields = 0;
    private int dbgInt = 0;
    private static final String F_NAME = "f";
    private static final String IDS_NAME = "ids";
    private static final String ANNOTS_NAME = "annots";
    private static final String XFDF_NAME = "xfdf";
    private static final String FIELDS_NAME = "fields";
    private static final String FIELD_NAME = "field";
    private static final String ELEM_NAME = "name";
    private static final String VALUE_NAME = "value";
    private static final String RICH_NAME = "value_richtext";

    public XFDF2PDFFormReader(PDFInteractiveForm pDFInteractiveForm) {
        this.acroFormTop = pDFInteractiveForm;
        this.curFormField = null;
        this.curFormList = new XFDFFieldList(pDFInteractiveForm.getFieldList());
    }

    private Object getFieldByName(XFDFFieldList xFDFFieldList, String string) throws SAXException {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < xFDFFieldList.size(); ++i) {
            Object e = xFDFFieldList.get(i);
            if (e instanceof PDFField && string.equals(XFDFFieldList.getBaseFieldName(((PDFField)e).getPartialName()))) {
                return e;
            }
            if (!(e instanceof XFDFFieldList) || !string.equals(((XFDFFieldList)e).getName())) continue;
            return e;
        }
        return null;
    }

    private String getFieldName(Attributes attributes) throws SAXException {
        String string = attributes.getLocalName(0);
        if (string == null || string.length() == 0) {
            string = attributes.getQName(0);
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        if (attributes.getLength() != 1 || !string.equals(ELEM_NAME)) {
            throw new XFDFParseException("Wrong PDF Fields structure");
        }
        return attributes.getValue(0);
    }

    String getElementType(String string, String string2) {
        String string3 = string;
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        return string3;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.skipElement = 0;
        this.inValue = 0;
        this.countXFDF = 0;
        this.inXFDF = false;
        this.inFields = false;
        this.countFields = 0;
        this.acroFormTop.setNeedAppearances(true);
    }

    public void endDocument() throws SAXException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = this.getElementType(string2, string3);
        if (string4 == null || string4.length() == 0) {
            throw new XFDFParseException("Wrong XML structure");
        }
        if (string4.equals(XFDF_NAME)) {
            ++this.countXFDF;
            this.inXFDF = true;
        }
        if (string4.equals(FIELDS_NAME)) {
            ++this.countFields;
            this.inFields = true;
        }
        if (this.skipElement > 0 || this.countXFDF != 1 || !this.inXFDF && this.countFields != 1) {
            ++this.skipElement;
        } else if (string4.equals(FIELD_NAME)) {
            Object object = this.getFieldByName(this.curFormList, this.getFieldName(attributes));
            if (object == null) {
                ++this.skipElement;
            } else if (object instanceof PDFField) {
                if (object instanceof PDFFieldSignature) {
                    ++this.skipElement;
                }
                this.curFormField = (PDFField)object;
            } else {
                if (!(object instanceof XFDFFieldList)) throw new XFDFParseException("Unexpected element");
                this.curFormList = (XFDFFieldList)object;
                this.curFormField = null;
            }
        } else if (string4.equals(VALUE_NAME)) {
            if (this.curFormField == null || this.inValue > 0) {
                ++this.skipElement;
            } else if (this.valuesList == null) {
                this.valuesList = new LinkedList();
            }
            ++this.inValue;
        } else if (string4.equals(RICH_NAME)) {
            if (this.curFormField == null || this.inValue > 0) {
                ++this.skipElement;
            }
            ++this.inValue;
        } else if (!this.inXFDF && !this.inFields) {
            ++this.skipElement;
        }
        this.inXFDF = false;
        this.inFields = false;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = this.getElementType(string2, string3);
        if (string4 == null || string4.length() == 0) {
            throw new XFDFParseException("Wrong XML structure");
        }
        if (this.skipElement > 0) {
            --this.skipElement;
        } else if (string4.equals(FIELD_NAME)) {
            if (this.curFormField != null && this.valuesList != null) {
                List list;
                if (this.valuesList.isEmpty()) {
                    this.curFormField.removeValue();
                } else if (this.curFormField instanceof PDFFieldButton && (list = this.curFormField.getOptionList()) != null) {
                    Iterator iterator = this.valuesList.iterator();
                    while (iterator.hasNext()) {
                        String string5 = ((PDFText)iterator.next()).stringValue();
                        int n = list.indexOf(string5);
                        if (n < 0) continue;
                        Integer n2 = new Integer(n);
                        this.curFormField.setNameValue(ASName.create(n2.toString()));
                        break;
                    }
                } else if (this.valuesList.size() == 1) {
                    if (this.curFormField instanceof PDFFieldButton) {
                        this.curFormField.setNameValue(ASName.create(((PDFText)this.valuesList.get(0)).stringValue()));
                        if (((PDFFieldButton)this.curFormField).isCheckBox()) {
                            ((PDFFieldButton)this.curFormField).setStateFromValue();
                        }
                    } else {
                        this.curFormField.setTextValue((PDFText)this.valuesList.get(0));
                    }
                } else {
                    this.curFormField.setListValue(this.valuesList);
                }
            }
            this.valuesList = null;
            if (this.curFormField == null) {
                this.curFormList = this.curFormList.getParent();
                if (this.curFormList == null) {
                    this.curFormList = new XFDFFieldList(this.acroFormTop.getFieldList());
                }
            }
        } else if (string4.equals(VALUE_NAME)) {
            --this.inValue;
            if (this.inValue == 0) {
                if (this.valuesList == null) {
                    throw new XFDFParseException("End of the <value> element without start");
                }
                if (this.valuesBuff.length() != 0 && this.curFormField != null) {
                    this.valuesList.add(PDFText.create(this.curFormField.getPDFDocument(), this.valuesBuff.toString()));
                }
                this.valuesBuff.setLength(0);
            }
        } else if (string4.equals(RICH_NAME)) {
            --this.inValue;
            if (this.inValue == 0 && this.curFormField != null) {
                this.curFormField.setRichText(PDFText.create(this.curFormField.getPDFDocument(), this.valuesBuff.toString()));
                this.valuesBuff.setLength(0);
            }
        } else if (string4.equals(XFDF_NAME) && this.countXFDF > 1) {
            --this.countXFDF;
        } else if (string4.equals(FIELDS_NAME) && this.countFields > 1) {
            --this.countFields;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.skipElement > 0 || this.inValue != 1) {
            return;
        }
        String string = new String(cArray, n, n2);
        if (this.valuesBuff == null) {
            this.valuesBuff = new StringBuffer(string);
        } else {
            this.valuesBuff.append(string);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }
}

