/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.internal.pdf.PDFActions;
import com.adobe.internal.pdf.PDFAnnotation;
import com.adobe.internal.pdf.PDFAnnotationFreeText;
import com.adobe.internal.pdf.PDFAnnotationLink;
import com.adobe.internal.pdf.PDFAnnotationList;
import com.adobe.internal.pdf.PDFAnnotationText;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFPage;
import com.adobe.internal.pdf.PDFPageTree;
import com.adobe.internal.xfdf.XFDFAnnotation;
import com.adobe.internal.xfdf.XFDFAnnotationCircle;
import com.adobe.internal.xfdf.XFDFAnnotationFileAttachment;
import com.adobe.internal.xfdf.XFDFAnnotationFreeText;
import com.adobe.internal.xfdf.XFDFAnnotationHighlight;
import com.adobe.internal.xfdf.XFDFAnnotationInk;
import com.adobe.internal.xfdf.XFDFAnnotationLine;
import com.adobe.internal.xfdf.XFDFAnnotationLink;
import com.adobe.internal.xfdf.XFDFAnnotationPopup;
import com.adobe.internal.xfdf.XFDFAnnotationSound;
import com.adobe.internal.xfdf.XFDFAnnotationSquare;
import com.adobe.internal.xfdf.XFDFAnnotationStrikeOut;
import com.adobe.internal.xfdf.XFDFAnnotationText;
import com.adobe.internal.xfdf.XFDFAnnotationUnderline;
import com.adobe.internal.xfdf.XFDFCopyBlob2String;
import com.adobe.pdf.exceptions.XFDFParseException;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XFDF2PDFAnnotationReader
extends DefaultHandler {
    private int skipElement = 0;
    private int inValue = 0;
    private int countXDP = 0;
    private int countXFDF = 0;
    private boolean inXFDF = false;
    private boolean inAnnot = false;
    private int countAnnots = 0;
    private int dbgInt = 0;
    private int curPage = -1;
    private PDFDocument pdfDoc = null;
    private PDFAnnotation curAnnot = null;
    private XFDFAnnotation xfdfAnnot = null;
    private StringBuffer valuesBuff = null;
    private boolean rawMode = false;
    private ArrayList inReplyToList = null;
    private XFDFCopyBlob2String richTextBlob = null;
    private static final String F_NAME = "f";
    private static final String IDS_NAME = "ids";
    private static final String ANNOTS_NAME = "annots";
    private static final String XFDF_NAME = "xfdf";
    private static final String XDP_NAME = "xdp";

    public XFDF2PDFAnnotationReader(PDFDocument pDFDocument) {
        this.pdfDoc = pDFDocument;
    }

    private void markInReplyToEntry(PDFAnnotation pDFAnnotation, String string) {
        if (string == null || pDFAnnotation == null || !(pDFAnnotation instanceof PDFAnnotationText)) {
            return;
        }
        if (this.inReplyToList == null) {
            this.inReplyToList = new ArrayList();
        }
        this.inReplyToList.add(new InReplyTo((PDFAnnotationText)pDFAnnotation, string));
    }

    private int findReferencingAnnotation(String string, int n) {
        for (int i = n; i < this.inReplyToList.size(); ++i) {
            if (!string.equals(((InReplyTo)this.inReplyToList.get(i)).annotName)) continue;
            return i;
        }
        return -1;
    }

    private void createDefaultStyle(String string) {
        if (this.curAnnot instanceof PDFAnnotationFreeText) {
            this.curAnnot.setDefaultStyle(string);
        }
    }

    private void createDefaultAppearance(String string) {
        if (this.curAnnot instanceof PDFAnnotationFreeText) {
            this.curAnnot.setDefaultAppearance(string);
        }
    }

    static String getElementType(String string, String string2) {
        String string3 = string;
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        return string3;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.skipElement = 0;
        this.inValue = 0;
        this.countXFDF = 0;
        this.countXDP = 0;
        this.inXFDF = false;
        this.inAnnot = false;
        this.countAnnots = 0;
        this.inReplyToList = null;
        this.valuesBuff = new StringBuffer("");
    }

    public void endDocument() throws SAXException {
        if (this.inReplyToList != null) {
            PDFPage pDFPage;
            PDFPageTree pDFPageTree = this.pdfDoc.requirePages();
            int n = 0;
            while ((pDFPage = pDFPageTree.getPage(n++)) != null) {
                PDFAnnotationList pDFAnnotationList = pDFPage.getAnnotationList();
                if (pDFAnnotationList == null) continue;
                for (int i = 0; i < pDFAnnotationList.size(); ++i) {
                    PDFAnnotation pDFAnnotation = (PDFAnnotation)pDFAnnotationList.get(i);
                    if (pDFAnnotation == null) continue;
                    int n2 = 0;
                    String string = pDFAnnotation.getName();
                    if (string == null) continue;
                    while ((n2 = this.findReferencingAnnotation(string, n2)) != -1) {
                        PDFAnnotationText pDFAnnotationText = ((InReplyTo)this.inReplyToList.get(n2++)).textAnnot;
                        pDFAnnotationText.setInReplyTo(pDFAnnotation);
                    }
                }
            }
        }
        this.inReplyToList = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = XFDF2PDFAnnotationReader.getElementType(string2, string3);
        if (string4 == null || string4.length() == 0) {
            throw new XFDFParseException("Wrong XFDF structure");
        }
        if (string4.equals(XDP_NAME)) {
            ++this.countXDP;
            if (this.countXDP > 1) {
                ++this.skipElement;
            } else {
                return;
            }
        }
        if (string4.equals(XFDF_NAME)) {
            ++this.countXFDF;
            this.inXFDF = true;
        }
        if (string4.equals(ANNOTS_NAME)) {
            ++this.countAnnots;
            this.inAnnot = true;
        }
        if (this.skipElement > 0 || this.countXFDF != 1 || !this.inXFDF && this.countAnnots != 1) {
            ++this.skipElement;
        } else if (this.xfdfAnnot == null) {
            if (string4.equals("text")) {
                this.xfdfAnnot = new XFDFAnnotationText(this.pdfDoc);
            } else if (string4.equals("circle")) {
                this.xfdfAnnot = new XFDFAnnotationCircle(this.pdfDoc);
            } else if (string4.equals("freetext")) {
                this.xfdfAnnot = new XFDFAnnotationFreeText(this.pdfDoc);
            } else if (string4.equals("highlight")) {
                this.xfdfAnnot = new XFDFAnnotationHighlight(this.pdfDoc);
            } else if (string4.equals("square")) {
                this.xfdfAnnot = new XFDFAnnotationSquare(this.pdfDoc);
            } else if (string4.equals("strikeout")) {
                this.xfdfAnnot = new XFDFAnnotationStrikeOut(this.pdfDoc);
            } else if (string4.equals("underline")) {
                this.xfdfAnnot = new XFDFAnnotationUnderline(this.pdfDoc);
            } else if (string4.equals("ink")) {
                this.xfdfAnnot = new XFDFAnnotationInk(this.pdfDoc);
            } else if (string4.equals("line")) {
                this.xfdfAnnot = new XFDFAnnotationLine(this.pdfDoc);
            } else if (string4.equals("link")) {
                this.xfdfAnnot = new XFDFAnnotationLink(this.pdfDoc);
            } else if (string4.equals("sound")) {
                this.xfdfAnnot = new XFDFAnnotationSound(this.pdfDoc);
            } else if (string4.equals("fileattachment")) {
                this.xfdfAnnot = new XFDFAnnotationFileAttachment(this.pdfDoc);
            }
            if (this.xfdfAnnot == null) {
                if (!this.inXFDF && !this.inAnnot) {
                    ++this.skipElement;
                }
            } else {
                this.curAnnot = this.xfdfAnnot.createPDFAnnotation(attributes);
                this.curPage = this.xfdfAnnot.getCurPage();
                this.markInReplyToEntry(this.curAnnot, this.xfdfAnnot.getInReplyTo(attributes));
            }
        } else if (string4.equals("contents-richtext")) {
            this.richTextBlob = new XFDFCopyBlob2String();
            ++this.inValue;
        } else {
            if (this.richTextBlob != null) {
                this.richTextBlob.startElement(string, string2, string3, attributes);
                return;
            }
            if (string4.equals("data")) {
                if (this.curAnnot == null || this.inValue > 0) {
                    ++this.skipElement;
                } else {
                    this.rawMode = this.xfdfAnnot.startDataStream(attributes);
                }
                ++this.inValue;
            } else if (!string4.equals("inklist")) {
                if (string4.equals("contents") || string4.equals("gesture") || string4.equals("defaultstyle") || string4.equals("defaultappearance")) {
                    if (this.curAnnot == null || this.inValue > 0) {
                        ++this.skipElement;
                    }
                    ++this.inValue;
                } else if (string4.equals("OnActivation")) {
                    if (this.curAnnot == null || !(this.curAnnot instanceof PDFAnnotationLink)) {
                        ++this.skipElement;
                    } else {
                        PDFAnnotationLink pDFAnnotationLink = (PDFAnnotationLink)this.curAnnot;
                        pDFAnnotationLink.removeDestination();
                        PDFActions pDFActions = PDFActions.create(pDFAnnotationLink.getPDFDocument());
                        pDFAnnotationLink.setActions(pDFActions);
                    }
                } else if (string4.equals("Action")) {
                    if (!(this.curAnnot instanceof PDFAnnotationLink)) {
                        ++this.skipElement;
                    }
                } else if (string4.equals("URI") || string4.equals("Launch") || string4.equals("GoTo") || string4.equals("GoToR")) {
                    if (!(this.curAnnot instanceof PDFAnnotationLink) || !((XFDFAnnotationLink)this.xfdfAnnot).createAction(string4, attributes, (PDFAnnotationLink)this.curAnnot)) {
                        ++this.skipElement;
                    }
                } else if (string4.equals("Dest")) {
                    if (this.xfdfAnnot == null || !(this.xfdfAnnot instanceof XFDFAnnotationLink)) {
                        ++this.skipElement;
                    } else {
                        ((XFDFAnnotationLink)this.xfdfAnnot).setInDestination(true);
                    }
                } else if (string4.equals("XYZ") || string4.equals("Fit") || string4.equals("FitH") || string4.equals("FitV") || string4.equals("FitR") || string4.equals("FitB") || string4.equals("FitBH") || string4.equals("FitBV")) {
                    if (this.xfdfAnnot == null || !(this.xfdfAnnot instanceof XFDFAnnotationLink) || !((XFDFAnnotationLink)this.xfdfAnnot).createDestination(string4, attributes)) {
                        ++this.skipElement;
                    }
                } else if (string4.equals("Named")) {
                    if (this.xfdfAnnot == null || !(this.xfdfAnnot instanceof XFDFAnnotationLink)) {
                        ++this.skipElement;
                    } else if (!(!((XFDFAnnotationLink)this.xfdfAnnot).getInDestination() ? ((XFDFAnnotationLink)this.xfdfAnnot).createAction(string4, attributes, (PDFAnnotationLink)this.curAnnot) : ((XFDFAnnotationLink)this.xfdfAnnot).createDestination(string4, attributes))) {
                        ++this.skipElement;
                    }
                } else if (string4.equals("File")) {
                    if (this.xfdfAnnot == null || !(this.xfdfAnnot instanceof XFDFAnnotationLink)) {
                        ++this.skipElement;
                    } else {
                        ((XFDFAnnotationLink)this.xfdfAnnot).createFileSpec(attributes);
                    }
                } else if (string4.equals("BorderStyleAlt")) {
                    if (this.xfdfAnnot == null || !(this.xfdfAnnot instanceof XFDFAnnotationLink)) {
                        ++this.skipElement;
                    } else if (!((XFDFAnnotationLink)this.xfdfAnnot).createAltBorder(attributes)) {
                        ++this.skipElement;
                    }
                } else if (string4.equals("popup")) {
                    if (this.curPage != -1 && this.xfdfAnnot != null && this.curAnnot != null) {
                        XFDFAnnotationPopup xFDFAnnotationPopup = new XFDFAnnotationPopup(this.xfdfAnnot);
                        xFDFAnnotationPopup.createPDFAnnotation(attributes);
                    } else {
                        ++this.skipElement;
                    }
                } else if (!this.inXFDF && !this.inAnnot) {
                    ++this.skipElement;
                }
            }
        }
        this.inXFDF = false;
        this.inAnnot = false;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = XFDF2PDFAnnotationReader.getElementType(string2, string3);
        if (string4 == null || string4.length() == 0) {
            throw new XFDFParseException("Wrong XFDF structure");
        }
        if (this.skipElement > 0) {
            --this.skipElement;
        } else if (string4.equals("contents-richtext")) {
            if (this.richTextBlob != null && this.inValue == 1) {
                String string5;
                String string6 = this.richTextBlob.getBlob();
                if (string6 != null) {
                    this.curAnnot.setRichContents(string6);
                }
                if ((string5 = this.richTextBlob.getRawContent()) != null) {
                    this.curAnnot.setContents(string5);
                }
                this.richTextBlob = null;
                --this.inValue;
            }
        } else {
            if (this.richTextBlob != null) {
                this.richTextBlob.endElement(string, string2, string3);
                return;
            }
            if (string4.equals("text") || string4.equals("circle") || string4.equals("fileattachment") || string4.equals("freetext") || string4.equals("highlight") || string4.equals("square") || string4.equals("strikeout") || string4.equals("underline") || string4.equals("sound") || string4.equals("ink") || string4.equals("line") || string4.equals("link")) {
                this.curAnnot = null;
                this.xfdfAnnot = null;
                this.curPage = -1;
            } else if (string4.equals("contents")) {
                --this.inValue;
                if (this.inValue == 0 && this.curAnnot != null) {
                    this.curAnnot.setContents(this.valuesBuff.toString());
                    this.valuesBuff.setLength(0);
                }
            } else if (string4.equals("gesture")) {
                --this.inValue;
                if (this.inValue == 0 && this.curAnnot != null) {
                    if (this.xfdfAnnot instanceof XFDFAnnotationInk) {
                        ((XFDFAnnotationInk)this.xfdfAnnot).createInk(this.valuesBuff.toString());
                    }
                    this.valuesBuff.setLength(0);
                }
            } else if (string4.equals("defaultstyle")) {
                --this.inValue;
                if (this.inValue == 0 && this.curAnnot != null) {
                    this.createDefaultStyle(this.valuesBuff.toString());
                    this.valuesBuff.setLength(0);
                }
            } else if (string4.equals("defaultappearance")) {
                --this.inValue;
                if (this.inValue == 0 && this.curAnnot != null) {
                    this.createDefaultAppearance(this.valuesBuff.toString());
                    this.valuesBuff.setLength(0);
                }
            } else if (string4.equals("data")) {
                --this.inValue;
                if (this.inValue == 0 && this.curAnnot != null) {
                    this.xfdfAnnot.endDataStream(this.valuesBuff.toString(), this.rawMode);
                    this.valuesBuff.setLength(0);
                }
            } else if (string4.equals(XFDF_NAME)) {
                if (this.countXFDF > 1) {
                    --this.countXFDF;
                }
            } else if (string4.equals(XDP_NAME)) {
                if (this.countXDP > 1) {
                    --this.countXDP;
                }
            } else if (string4.equals(ANNOTS_NAME) && this.countAnnots > 1) {
                --this.countAnnots;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.skipElement > 0 || this.inValue != 1) {
            return;
        }
        if (this.richTextBlob != null) {
            this.richTextBlob.copyCharacters(cArray, n, n2);
        } else {
            String string = new String(cArray, n, n2);
            if (this.valuesBuff == null) {
                this.valuesBuff = new StringBuffer(string);
            } else {
                this.valuesBuff.append(string);
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    private class InReplyTo {
        private PDFAnnotationText textAnnot;
        private String annotName;

        InReplyTo(PDFAnnotationText pDFAnnotationText, String string) {
            this.textAnnot = pDFAnnotationText;
            this.annotName = string;
        }
    }
}

