/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.internal.pdf.PDFField;
import com.adobe.internal.pdf.PDFFieldButton;
import com.adobe.internal.pdf.PDFFieldSignature;
import com.adobe.internal.pdf.PDFInteractiveForm;
import com.adobe.internal.pdf.cos.util.Utility;
import com.adobe.internal.xfdf.XFDFFieldList;
import com.adobe.pdf.exceptions.XFDFException;
import com.adobe.pdf.exceptions.XFDFParseException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class PDF2XFDFFormsReader
implements XMLReader {
    ContentHandler handler;
    static final String nsu = "";
    static final Attributes nullAtts = new AttributesImpl();
    static final String rootElement = "xfdf";
    static final String secondRoot = "fields";
    private PDFInteractiveForm iform;
    private String ATTR_NAME = "name";
    private String ELEM_FIELD = "field";

    public PDF2XFDFFormsReader(PDFInteractiveForm pDFInteractiveForm) {
        this.iform = pDFInteractiveForm;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (this.handler == null) {
            throw new XFDFException("No content handler");
        }
        XFDFFieldList xFDFFieldList = new XFDFFieldList(this.iform.getFieldList());
        if (xFDFFieldList.isEmpty()) {
            throw new XFDFParseException("No Field List");
        }
        this.handler.startDocument();
        this.handler.startElement(nsu, rootElement, rootElement, Utility.createXFDFAttributes());
        this.handler.startElement(nsu, secondRoot, secondRoot, nullAtts);
        this.outputIForm(xFDFFieldList);
        this.handler.endElement(nsu, secondRoot, secondRoot);
        this.handler.endElement(nsu, rootElement, rootElement);
        this.handler.endDocument();
    }

    private void outputIForm(XFDFFieldList xFDFFieldList) throws IOException, SAXException {
        Iterator iterator = xFDFFieldList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof PDFFieldSignature) continue;
            String string = null;
            if (e instanceof XFDFFieldList) {
                string = ((XFDFFieldList)e).getName();
            } else if (e instanceof PDFField) {
                if (!((PDFField)e).noExport()) {
                    string = ((PDFField)e).getPartialName();
                }
            } else {
                throw new RuntimeException();
            }
            if (string == null) continue;
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute(nsu, this.ATTR_NAME, this.ATTR_NAME, "string", XFDFFieldList.getBaseFieldName(string));
            this.handler.startElement(nsu, this.ELEM_FIELD, this.ELEM_FIELD, attributesImpl);
            boolean bl = false;
            if (e instanceof PDFField) {
                PDFField pDFField = (PDFField)e;
                bl |= this.outputValues(pDFField);
                bl |= this.outputValue("value_richtext", pDFField.getValueRichText());
            }
            if (!bl && e instanceof XFDFFieldList) {
                this.outputIForm((XFDFFieldList)e);
            }
            this.handler.endElement(nsu, this.ELEM_FIELD, this.ELEM_FIELD);
        }
    }

    private boolean outputValues(PDFField pDFField) throws IOException, SAXException {
        boolean bl = false;
        List list = pDFField.getValueList();
        if (list == null) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!pDFField.hasOptionList() || !(pDFField instanceof PDFFieldButton)) {
                bl |= this.outputValue("value", string);
                continue;
            }
            List list2 = pDFField.getOptionList();
            int n = this.getIndexFromString(string);
            if (n < 0 || n >= list2.size()) continue;
            bl |= this.outputValue("value", (String)list2.get(n));
        }
        return bl;
    }

    private boolean outputValue(String string, Object object) throws IOException, SAXException {
        if (object != null) {
            if (!(object instanceof String)) {
                throw new RuntimeException();
            }
            this.handler.startElement(nsu, string, string, nullAtts);
            this.handler.characters(((String)object).toCharArray(), 0, ((String)object).length());
            this.handler.endElement(nsu, string, string);
            return true;
        }
        return false;
    }

    private int getIndexFromString(String string) {
        int n;
        try {
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.handler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(String string) throws IOException, SAXException {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public Object getProperty(String string) {
        return null;
    }

    public void setProperty(String string, Object object) {
    }

    public void setFeature(String string, boolean bl) {
    }

    public boolean getFeature(String string) {
        return false;
    }
}

