/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfdf;

import com.adobe.internal.pdf.PDFAnnotation;
import com.adobe.internal.pdf.PDFAnnotationList;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFPage;
import com.adobe.internal.pdf.PDFPageTree;
import com.adobe.internal.pdf.cos.util.Utility;
import com.adobe.internal.xfdf.XFDFAnnotation;
import com.adobe.pdf.exceptions.XFDFException;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class PDF2XFDFAnnotationsReader
implements XMLReader {
    ContentHandler handler;
    static final String nsu = "";
    static final Attributes nullAtts = new AttributesImpl();
    static final String rootElement = "xfdf";
    static final String secondRoot = "annots";
    private PDFDocument doc;

    public PDF2XFDFAnnotationsReader(PDFDocument pDFDocument) {
        this.doc = pDFDocument;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (this.handler == null) {
            throw new XFDFException("No content handler");
        }
        this.handler.startDocument();
        this.HandleAnnotations(true);
        this.handler.endDocument();
    }

    private void startAnnotations() throws SAXException {
        this.handler.startElement(nsu, rootElement, rootElement, Utility.createXFDFAttributes());
        this.handler.startElement(nsu, secondRoot, secondRoot, nullAtts);
    }

    private void endAnnotations() throws SAXException {
        this.handler.endElement(nsu, secondRoot, secondRoot);
        this.handler.endElement(nsu, rootElement, rootElement);
    }

    public void HandleAnnotations(boolean bl) throws IOException, SAXException {
        if (this.outputAnnotations(this.doc, bl)) {
            this.endAnnotations();
        }
    }

    private boolean outputAnnotations(PDFDocument pDFDocument, boolean bl) throws SAXException {
        PDFPage pDFPage;
        boolean bl2 = false;
        PDFPageTree pDFPageTree = pDFDocument.requirePages();
        int n = 0;
        if (bl) {
            this.startAnnotations();
            bl2 = true;
        }
        while ((pDFPage = pDFPageTree.getPage(n++)) != null) {
            PDFAnnotationList pDFAnnotationList = pDFPage.getAnnotationList();
            if (pDFAnnotationList == null) continue;
            if (!bl2) {
                this.startAnnotations();
                bl2 = true;
            }
            for (int i = 0; i < pDFAnnotationList.size(); ++i) {
                XFDFAnnotation xFDFAnnotation;
                PDFAnnotation pDFAnnotation = (PDFAnnotation)pDFAnnotationList.get(i);
                if (pDFAnnotation == null || (xFDFAnnotation = XFDFAnnotation.createXFDFAnnotation(pDFAnnotation)) == null) continue;
                xFDFAnnotation.transformToXFDF(this.handler, n - 1);
            }
        }
        return bl2;
    }

    private int getIndexFromString(String string) {
        int n;
        try {
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.handler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(String string) throws IOException, SAXException {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public Object getProperty(String string) {
        return null;
    }

    public void setProperty(String string, Object object) {
    }

    public void setFeature(String string, boolean bl) {
    }

    public boolean getFeature(String string) {
        return false;
    }
}

