/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfa;

import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.CosString;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.pdf.exceptions.XFAParseException;
import java.io.IOException;
import java.io.InputStream;

public class StreamsArray
extends InputStream {
    PendingArray m_pending;
    byte[] m_bytes;
    int m_pos;
    ByteStream m_stm;

    public StreamsArray(CosArray cosArray) {
        this.m_pending = new PendingArray(cosArray, null);
        this.m_bytes = null;
        this.m_stm = null;
    }

    public int read() throws IOException {
        do {
            if (this.m_stm != null) {
                int n = this.m_stm.read();
                if (n != -1) {
                    return n;
                }
                this.m_stm = null;
            } else if (this.m_bytes != null) {
                if (this.m_pos < this.m_bytes.length) {
                    return this.m_bytes[this.m_pos++];
                }
                this.m_bytes = null;
            }
            if (this.m_pending == null) {
                return -1;
            }
            CosObject cosObject = this.m_pending.NextItem();
            if (cosObject == null) {
                this.m_pending = this.m_pending.getPrev();
                continue;
            }
            switch (cosObject.getType()) {
                case 7: {
                    this.m_stm = ((CosStream)cosObject).getStream();
                    break;
                }
                case 4: {
                    this.m_bytes = ((CosString)cosObject).byteArrayValue();
                    this.m_pos = 0;
                    break;
                }
                case 5: {
                    this.m_pending = new PendingArray((CosArray)cosObject, this.m_pending);
                    break;
                }
                default: {
                    throw new XFAParseException("invalid entry in XFA array");
                }
            }
        } while (this.m_pending != null);
        return -1;
    }

    public int available() throws IOException {
        do {
            if (this.m_stm != null) {
                int n = this.m_stm.available();
                if (n > 0) {
                    return n;
                }
                this.m_stm = null;
            } else if (this.m_bytes != null) {
                int n = this.m_bytes.length - this.m_pos;
                if (n > 0) {
                    return n;
                }
                this.m_bytes = null;
            }
            if (this.m_pending == null) {
                return 0;
            }
            CosObject cosObject = this.m_pending.NextItem();
            if (cosObject == null) {
                this.m_pending = this.m_pending.getPrev();
                continue;
            }
            switch (cosObject.getType()) {
                case 7: {
                    this.m_stm = ((CosStream)cosObject).getStream();
                    break;
                }
                case 4: {
                    this.m_bytes = ((CosString)cosObject).byteArrayValue();
                    this.m_pos = 0;
                    break;
                }
                case 5: {
                    this.m_pending = new PendingArray((CosArray)cosObject, this.m_pending);
                    break;
                }
                default: {
                    throw new XFAParseException("invalid entry in XFA array");
                }
            }
        } while (this.m_pending != null);
        return 0;
    }

    class PendingArray {
        CosArray m_array;
        int m_index;
        PendingArray m_prev;

        PendingArray(CosArray cosArray, PendingArray pendingArray) {
            this.m_array = cosArray;
            this.m_index = -1;
            this.m_prev = pendingArray;
        }

        CosObject NextItem() {
            ++this.m_index;
            int n = 2 * this.m_index + 1;
            if (n >= this.m_array.size()) {
                return null;
            }
            return this.m_array.get(n);
        }

        PendingArray getPrev() {
            return this.m_prev;
        }
    }
}

