/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfa;

import com.adobe.internal.pdf.PDFInteractiveForm;
import com.adobe.internal.xfa.XFAConfigurationException;
import com.adobe.pdf.exceptions.XFAParseException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class PDFXFAOutput
extends DefaultHandler
implements XMLReader {
    ContentHandler mOutputHandler;
    private boolean mCopying;
    private boolean inDatasets;
    private boolean mHadData;
    private boolean mMultipleRoot;
    private boolean mXFADefined;
    private int mOutputLevel;
    static final String nsu = "";
    static final Attributes nullAtts = new AttributesImpl();
    static final String datasetsName = "xfa:datasets";
    static final String dataName = "xfa:data";
    PDFInteractiveForm mForm;

    public PDFXFAOutput(PDFInteractiveForm pDFInteractiveForm, boolean bl) {
        this.mForm = pDFInteractiveForm;
        this.mCopying = false;
        this.inDatasets = false;
        this.mHadData = false;
        this.mMultipleRoot = false;
        this.mXFADefined = bl;
        this.mOutputLevel = 0;
    }

    public boolean hasMultipleRoot() {
        return this.mMultipleRoot;
    }

    public boolean hasXFADefined() {
        return this.mXFADefined;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (this.mOutputHandler == null) {
            throw new SAXException("No content handler");
        }
        this.mOutputHandler.startDocument();
        this.HandleData(inputSource);
        this.mOutputHandler.endDocument();
    }

    public void HandleData(InputSource inputSource) throws SAXException, IOException {
        InputStream inputStream = inputSource.getByteStream();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XFAConfigurationException(parserConfigurationException.getMessage());
        }
    }

    public boolean hadData() {
        return this.mHadData;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.mCopying) {
            if (!this.mXFADefined) {
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    String string4 = attributes.getQName(i);
                    if (string4.indexOf("xfa:") < 0) continue;
                    AttributesImpl attributesImpl = new AttributesImpl();
                    attributesImpl.addAttribute(nsu, nsu, "xmlns:xfa", "CDATA", "http://www.xfa.org/schema/xfa-data/1.0/");
                    for (int j = 0; j < n; ++j) {
                        attributesImpl.addAttribute(attributes.getURI(j), attributes.getLocalName(j), attributes.getQName(j), attributes.getType(j), attributes.getValue(j));
                    }
                    attributes = attributesImpl;
                    this.mXFADefined = true;
                    break;
                }
            }
            this.mOutputHandler.startElement(string, string2, string3, attributes);
            if (this.mHadData && this.mOutputLevel == 0) {
                this.mMultipleRoot = true;
            }
            this.mHadData = true;
            ++this.mOutputLevel;
        } else {
            String string5 = string2;
            if (string5 == null || string5.length() == 0) {
                string5 = string3;
            }
            if (string5 == null || string5.length() == 0) {
                throw new XFAParseException("Wrong XML structure");
            }
            if (this.inDatasets) {
                if (string5.equals(dataName)) {
                    this.mCopying = true;
                }
            } else if (string5.equals(datasetsName)) {
                this.inDatasets = true;
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.mCopying) {
            String string4 = string2;
            if (string4 == null || string4.length() == 0) {
                string4 = string3;
            }
            if (string4 == null || string4.length() == 0) {
                throw new XFAParseException("Wrong XML structure");
            }
            if (string4.equals(dataName)) {
                this.mCopying = false;
            }
        }
        if (this.mCopying) {
            this.mOutputHandler.endElement(string, string2, string3);
            --this.mOutputLevel;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.mCopying) {
            this.mOutputHandler.characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.mCopying) {
            this.mOutputHandler.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.mOutputHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.mOutputHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(String string) throws IOException, SAXException {
    }
}

