/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfa;

import com.adobe.internal.pdf.PDFInteractiveForm;
import com.adobe.pdf.exceptions.PDFException;
import com.adobe.pdf.exceptions.XFAException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class PDFXFAInput
implements XMLReader {
    String[] mBoilerplate = new String[]{"xdp:xdp", "xfa:datasets", "xfa:data"};
    ContentHandler mOutputHandler;
    InputStream mNewData;
    PDFInteractiveForm mForm;

    private void InsertNewData(boolean bl) throws SAXException {
        SAXParser sAXParser;
        AttributesImpl attributesImpl;
        if (bl) {
            attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "", "xmlns:xfa", "CDATA", "http://www.xfa.org/schema/xfa-data/1.0/");
            this.mOutputHandler.startElement("", "", "xfa:datasets", attributesImpl);
        }
        attributesImpl = new AttributesImpl();
        this.mOutputHandler.startElement("", "", "xfa:data", attributesImpl);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        XFANewDataCopier xFANewDataCopier = new XFANewDataCopier();
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new PDFException("got configuration exception");
        }
        try {
            sAXParser.parse(this.mNewData, (DefaultHandler)xFANewDataCopier);
        }
        catch (IOException iOException) {
            throw new PDFException("io exception on XFA input");
        }
        this.mOutputHandler.endElement("", "", "xfa:data");
        if (bl) {
            this.mOutputHandler.endElement("", "", "xfa:datasets");
        }
    }

    public PDFXFAInput(PDFInteractiveForm pDFInteractiveForm, InputStream inputStream) {
        this.mForm = pDFInteractiveForm;
        this.mNewData = inputStream;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.mOutputHandler.startDocument();
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null) {
            SAXParser sAXParser;
            XFABoilerplateCopier xFABoilerplateCopier = new XFABoilerplateCopier();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            try {
                sAXParser = sAXParserFactory.newSAXParser();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new XFAException(parserConfigurationException.getMessage());
            }
            sAXParser.parse(inputStream, (DefaultHandler)xFABoilerplateCopier);
        } else {
            this.InsertNewData(true);
        }
        this.mOutputHandler.endDocument();
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.mOutputHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.mOutputHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(String string) throws IOException, SAXException {
    }

    class XFANewDataCopier
    extends XFAStreamCopier {
        boolean haveBP;
        boolean alreadyCopied;
        int mBPIndex;
        int targetLevel;
        int copyLevel;

        XFANewDataCopier() {
            this.mCopying = false;
            this.alreadyCopied = false;
            this.mBPIndex = 0;
        }

        void NoteEnding(String string) throws SAXException {
        }

        int StartCopyingAfterStart(String string) throws SAXException {
            if (this.alreadyCopied) {
                return 0;
            }
            if (this.mNestingLevel == 1) {
                if (string.equals("xdp:xdp")) {
                    this.haveBP = true;
                    this.mBPIndex = 1;
                    this.targetLevel = this.mNestingLevel + 1;
                } else {
                    this.copyLevel = 0;
                    return 1;
                }
            }
            if (this.haveBP && this.mNestingLevel == this.targetLevel && string.equals(PDFXFAInput.this.mBoilerplate[this.mBPIndex])) {
                ++this.mBPIndex;
                if (this.mBPIndex >= 3) {
                    this.copyLevel = this.mNestingLevel;
                    return 2;
                }
                this.targetLevel = this.mNestingLevel + 1;
            }
            return 0;
        }

        boolean StartCopyingAfterEnd(String string) throws SAXException {
            return false;
        }

        boolean StopCopyingAfterStart(String string) throws SAXException {
            return false;
        }

        boolean StopCopyingBeforeEnd(String string) throws SAXException {
            if (this.mNestingLevel == this.copyLevel) {
                this.alreadyCopied = true;
                return true;
            }
            return false;
        }
    }

    class XFABoilerplateCopier
    extends XFAStreamCopier {
        boolean dataInserted;
        boolean haveDatasets = false;

        XFABoilerplateCopier() {
            this.mCopying = true;
            this.dataInserted = false;
        }

        int StartCopyingAfterStart(String string) throws SAXException {
            return 0;
        }

        boolean StartCopyingAfterEnd(String string) throws SAXException {
            return string.equals("xfa:data") || string.equals("xfa:datasets");
        }

        boolean StopCopyingBeforeEnd(String string) throws SAXException {
            return false;
        }

        boolean StopCopyingAfterStart(String string) throws SAXException {
            if (string.equals("xfa:data")) {
                PDFXFAInput.this.InsertNewData(false);
                this.dataInserted = true;
                return true;
            }
            return false;
        }

        void NoteEnding(String string) throws SAXException {
            if (string.equals("xfa:datasets") && !this.dataInserted) {
                PDFXFAInput.this.InsertNewData(false);
                this.dataInserted = true;
            }
            if (string.equals("xdp:xdp") && !this.dataInserted) {
                PDFXFAInput.this.InsertNewData(true);
                this.dataInserted = true;
            }
        }
    }

    abstract class XFAStreamCopier
    extends DefaultHandler {
        static final int s_noChange = 0;
        static final int s_copyFromThis = 1;
        static final int s_copyAfterThis = 2;
        int mNestingLevel;
        boolean mCopying;

        XFAStreamCopier() {
        }

        abstract int StartCopyingAfterStart(String var1) throws SAXException;

        abstract boolean StopCopyingAfterStart(String var1) throws SAXException;

        abstract boolean StartCopyingAfterEnd(String var1) throws SAXException;

        abstract boolean StopCopyingBeforeEnd(String var1) throws SAXException;

        abstract void NoteEnding(String var1) throws SAXException;

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
            this.mNestingLevel = 0;
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this.mNestingLevel;
            int n = 0;
            String string4 = string2;
            if (string4 == null || string4.length() == 0) {
                string4 = string3;
            }
            if (string4 == null || string4.length() == 0) {
                throw new SAXException("Wrong XML structure");
            }
            if (!this.mCopying) {
                n = this.StartCopyingAfterStart(string4);
                if (n == 1) {
                    this.mCopying = true;
                }
            } else if (this.StopCopyingAfterStart(string4)) {
                this.mCopying = false;
            }
            if (this.mCopying) {
                PDFXFAInput.this.mOutputHandler.startElement(string, string2, string3, attributes);
            }
            if (n == 2) {
                this.mCopying = true;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            String string4 = string2;
            if (string4 == null || string4.length() == 0) {
                string4 = string3;
            }
            if (string4 == null || string4.length() == 0) {
                throw new SAXException("Wrong XML structure");
            }
            this.NoteEnding(string4);
            if (this.mCopying) {
                if (this.StopCopyingBeforeEnd(string4)) {
                    this.mCopying = false;
                } else {
                    PDFXFAInput.this.mOutputHandler.endElement(string, string2, string3);
                }
            } else if (this.StartCopyingAfterEnd(string4)) {
                this.mCopying = true;
            }
            --this.mNestingLevel;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.mCopying) {
                PDFXFAInput.this.mOutputHandler.characters(cArray, n, n2);
            }
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            if (this.mCopying) {
                PDFXFAInput.this.mOutputHandler.ignorableWhitespace(cArray, n, n2);
            }
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }
    }
}

