/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xfa;

import com.adobe.internal.pdf.PDFInteractiveForm;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosDocument;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.CosString;
import com.adobe.internal.pdf.cos.util.ByteArrayByteRepository;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.IO;
import com.adobe.internal.pdf.cos.util.OutputByteBuffer;
import com.adobe.internal.pdf.cos.util.Utility;
import com.adobe.internal.xfa.PDFXFAInput;
import com.adobe.internal.xfa.PDFXFAOutput;
import com.adobe.internal.xfa.StreamsArray;
import com.adobe.pdf.exceptions.PDFException;
import com.adobe.pdf.exceptions.XFAParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PDFFormSupport {
    public static ByteStream exportXFAData(PDFInteractiveForm pDFInteractiveForm) throws SAXException, TransformerConfigurationException, TransformerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        CosObject cosObject = pDFInteractiveForm.getXFA();
        InputStream inputStream = null;
        if (cosObject instanceof CosArray) {
            object4 = (CosArray)cosObject;
            object3 = new byte[]{100, 97, 116, 97, 115, 101, 116, 115};
            object2 = new int[]{-1, 0, 0, 0, 0, 0, 0, 0};
            for (int i = 0; i < ((CosArray)object4).size(); i += 2) {
                int n = i + 1;
                object = ((CosArray)object4).get(i);
                if (!(object instanceof CosString) || Utility.KMPFindFirst((byte[])object3, (int[])object2, ((CosString)object).byteArrayValue()) == -1) continue;
                CosObject cosObject2 = ((CosArray)object4).get(n);
                inputStream = PDFFormSupport.AStreamComeTrue(cosObject2);
                break;
            }
        }
        if (inputStream == null) {
            inputStream = PDFFormSupport.AStreamComeTrue(cosObject);
        }
        object4 = new OutputByteBuffer();
        object3 = new PDFXFAOutput(pDFInteractiveForm, false);
        Utility.transformToXML((XMLReader)object3, inputStream, (OutputStream)object4);
        if (((PDFXFAOutput)object3).hadData()) {
            if (((PDFXFAOutput)object3).hasMultipleRoot()) {
                object2 = new ByteStream(((OutputByteBuffer)object4).getBuffer());
                object4 = new OutputByteBuffer();
                try {
                    PDFFormSupport.copyInstructions((ByteStream)object2, (OutputByteBuffer)object4);
                    String string = "<xfa:data xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\"\n>";
                    ((OutputByteBuffer)object4).write(string.getBytes());
                    if (((PDFXFAOutput)object3).hasXFADefined()) {
                        ByteStream byteStream = new ByteStream((InputStream)object2);
                        object = "xmlns:xfa";
                        long l = byteStream.indexOf(((String)object).getBytes());
                        if (l < 0L) {
                            throw new PDFException("logic error, can't find xmlns:xfa");
                        }
                        byteStream.setPosition(l);
                        int n = 0;
                        while (n < 2) {
                            if (byteStream.get() != 34) continue;
                            ++n;
                        }
                        long l2 = byteStream.getPosition();
                        ByteStream byteStream2 = byteStream.slice(0L, l);
                        ByteStream byteStream3 = byteStream.slice(l2, byteStream.limit() - l2);
                        IO.copy(byteStream2, (OutputStream)object4);
                        IO.copy(byteStream3, (OutputStream)object4);
                    } else {
                        IO.copy((InputStream)object2, (OutputStream)object4);
                    }
                    String string2 = "</xfa:data\n>";
                    ((OutputByteBuffer)object4).write(string2.getBytes());
                }
                catch (IOException iOException) {
                    throw new PDFException("trouble copying data" + iOException.getMessage());
                }
            }
            return new ByteStream(((OutputByteBuffer)object4).getBuffer());
        }
        return null;
    }

    private static void copyInstructions(ByteStream byteStream, OutputByteBuffer outputByteBuffer) throws IOException {
        byte[] byArray = new byte[]{60, 63};
        while (!byteStream.eof()) {
            byte by = byteStream.get();
            if (by == 60) {
                byte by2 = byteStream.get();
                if (by2 != 63) {
                    byteStream.unget();
                    byteStream.unget();
                    return;
                }
                outputByteBuffer.write(byArray);
                continue;
            }
            outputByteBuffer.write(by);
        }
    }

    public static void importXFAData(PDFInteractiveForm pDFInteractiveForm, InputStream inputStream) throws SAXException, TransformerConfigurationException, TransformerException {
        OutputByteBuffer outputByteBuffer = new OutputByteBuffer();
        CosObject cosObject = pDFInteractiveForm.getXFA();
        CosDocument cosDocument = pDFInteractiveForm.getPDFDocument().getDocument();
        if (cosObject instanceof CosStream) {
            CosStream cosStream = (CosStream)cosObject;
            Utility.transformToXML(new PDFXFAInput(pDFInteractiveForm, inputStream), cosStream.getStream(), outputByteBuffer);
            cosStream.newData(outputByteBuffer.getBuffer());
            return;
        }
        if (cosObject instanceof CosArray) {
            CosArray cosArray = (CosArray)cosObject;
            byte[] byArray = new byte[]{100, 97, 116, 97, 115, 101, 116, 115};
            int[] nArray = new int[]{-1, 0, 0, 0, 0, 0, 0, 0};
            for (int i = 0; i < cosArray.size(); i += 2) {
                int n = i + 1;
                CosObject cosObject2 = cosArray.get(i);
                if (!(cosObject2 instanceof CosString) || Utility.KMPFindFirst(byArray, nArray, ((CosString)cosObject2).byteArrayValue()) == -1) continue;
                CosObject cosObject3 = cosArray.get(n);
                InputStream inputStream2 = PDFFormSupport.AStreamComeTrue(cosObject3);
                ByteStream byteStream = PDFFormSupport.GenerateDatasetsFragment(pDFInteractiveForm, inputStream2, inputStream, outputByteBuffer);
                if (cosObject3 instanceof CosStream) {
                    ((CosStream)cosObject3).newData(byteStream);
                } else {
                    CosStream cosStream = cosDocument.newStream(byteStream);
                    cosArray.set(n, cosStream);
                }
                return;
            }
            ByteStream byteStream = PDFFormSupport.GenerateDatasetsFragment(pDFInteractiveForm, null, inputStream, outputByteBuffer);
            CosStream cosStream = cosDocument.newStream(byteStream);
            int n = cosArray.size();
            int n2 = n - 2;
            cosArray.add(n2, cosStream);
            cosArray.add(n2, cosDocument.newString("datasets"));
            return;
        }
        InputStream inputStream3 = PDFFormSupport.AStreamComeTrue(cosObject);
        Utility.transformToXML(new PDFXFAInput(pDFInteractiveForm, inputStream), inputStream3, outputByteBuffer);
        CosStream cosStream = cosDocument.newStream(outputByteBuffer.getBuffer());
        pDFInteractiveForm.putXFA(cosStream);
    }

    private static ByteStream GenerateDatasetsFragment(PDFInteractiveForm pDFInteractiveForm, InputStream inputStream, InputStream inputStream2, OutputByteBuffer outputByteBuffer) throws SAXException, TransformerConfigurationException, TransformerException {
        Utility.transformToXML(new PDFXFAInput(pDFInteractiveForm, inputStream2), inputStream, outputByteBuffer);
        ByteStream byteStream = new ByteStream(outputByteBuffer.getBuffer());
        byte[] byArray = new byte[]{60, 120, 102, 97, 58, 100, 97, 116, 97, 115, 101, 116, 115};
        int[] nArray = new int[]{-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        long l = Utility.KMPFindFirst(byArray, nArray, byteStream);
        if (l == -1L) {
            throw new XFAParseException("missing datasets tag");
        }
        ByteStream byteStream2 = byteStream.slice(l, byteStream.limit() - l);
        return byteStream2;
    }

    public static InputStream getFullXFAStream(PDFInteractiveForm pDFInteractiveForm) {
        CosObject cosObject = pDFInteractiveForm.getXFA();
        if (cosObject == null) {
            return null;
        }
        return PDFFormSupport.AStreamComeTrue(cosObject);
    }

    private static InputStream AStreamComeTrue(CosObject cosObject) {
        switch (cosObject.getType()) {
            case 7: {
                return ((CosStream)cosObject).getStream();
            }
            case 4: {
                return new ByteStream(new ByteArrayByteRepository(((CosString)cosObject).byteArrayValue()));
            }
            case 5: {
                return new StreamsArray((CosArray)cosObject);
            }
        }
        throw new XFAParseException("invalid XFA entry");
    }
}

